# 画面設計書 8-TFLiteカメラ画面

## 概要

本ドキュメントは、TFLite DemoアプリにおけるCameraActivity（TFLiteカメラ画面）の画面設計書である。TensorFlow Liteモデルを使用した画像分類デモのメインActivityであり、Camera2BasicFragmentを表示するコンテナとして機能する。

### 本画面の処理概要

**業務上の目的・背景**：TensorFlow Liteの画像分類モデルをAndroidデバイス上で動作させるデモアプリケーションのメイン画面として本Activityが必要である。TF DemoアプリのCameraActivityとは異なる、軽量なTFLite専用のActivity実装であり、Camera2BasicFragmentに処理の大部分を委譲する構成となっている。

**画面へのアクセス方法**：Androidランチャーから直接起動される。ランチャーActivityとして登録されている。

**主要な操作・処理内容**：
1. onCreate()でactivity_camera.xmlレイアウトを設定
2. Camera2BasicFragment.newInstance()でFragmentを生成
3. FragmentManagerでR.id.containerにFragmentを配置
4. 初回起動時（savedInstanceState==null）のみFragment配置を実行

**画面遷移**：Androidランチャーから起動される。onCreate時にCamera2BasicFragmentをコンテナに配置する。他の画面への遷移機能は持たない。

**権限による表示制御**：権限管理はCamera2BasicFragment側で行われる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | TFLiteカメラプレビューフラグメント | 遷移先機能 | onCreateでCamera2BasicFragmentを生成・配置してカメラプレビューと分類処理を委譲 |

## 画面種別

コンテナ画面（Fragment配置のみ）

## URL/ルーティング

Androidネイティブアプリのため、URLベースのルーティングは存在しない。パッケージ: `com.example.android.tflitecamerademo`、クラス: `CameraActivity`。

## 入出力項目

| 項目名 | 入力/出力 | データ型 | 説明 |
|--------|----------|---------|------|
| savedInstanceState | 入力 | Bundle | Activity再生成時の保存状態（null時のみFragment配置） |

## 表示項目

| 項目名 | データ型 | 説明 |
|--------|---------|------|
| メインコンテナ | FrameLayout (container) | Camera2BasicFragmentを配置するコンテナ |

## イベント仕様

### 1-Activity生成イベント（onCreate）

処理フロー:
1. super.onCreate()呼び出し
2. setContentView(R.layout.activity_camera)でレイアウト設定
3. savedInstanceState==nullの場合のみ、Camera2BasicFragment.newInstance()を生成
4. FragmentManager.beginTransaction().replace(R.id.container, fragment).commit()で配置

## データベース更新仕様

### 操作別データベース影響一覧

本画面はデータベースを使用しない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| なし | なし | なし | データベース操作なし |

## メッセージ仕様

本画面ではメッセージ表示を行わない。

## 例外処理

本画面では例外処理は行わない（Fragment側に委譲）。

## 備考

- 非常にシンプルなActivity（35行）
- TF DemoアプリのCameraActivity（抽象クラス）とは無関係の独立した実装
- レイアウト: `activity_camera.xml`（TFLite Demo用）

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CameraActivity.java (TFLite) | `tensorflow/lite/java/demo/app/src/main/java/com/example/android/tflitecamerademo/CameraActivity.java` | onCreate()（25-34行目）: 全処理がここに集約。savedInstanceState判定→Fragment配置 |

**主要処理フロー**:
1. **27行目**: setContentView(R.layout.activity_camera)
2. **28行目**: savedInstanceState==null判定
3. **30-31行目**: Camera2BasicFragment.newInstance()生成→replace→commit

#### Step 2: 配置されるFragmentを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Camera2BasicFragment.java | `tensorflow/lite/java/demo/app/src/main/java/com/example/android/tflitecamerademo/Camera2BasicFragment.java` | 画面の実質的な処理はこのFragmentで実行される（画面No.9参照） |

### プログラム呼び出し階層図

```
CameraActivity (TFLite Demo)
    |
    +-- onCreate()
            +-- setContentView(activity_camera)
            +-- Camera2BasicFragment.newInstance()
            +-- fragmentManager.replace(R.id.container, fragment)
                    |
                    v
            Camera2BasicFragment [全処理を委譲]
```

### データフロー図

```
[入力]                [処理]                    [出力]

ランチャー起動 ---> onCreate() ---> Fragment配置 ---> Camera2BasicFragment
                   (Activity)    (R.id.container)    (カメラ+分類処理)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CameraActivity.java | `tensorflow/lite/java/demo/app/src/main/java/com/example/android/tflitecamerademo/CameraActivity.java` | ソース | メインActivity（Fragmentコンテナ） |
| Camera2BasicFragment.java | `tensorflow/lite/java/demo/app/src/main/java/com/example/android/tflitecamerademo/Camera2BasicFragment.java` | ソース | 実際のカメラ・分類処理Fragment |
| activity_camera.xml | `tensorflow/lite/java/demo/app/src/main/res/layout/activity_camera.xml` | レイアウト | メインActivityレイアウト |
