---
generated_at: 2026-02-02 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：1-画像分類画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **AndroidManifest.xmlのランチャー登録**：マニフェストファイルを直接確認していない
  2. **レイアウトXMLの具体的なView構成**：レイアウトXMLファイルを直接確認していない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `ClassifierActivity.java` 66-75行目（モデル定数定義）
- E-02: `ClassifierActivity.java` 111-120行目（TensorFlowImageClassifier.create呼び出し）
- E-03: `ClassifierActivity.java` 129-130行目（Bitmap生成）
- E-04: `ClassifierActivity.java` 150-176行目（processImage実装）
- E-05: `ClassifierActivity.java` 37行目（extends CameraActivity implements OnImageAvailableListener）
- E-06: `ClassifierActivity.java` 93-95行目（getLayoutId: camera_connection_fragment）
- E-07: `CameraActivity.java` 74-86行目（onCreate実装）
- E-08: `CameraActivity.java` 352-386行目（setFragment実装）
- E-09: `CameraActivity.java` 155-215行目（onImageAvailable実装）
- E-10: `CameraActivity.java` 286-304行目（権限チェック・リクエスト）
- E-11: `CameraActivity.java` 421-431行目（デバッグモード切り替え）
- E-12: `CameraActivity.java` 317-350行目（chooseCamera: Camera2判定）
- E-13: `ClassifierActivity.java` 80行目（DESIRED_PREVIEW_SIZE = 640x480）
- E-14: `ClassifierActivity.java` 183-214行目（renderDebug実装）
- E-15: `画面一覧.csv` No.1行
- E-16: `画面機能マッピング.csv` 画面No.1行
- E-17: `画面遷移図.md` TF Demoアプリセクション
- E-18: `CameraConnectionFragment.java` 496-562行目（createCameraPreviewSession）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CameraActivityを継承している | E-05 | ○ |
| C-02 | Inceptionモデル（tensorflow_inception_graph.pb）を使用 | E-01 | ○ |
| C-03 | 入力サイズは224x224 | E-01 (INPUT_SIZE=224) | ○ |
| C-04 | IMAGE_MEAN=117, IMAGE_STD=1 | E-01 | ○ |
| C-05 | TensorFlowImageClassifier.createでモデル初期化 | E-02 | ○ |
| C-06 | rgbFrameBitmapとcroppedBitmapを生成 | E-03 | ○ |
| C-07 | processImage()でYUV→RGB変換後にクロップしてrecognizeImage実行 | E-04 | ○ |
| C-08 | レイアウトはcamera_connection_fragment | E-06 | ○ |
| C-09 | DESIRED_PREVIEW_SIZEは640x480 | E-13 | ○ |
| C-10 | CameraActivityのonCreateでactivity_camera.xmlを設定 | E-07 | ○ |
| C-11 | setFragment()でCamera2/Legacyの分岐 | E-08, E-12 | ○ |
| C-12 | Camera2 APIのonImageAvailableでフレーム処理 | E-09 | ○ |
| C-13 | カメラ権限とストレージ権限が必要 | E-10 | ○ |
| C-14 | ボリュームキーでデバッグモード切り替え | E-11 | ○ |
| C-15 | デバッグモードでオーバーレイ情報表示 | E-14 | ○ |
| C-16 | ランチャーActivityとして登録 | E-15 | ○ |
| C-17 | 画像変換操作・TFLite推論エンジン等が関連機能 | E-16 | ○ |
| C-18 | CameraConnectionFragment/LegacyCameraConnectionFragmentを使用 | E-08, E-17 | ○ |
| C-19 | AndroidManifest.xmlでのランチャー登録の詳細 | **根拠なし** | △ |
| C-20 | activity_camera.xmlとcamera_connection_fragment.xmlの具体的なView構成 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- AndroidManifest.xmlを直接参照していないため、ランチャー登録の具体的なintent-filter設定は未確認
  - 候補：AndroidManifest.xml / build.gradle / テスト用マニフェスト
- レイアウトXMLファイルを直接参照していないため、ResultsView等の具体的なView IDや配置は画面一覧CSVの備考欄からの推測
  - 候補：activity_camera.xml / camera_connection_fragment.xml / styles.xml

## 5) リスクフラグ（レビュー観点）
- 0: モデルパラメータ（INPUT_SIZE, IMAGE_MEAN等）はソースコードから確認済みで低リスク
- 0: 処理フロー（YUV変換→クロップ→推論→表示）はソースコードから確認済みで低リスク
- 1: レイアウトXMLの具体的な構成はソースコード参照のみで中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] AndroidManifest.xmlでClassifierActivityがランチャーとして登録されていることを確認
- [ ] activity_camera.xmlとcamera_connection_fragment.xmlのView構成がドキュメントの記載と一致することを確認
- [ ] TensorFlowImageClassifierの実装がドキュメントの記載するインターフェース（recognizeImage等）と一致することを確認
- [ ] ResultsViewの実装が分類結果の表示仕様と一致することを確認
