---
generated_at: 2026-02-02 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：10-OVICベンチマーク画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **OvicBenchmarkerの内部実装詳細**：OvicBenchmarker.javaを直接確認していない
  2. **activity_main.xmlのView構成とonClick属性**：レイアウトファイルを直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `OvicBenchmarkerActivity.java` 42行目（extends Activity）
- E-02: `OvicBenchmarkerActivity.java` 57行目（WALL_TIME=3000）
- E-03: `OvicBenchmarkerActivity.java` 59行目（MAX_ITERATIONS=100）
- E-04: `OvicBenchmarkerActivity.java` 61行目（BIG_CORE_MASK=16）
- E-05: `OvicBenchmarkerActivity.java` 63行目（WAIT_TIME_FOR_AFFINITY=1000）
- E-06: `OvicBenchmarkerActivity.java` 75-81行目（onCreate: setContentView, textView取得）
- E-07: `OvicBenchmarkerActivity.java` 88-109行目（initializeTest）
- E-08: `OvicBenchmarkerActivity.java` 111-144行目（doTestIteration）
- E-09: `OvicBenchmarkerActivity.java` 146-152行目（detectPressed, classifyPressed）
- E-10: `OvicBenchmarkerActivity.java` 154-207行目（benchmarkSession）
- E-11: `OvicBenchmarkerActivity.java` 211-245行目（setProcessorAffinity）
- E-12: `OvicBenchmarkerActivity.java` 247-278行目（readCpusAllowedMask）
- E-13: `OvicBenchmarkerActivity.java` 90-94行目（分類: labels.txt, test_image_224.jpg, quantized_model.lite）
- E-14: `OvicBenchmarkerActivity.java` 96-99行目（検出: coco_labels.txt, test_image_224.jpg, detect.lite）
- E-15: `OvicBenchmarkerActivity.java` 195-200行目（結果テキスト生成: 平均レイテンシ計算）
- E-16: `画面一覧.csv` No.10行
- E-17: `画面機能マッピング.csv` 画面No.10行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | android.app.Activityを直接継承 | E-01 | ○ |
| C-02 | WALL_TIME=3000ms | E-02 | ○ |
| C-03 | MAX_ITERATIONS=100 | E-03 | ○ |
| C-04 | BIG_CORE_MASK=16 | E-04 | ○ |
| C-05 | onCreate()でactivity_main.xmlを設定 | E-06 (77行目) | ○ |
| C-06 | 分類: OvicClassifierBenchmarker, quantized_model.lite, labels.txt | E-07, E-13 | ○ |
| C-07 | 検出: OvicDetectorBenchmarker, detect.lite, coco_labels.txt | E-07, E-14 | ○ |
| C-08 | テスト画像: test_image_224.jpg | E-13, E-14 | ○ |
| C-09 | MappedByteBufferでモデル読み込み | E-07 (102-107行目) | ○ |
| C-10 | doTestIteration()でshouldStop→getReadyToTest→processBitmap | E-08 | ○ |
| C-11 | loadTestBitmap()でassetsからBitmapデコード | E-08 (83-86行目) | ○ |
| C-12 | testImageBitmap.recycle()でリソース解放 | E-08 (136行目) | ○ |
| C-13 | setProcessorAffinity()でtasksetコマンド実行 | E-11 | ○ |
| C-14 | readCpusAllowedMask()で/proc/self/statusから確認 | E-12 | ○ |
| C-15 | 平均レイテンシ: getTotalRuntimeNano()*1.0e-6/iter | E-15 | ○ |
| C-16 | benchmarkSession()で分類/検出を切り替え | E-10, E-09 | ○ |
| C-17 | classifyPressed/detectPressedはonClick属性で呼ばれる | E-09 | ○ |
| C-18 | "Benchmarker failed to run on more than one images."エラー表示 | E-10 (204行目) | ○ |
| C-19 | InterruptedException時はメッセージ追記してベンチマーク継続 | E-10 (182-185行目) | ○ |
| C-20 | DecimalFormat(".##")で小数点2桁表示 | E-01 (72行目) | ○ |
| C-21 | OvicBenchmarkerの内部実装（getTotalRuntimeNano等）の詳細 | **根拠なし** | △ |
| C-22 | activity_main.xmlのView構成（textView, classifyPressed, detectPressedボタン等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- OvicBenchmarker.java / OvicClassifierBenchmarker.java / OvicDetectorBenchmarker.javaの実装を直接参照していないため、processBitmap()やgetTotalRuntimeNano()の内部ロジックは未確認
  - 候補：OvicBenchmarker.java / OvicClassifierBenchmarker.java / OvicDetectorBenchmarker.java
- activity_main.xmlを直接参照していないため、textViewやボタンのView ID、onClick属性の設定は推測
  - 候補：activity_main.xml

## 5) リスクフラグ（レビュー観点）
- 0: ベンチマークループのフロー（初期化→反復→結果表示）はソースコードから確認済みで低リスク
- 0: CPUアフィニティ設定のコマンド実行はソースコードから確認済みで低リスク
- 1: OvicBenchmarkerの推論内部処理は中リスク
- 2: setProcessorAffinityでRuntime.exec()を使用しており、root権限が必要な環境依存処理は高リスク

## 6) レビュアーチェックリスト（最小）
- [ ] OvicBenchmarker.javaのprocessBitmap()とgetTotalRuntimeNano()の実装がドキュメントと一致することを確認
- [ ] activity_main.xmlにtextView ID、classifyPressed/detectPressedのonClick属性が設定されていることを確認
- [ ] assetsディレクトリにquantized_model.lite、detect.lite、test_image_224.jpgが存在することを確認
- [ ] setProcessorAffinity()がRoot権限なし環境でどのように動作するか確認
