---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：12-デリゲート性能ベンチマーク（レイテンシ）画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **Intent起動コマンド例のフォーマット**：adb shell amコマンドの引数形式は推定に基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/BenchmarkLatencyActivity.java` (56行)
- E-02: `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/BenchmarkLatencyImpl.java` (215行)
- E-03: `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/DelegatePerformanceBenchmark.java` (258行)
- E-04: `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/AndroidManifest.xml` (55行)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (13行目)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (39-40行目)
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` (76-99行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UIなしのActivity（noHistory指定） | E-04 (43行目 `android:noHistory="true"`) | ○ |
| C-02 | --tflite_settings_filesキーでString[]を取得 | E-01 (34行目, 44行目) | ○ |
| C-03 | --argsキーでString[]を取得 | E-01 (35行目, 45行目) | ○ |
| C-04 | BenchmarkLatencyImplに処理を委譲 | E-01 (47-50行目) | ○ |
| C-05 | initialize()で結果フォルダを作成 | E-02 (96-103行目) | ○ |
| C-06 | JSON/CSV/HTMLの3形式でレポート出力 | E-02 (101-103行目) | ○ |
| C-07 | デフォルトレイテンシ基準をprotoファイルからロード | E-02 (110-112行目, 209-213行目) | ○ |
| C-08 | benchmark()でassetsのlatencyフォルダからモデルをリスト | E-02 (130-135行目) | ○ |
| C-09 | .tfliteモデルファイルに対してベンチマーク実行 | E-02 (136-139行目) | ○ |
| C-10 | report.export()で結果をエクスポート | E-02 (142行目) | ○ |
| C-11 | テストターゲットデリゲートがリスト末尾に配置される | E-03 (154-173行目) | ○ |
| C-12 | デフォルトデリゲートが先頭に追加される | E-03 (145-153行目) | ○ |
| C-13 | delegate_performance_benchmarkネイティブライブラリをロード | E-03 (42-44行目) | ○ |
| C-14 | latencyBenchmarkNativeRun()でJNI呼び出し | E-03 (85-91行目, 246-252行目) | ○ |
| C-15 | READ/WRITE_EXTERNAL_STORAGE権限が必要 | E-04 (23-24行目) | ○ |
| C-16 | minSdkVersion=23、targetSdkVersion=33 | E-04 (30-31行目) | ○ |
| C-17 | startup overhead latencyの計算式 | E-02 (54-55行目 JavaDoc) | ○ |
| C-18 | average inference latencyの定義 | E-02 (56行目 JavaDoc) | ○ |
| C-19 | 関連機能No.81（TFLite推論エンジン）が主機能 | E-06 (39行目) | ○ |
| C-20 | 関連機能No.82（TFLiteデリゲート）が主機能 | E-06 (40行目) | ○ |
| C-21 | tfliteSettingsJsonFilesがnull/空の場合initialize失敗 | E-02 (92-95行目) | ○ |
| C-22 | adb shellコマンドの具体的な引数フォーマット | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-22のadb shellコマンドの引数フォーマットはREADME.mdの記載に基づく推定であり、AndroidのIntent起動コマンドのString[]渡し方法（--esa）の正確性は別途確認が必要
  - 候補：README.md / Android開発ドキュメント / テストスクリプト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから読み取れる処理フローは正確に記述されている
- 1: 中リスク - レポート出力先パスの正確性は実機検証が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] BenchmarkLatencyActivity.javaのonCreateメソッドの処理フローが設計書と一致しているか
- [ ] BenchmarkLatencyImpl.javaのinitialize()とbenchmark()の処理が正確に記述されているか
- [ ] DelegatePerformanceBenchmark.javaのTfLiteSettingsリスト構築ロジックが正確か
- [ ] レポート出力形式（CSV/JSON/HTML）と出力先パスが正確か
- [ ] レイテンシ判定メトリクスの定義が正確か
