---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 23
  claims_with_evidence: 22
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：13-デリゲート性能ベンチマーク（精度）画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：22 / 23、根拠なし：1
- 優先レビュー（高）
  1. **Intent起動コマンド例のフォーマット**：adb shell amコマンドの引数形式は推定に基づく

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/BenchmarkAccuracyActivity.java` (46行)
- E-02: `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/BenchmarkAccuracyImpl.java` (178行)
- E-03: `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/src/main/java/org/tensorflow/lite/benchmark/delegateperformance/DelegatePerformanceBenchmark.java` (258行)
- E-04: `tensorflow/lite/tools/benchmark/experimental/delegate_performance/android/AndroidManifest.xml` (55行)
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` (14行目)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (41-42行目)
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` (76-99行目)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UIなしのActivity（noHistory指定） | E-04 (50-51行目 `android:noHistory="true"`) | ○ |
| C-02 | --tflite_settings_filesキーでString[]を取得 | E-01 (34行目, 43行目) | ○ |
| C-03 | BenchmarkAccuracyImplに処理を委譲 | E-01 (44行目) | ○ |
| C-04 | BenchmarkAccuracyImplがBenchmarkAccuracyインターフェースを実装 | E-02 (58行目 `implements BenchmarkAccuracy`) | ○ |
| C-05 | benchmark()内でactivity.finish()が呼ばれる | E-02 (69行目 `Activity activity = (Activity) context`、73行目 `activity.finish()`) | ○ |
| C-06 | benchmarkInternal()→initialize()→benchmarkDelegatesAndExportReport()の呼び出しチェーン | E-02 (76-82行目) | ○ |
| C-07 | initialize()で結果フォルダを作成 | E-02 (164-171行目) | ○ |
| C-08 | JSON/CSV/HTMLの3形式でレポート出力 | E-02 (169-171行目) | ○ |
| C-09 | assetsのaccuracyフォルダからモデルをリスト | E-02 (96-101行目) | ○ |
| C-10 | .tflite以外のファイルをスキップ | E-02 (103-105行目) | ○ |
| C-11 | モデルごとに個別の結果フォルダを作成 | E-02 (110-112行目) | ○ |
| C-12 | runAccuracyBenchmark()でMiniBenchmarkベースの実行 | E-03 (117-133行目) | ○ |
| C-13 | BenchmarkEvent FlatBufferで結果を受け取る | E-03 (131-132行目) | ○ |
| C-14 | report.export()で結果をエクスポート | E-02 (140行目) | ○ |
| C-15 | PASS/PASS_WITH_WARNING/FAILの3段階判定 | E-02 (36-43行目 JavaDoc) | ○ |
| C-16 | PASSの定義：テストターゲットが全モデルの閾値をパス | E-02 (39行目 JavaDoc) | ○ |
| C-17 | PASS_WITH_WARNINGの定義：両方が閾値超過 | E-02 (40-41行目 JavaDoc) | ○ |
| C-18 | FAILの定義：テストターゲットが失敗かつ参照が全パス | E-02 (42-43行目 JavaDoc) | ○ |
| C-19 | --args引数は受け付けない（レイテンシとの差異） | E-01 (34-35行目に`--args`キー宣言がない) | ○ |
| C-20 | delegate_performance_benchmarkネイティブライブラリを共有 | E-03 (43行目) | ○ |
| C-21 | READ/WRITE_EXTERNAL_STORAGE権限が必要 | E-04 (23-24行目) | ○ |
| C-22 | 関連機能No.81/82が主機能 | E-06 (41-42行目) | ○ |
| C-23 | adb shellコマンドの具体的な引数フォーマット | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-23のadb shellコマンドの引数フォーマットはAndroidのIntent起動コマンドのString[]渡し方法（--esa）の推定に基づく
  - 候補：README.md / Android開発ドキュメント / テストスクリプト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから読み取れる処理フローは正確に記述されている
- 0: 低リスク - PASS/PASS_WITH_WARNING/FAILの判定定義はJavaDocから正確に抽出されている

## 6) レビュアーチェックリスト（最小）
- [ ] BenchmarkAccuracyActivity.javaのonCreateメソッドの処理フローが設計書と一致しているか
- [ ] BenchmarkAccuracyImpl.javaのbenchmark()→benchmarkInternal()の委譲チェーンが正確か
- [ ] activity.finish()の呼び出し元がBenchmarkAccuracyImpl内である点が正確か
- [ ] PASS/PASS_WITH_WARNING/FAILの判定基準がJavaDocと一致しているか
- [ ] レイテンシベンチマーク（No.12）との差異（--args非対応、モデル別フォルダ作成）が正確か
