---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：2-物体検出画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **MultiBoxTrackerの内部動作詳細**：追跡器の実装を直接確認していない
  2. **camera_connection_fragment_tracking.xmlの構成**：レイアウトファイルを直接参照していない

## 2) 参照した情報（Evidence一覧）

- E-01: `DetectorActivity.java` 52-76行目（モデル定数定義）
- E-02: `DetectorActivity.java` 81-84行目（DetectorMode enum定義）
- E-03: `DetectorActivity.java` 87-89行目（最小信頼度閾値）
- E-04: `DetectorActivity.java` 120-240行目（onPreviewSizeChosen実装）
- E-05: `DetectorActivity.java` 244-331行目（processImage実装）
- E-06: `DetectorActivity.java` 334-336行目（getLayoutId: camera_connection_fragment_tracking）
- E-07: `DetectorActivity.java` 48行目（extends CameraActivity）
- E-08: `DetectorActivity.java` 114行目（MultiBoxTracker初期化）
- E-09: `CameraActivity.java` 352-386行目（setFragment実装）
- E-10: `画面一覧.csv` No.2行
- E-11: `画面機能マッピング.csv` 画面No.2行
- E-12: `画面遷移図.md` TF Demoアプリセクション

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CameraActivityを継承している | E-07 | ○ |
| C-02 | 3種類の検出モード（TF_OD_API/MULTIBOX/YOLO）に対応 | E-02 | ○ |
| C-03 | デフォルトモードはTF_OD_API | E-02 (MODE=DetectorMode.TF_OD_API) | ○ |
| C-04 | SSD MobileNet v1モデルを使用 | E-01 (TF_OD_API_MODEL_FILE) | ○ |
| C-05 | MultiBoxモデルを使用 | E-01 (MB_MODEL_FILE) | ○ |
| C-06 | YOLOモデルを使用 | E-01 (YOLO_MODEL_FILE) | ○ |
| C-07 | 最小信頼度: TF_OD_API=0.6, MULTIBOX=0.1, YOLO=0.25 | E-03 | ○ |
| C-08 | 入力サイズ: TF_OD_API=300, MULTIBOX=224, YOLO=416 | E-01 | ○ |
| C-09 | MultiBoxTrackerで追跡処理を実行 | E-08, E-05 | ○ |
| C-10 | computingDetectionフラグで排他制御 | E-05 (259-263行目) | ○ |
| C-11 | trackingOverlayに追跡結果を描画 | E-04 (186-196行目) | ○ |
| C-12 | luminanceCopyに輝度データをコピー | E-05 (268-271行目) | ○ |
| C-13 | cropToFrameTransformで座標逆変換 | E-05 (318行目) | ○ |
| C-14 | レイアウトはcamera_connection_fragment_tracking | E-06 | ○ |
| C-15 | DESIRED_PREVIEW_SIZEは640x480 | E-04 (93行目) | ○ |
| C-16 | IOException発生時にToast表示してfinish() | E-04 (157-164行目) | ○ |
| C-17 | ランチャーActivityとして登録 | E-10 | ○ |
| C-18 | Camera2/Legacyフラグメントの分岐使用 | E-09, E-12 | ○ |
| C-19 | 検出結果をフィルタリング後にtrackResults()に渡す | E-05 (310-324行目) | ○ |
| C-20 | バウンディングボックスを赤色で描画 | E-05 (292-295行目) | ○ |
| C-21 | MultiBoxTrackerの追跡アルゴリズムの詳細 | **根拠なし** | △ |
| C-22 | camera_connection_fragment_tracking.xmlのView構成詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- MultiBoxTracker.javaの実装を直接参照していないため、追跡アルゴリズムの詳細（フレーム間のオブジェクトマッチング方式等）は未確認
  - 候補：MultiBoxTracker.java / ObjectTracker.java
- レイアウトファイルcamera_connection_fragment_tracking.xmlを直接参照していないため、tracking_overlayのView構成は推測
  - 候補：camera_connection_fragment_tracking.xml

## 5) リスクフラグ（レビュー観点）
- 0: 3種類のモデル定数と切り替えロジックはソースコードから確認済みで低リスク
- 0: processImage()の処理フローはソースコードから詳細に確認済みで低リスク
- 1: MultiBoxTrackerの内部動作は中リスク（呼び出しは確認済みだが内部ロジックは未確認）

## 6) レビュアーチェックリスト（最小）
- [ ] MultiBoxTracker.javaの追跡アルゴリズムがドキュメントの記載と矛盾しないことを確認
- [ ] camera_connection_fragment_tracking.xmlにtracking_overlay IDのOverlayViewが含まれることを確認
- [ ] 3種類の検出モデルファイルがassetsディレクトリに存在することを確認
