---
generated_at: 2026-02-02 10:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：4-音声認識画面

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **RecognizeCommandsの内部ロジック詳細**：平滑化アルゴリズムの実装を直接確認していない
  2. **activity_speech.xmlのView構成**：レイアウトファイルを直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `SpeechActivity.java` 67-79行目（定数定義）
- E-02: `SpeechActivity.java` 61行目（extends Activity）
- E-03: `SpeechActivity.java` 101-158行目（onCreate実装）
- E-04: `SpeechActivity.java` 202-253行目（record実装）
- E-05: `SpeechActivity.java` 279-353行目（recognize実装）
- E-06: `SpeechActivity.java` 160-165行目（requestMicrophonePermission）
- E-07: `SpeechActivity.java` 178-192行目（startRecording）
- E-08: `SpeechActivity.java` 255-269行目（startRecognition）
- E-09: `SpeechActivity.java` 88-98行目（リングバッファ・ロック定義）
- E-10: `SpeechActivity.java` 106-113行目（quitButton処理）
- E-11: `画面一覧.csv` No.4行
- E-12: `画面機能マッピング.csv` 画面No.4行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | android.app.Activityを直接継承（CameraActivityではない） | E-02 | ○ |
| C-02 | conv_actions_frozen.pbモデルを使用 | E-01 (MODEL_FILENAME) | ○ |
| C-03 | サンプルレート16000Hz | E-01 (SAMPLE_RATE=16000) | ○ |
| C-04 | 録音長1000ms（16000サンプル） | E-01 (SAMPLE_DURATION_MS=1000, RECORDING_LENGTH) | ○ |
| C-05 | TFノード: decoded_sample_data:0, decoded_sample_data:1, labels_softmax | E-01 | ○ |
| C-06 | DETECTION_THRESHOLD=0.70 | E-01 | ○ |
| C-07 | AVERAGE_WINDOW_DURATION_MS=500 | E-01 | ○ |
| C-08 | SUPPRESSION_MS=1500, MINIMUM_COUNT=3 | E-01 | ○ |
| C-09 | リングバッファ（recordingBuffer[16000]）を使用 | E-09 | ○ |
| C-10 | ReentrantLockで排他制御 | E-09 | ○ |
| C-11 | AudioRecord（DEFAULT, 16kHz, MONO, PCM_16BIT） | E-04 (214-220行目) | ○ |
| C-12 | short→float変換: /32767.0f | E-05 (307行目) | ○ |
| C-13 | TF feed/run/fetchで推論実行 | E-05 (311-314行目) | ○ |
| C-14 | RecognizeCommands.processLatestResults()で結果平滑化 | E-05 (318-319行目) | ○ |
| C-15 | アンダースコアで始まるラベルは表示除外 | E-03 (127行目) | ○ |
| C-16 | AnimatorSetでハイライトアニメーション | E-05 (335-340行目) | ○ |
| C-17 | 終了ボタンでProcess.killProcess() | E-10 | ○ |
| C-18 | MINIMUM_TIME_BETWEEN_SAMPLES_MS=30ms間スリープ | E-05 (346行目) | ○ |
| C-19 | マイク権限リクエスト（Android M以上） | E-06 | ○ |
| C-20 | 録音/認識の2スレッド構成 | E-07, E-08 | ○ |
| C-21 | RecognizeCommandsの平滑化アルゴリズム詳細 | **根拠なし** | △ |
| C-22 | activity_speech.xmlのView ID構成 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- RecognizeCommands.javaの実装を直接参照していないため、平滑化アルゴリズムの内部ロジック（時間窓ベースの平均化方式等）は未確認
  - 候補：RecognizeCommands.java
- activity_speech.xmlを直接参照していないため、list_viewやquit等のView IDの配置は推測
  - 候補：activity_speech.xml

## 5) リスクフラグ（レビュー観点）
- 0: 録音処理（AudioRecord設定、リングバッファ）はソースコードから確認済みで低リスク
- 0: TF推論パラメータはソースコードから確認済みで低リスク
- 1: RecognizeCommandsの内部ロジックは中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] RecognizeCommands.javaのprocessLatestResults()がドキュメントの平滑化仕様と一致することを確認
- [ ] activity_speech.xmlにlist_viewとquit IDが存在することを確認
- [ ] conv_actions_labels.txtの内容とdisplayedLabelsの除外ロジックを確認
