---
generated_at: 2026-02-02 10:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：5-カメラベース画面（抽象）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **activity_camera.xmlのView ID構成**：レイアウトファイルを直接参照していない

## 2) 参照した情報（Evidence一覧）

- E-01: `CameraActivity.java` 48-49行目（abstract class宣言、implements）
- E-02: `CameraActivity.java` 57-71行目（フィールド変数定義）
- E-03: `CameraActivity.java` 74-86行目（onCreate実装）
- E-04: `CameraActivity.java` 90-101行目（getRgbBytes, getLuminanceStride, getLuminance）
- E-05: `CameraActivity.java` 107-149行目（onPreviewFrame実装）
- E-06: `CameraActivity.java` 155-215行目（onImageAvailable実装）
- E-07: `CameraActivity.java` 224-231行目（onResume: HandlerThread開始）
- E-08: `CameraActivity.java` 234-252行目（onPause: finish, HandlerThread終了）
- E-09: `CameraActivity.java` 266-270行目（runInBackground）
- E-10: `CameraActivity.java` 286-304行目（hasPermission, requestPermission）
- E-11: `CameraActivity.java` 307-315行目（isHardwareLevelSupported）
- E-12: `CameraActivity.java` 317-350行目（chooseCamera）
- E-13: `CameraActivity.java` 352-386行目（setFragment）
- E-14: `CameraActivity.java` 388-399行目（fillBytes）
- E-15: `CameraActivity.java` 401-417行目（isDebug, requestRender, addCallback）
- E-16: `CameraActivity.java` 421-431行目（onKeyDown: デバッグ切替）
- E-17: `CameraActivity.java` 452-457行目（抽象メソッド定義）
- E-18: `画面一覧.csv` No.5行
- E-19: `画面機能マッピング.csv` 画面No.5行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 抽象クラスでありOnImageAvailableListenerとCamera.PreviewCallbackを実装 | E-01 | ○ |
| C-02 | 直接起動されない | E-18 (備考: 抽象クラス。直接起動されない) | ○ |
| C-03 | CAMERA/WRITE_EXTERNAL_STORAGEの2権限を管理 | E-10 | ○ |
| C-04 | chooseCamera()で背面カメラを選択 | E-12 (324-326行目) | ○ |
| C-05 | useCamera2APIはEXTERNALまたはFULLレベル以上で有効 | E-12 (339-341行目) | ○ |
| C-06 | setFragment()でCamera2/Legacy分岐 | E-13 | ○ |
| C-07 | onImageAvailable()でYUV_420_888フレーム処理 | E-06 | ○ |
| C-08 | onPreviewFrame()でYUV420SPフレーム処理 | E-05 | ○ |
| C-09 | fillBytes()でPlane→byte[]変換 | E-14 | ○ |
| C-10 | imageConverterで遅延YUV→RGB変換 | E-05 (132-138行目), E-06 (182-197行目) | ○ |
| C-11 | isProcessingFrameで排他制御 | E-05 (108-111行目), E-06 (170-173行目) | ○ |
| C-12 | HandlerThread "inference"でバックグラウンド実行 | E-07, E-09 | ○ |
| C-13 | onPauseでfinish()呼び出し | E-08 (239行目) | ○ |
| C-14 | ボリュームキーでデバッグ切替 | E-16 | ○ |
| C-15 | OverlayViewへのコールバック登録 | E-15 | ○ |
| C-16 | 抽象メソッド4つ: processImage, onPreviewSizeChosen, getLayoutId, getDesiredPreviewFrameSize | E-17 | ○ |
| C-17 | getRgbBytes()でimageConverter実行 | E-04 | ○ |
| C-18 | setContentView(activity_camera) | E-03 (79行目) | ○ |
| C-19 | R.id.containerにFragment配置 | E-13 (384行目) | ○ |
| C-20 | activity_camera.xmlのView ID構成（container, debug_overlay等）の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- activity_camera.xmlを直接参照していないため、container、debug_overlay等のView IDの実際の定義は未確認
  - 候補：activity_camera.xml

## 5) リスクフラグ（レビュー観点）
- 0: フレーム処理パイプライン（YUV取得→変換→processImage）はソースコードから詳細に確認済みで低リスク
- 0: Camera2/Legacy分岐ロジックはソースコードから確認済みで低リスク
- 0: 権限管理ロジックはソースコードから確認済みで低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] activity_camera.xmlにcontainerとdebug_overlay IDが存在することを確認
- [ ] ImageUtils.convertYUV420ToARGB8888とconvertYUV420SPToARGB8888の引数がコードと一致することを確認
