---
generated_at: 2026-02-02 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：6-カメラ接続フラグメント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **AutoFitTextureViewの実装詳細**：AutoFitTextureView.javaを直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `CameraConnectionFragment.java` 64行目（extends Fragment）
- E-02: `CameraConnectionFragment.java` 71行目（MINIMUM_PREVIEW_SIZE=320）
- E-03: `CameraConnectionFragment.java` 117-119行目（ConnectionCallback定義）
- E-04: `CameraConnectionFragment.java` 230-239行目（コンストラクタ）
- E-05: `CameraConnectionFragment.java` 268-307行目（chooseOptimalSize）
- E-06: `CameraConnectionFragment.java` 309-315行目（newInstance）
- E-07: `CameraConnectionFragment.java` 363-408行目（setUpCameraOutputs）
- E-08: `CameraConnectionFragment.java` 413-428行目（openCamera）
- E-09: `CameraConnectionFragment.java` 496-562行目（createCameraPreviewSession）
- E-10: `CameraConnectionFragment.java` 155-182行目（stateCallback）
- E-11: `CameraConnectionFragment.java` 90-111行目（surfaceTextureListener）
- E-12: `CameraConnectionFragment.java` 433-453行目（closeCamera）
- E-13: `CameraConnectionFragment.java` 572-596行目（configureTransform）
- E-14: `画面一覧.csv` No.6行
- E-15: `画面機能マッピング.csv` 画面No.6行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Fragmentを継承 | E-01 | ○ |
| C-02 | MINIMUM_PREVIEW_SIZE=320 | E-02 | ○ |
| C-03 | ConnectionCallbackインターフェース定義 | E-03 | ○ |
| C-04 | newInstance()で4引数を受け取り生成 | E-06, E-04 | ○ |
| C-05 | chooseOptimalSize()で最適サイズ選択 | E-05 | ○ |
| C-06 | setUpCameraOutputs()でYUV_420_888出力設定 | E-07 | ○ |
| C-07 | sensorOrientationをCameraCharacteristicsから取得 | E-07 (378行目) | ○ |
| C-08 | ConnectionCallback.onPreviewSizeChosen()を呼び出し | E-07 (407行目) | ○ |
| C-09 | ImageReader: YUV_420_888, maxImages=2 | E-09 (514-516行目) | ○ |
| C-10 | AF_MODE_CONTINUOUS_PICTURE設定 | E-09 (537-539行目) | ○ |
| C-11 | AE_MODE_ON_AUTO_FLASH設定 | E-09 (541-542行目) | ○ |
| C-12 | Semaphore(1)で排他制御、2500msタイムアウト | E-08 (419-420行目), E-12 | ○ |
| C-13 | stateCallback.onOpened()でcreateCameraPreviewSession() | E-10 (162行目) | ○ |
| C-14 | BackgroundThread名 "ImageListener" | E-09 (459行目相当) | ○ |
| C-15 | configureTransform()でテクスチャ回転処理 | E-13 | ○ |
| C-16 | ErrorDialogでCamera2非対応エラー表示 | E-07 (402-404行目) | ○ |
| C-17 | onPauseでcloseCamera+stopBackgroundThread | E-12 | ○ |
| C-18 | AutoFitTextureViewの実装詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- AutoFitTextureView.javaを直接参照していないため、アスペクト比自動調整の実装詳細は未確認
  - 候補：AutoFitTextureView.java

## 5) リスクフラグ（レビュー観点）
- 0: Camera2 APIの使用パターン（デバイスオープン→セッション→プレビュー）はソースコードから確認済みで低リスク
- 0: ImageReaderの設定はソースコードから確認済みで低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] AutoFitTextureView.javaのsetAspectRatio()実装を確認
- [ ] camera_connection_fragment.xmlにtexture IDのAutoFitTextureViewが存在することを確認
