---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：7-レガシーカメラ接続フラグメント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **camera_connection_fragment.xmlのView構成**：レイアウトファイルを直接参照していない

## 2) 参照した情報（Evidence一覧）

- E-01: `LegacyCameraConnectionFragment.java` 39行目（extends Fragment）
- E-02: `LegacyCameraConnectionFragment.java` 50-55行目（コンストラクタ）
- E-03: `LegacyCameraConnectionFragment.java` 73-126行目（surfaceTextureListener）
- E-04: `LegacyCameraConnectionFragment.java` 79-80行目（getCameraId, Camera.open）
- E-05: `LegacyCameraConnectionFragment.java` 83-100行目（パラメータ設定）
- E-06: `LegacyCameraConnectionFragment.java` 96-97行目（chooseOptimalSize利用）
- E-07: `LegacyCameraConnectionFragment.java` 99行目（setDisplayOrientation(90)）
- E-08: `LegacyCameraConnectionFragment.java` 106-108行目（setPreviewCallbackWithBuffer、バッファ割り当て）
- E-09: `LegacyCameraConnectionFragment.java` 198-205行目（stopCamera）
- E-10: `LegacyCameraConnectionFragment.java` 207-216行目（getCameraId: CAMERA_FACING_BACK）
- E-11: `LegacyCameraConnectionFragment.java` 180-183行目（startBackgroundThread: "CameraBackground"）
- E-12: `画面一覧.csv` No.7行
- E-13: `画面機能マッピング.csv` 画面No.7行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Fragmentを継承 | E-01 | ○ |
| C-02 | コンストラクタで3引数（imageListener, layout, desiredSize） | E-02 | ○ |
| C-03 | getCameraId()でCAMERA_FACING_BACKを選択 | E-10 | ○ |
| C-04 | Camera.open(index)でカメラオープン | E-04 | ○ |
| C-05 | FOCUS_MODE_CONTINUOUS_PICTURE設定 | E-05 (87行目) | ○ |
| C-06 | CameraConnectionFragment.chooseOptimalSize()を利用 | E-06 | ○ |
| C-07 | setDisplayOrientation(90)で表示回転固定 | E-07 | ○ |
| C-08 | setPreviewCallbackWithBuffer(imageListener) | E-08 | ○ |
| C-09 | ImageUtils.getYUVByteSize()でバッファ割り当て | E-08 (108行目) | ○ |
| C-10 | textureView.setAspectRatio(s.height, s.width) | E-03 (110行目) | ○ |
| C-11 | stopCamera()でstopPreview→setPreviewCallback(null)→release | E-09 | ○ |
| C-12 | BackgroundThread名 "CameraBackground" | E-11 | ○ |
| C-13 | IOException時にcamera.release() | E-03 (102-104行目) | ○ |
| C-14 | onPauseでstopCamera+stopBackgroundThread | E-09 (171-175行目) | ○ |
| C-15 | 旧Camera API（android.hardware.Camera）使用 | E-01, E-03 | ○ |
| C-16 | camera_connection_fragment.xmlのView構成 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- camera_connection_fragment.xmlを直接参照していないため、texture IDのAutoFitTextureViewの配置は推測
  - 候補：camera_connection_fragment.xml

## 5) リスクフラグ（レビュー観点）
- 0: 旧Camera APIの使用パターンはソースコードから確認済みで低リスク
- 0: chooseOptimalSize()の呼び出しはソースコードから確認済みで低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] camera_connection_fragment.xmlにtexture IDのAutoFitTextureViewが存在することを確認
