---
generated_at: 2026-02-02 10:40:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：9-TFLiteカメラプレビューフラグメント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **ImageClassifierの抽象クラス実装詳細**：ImageClassifier.javaを直接確認していない
  2. **fragment_camera2_basic.xmlのView構成**：レイアウトファイルを直接確認していない

## 2) 参照した情報（Evidence一覧）

- E-01: `Camera2BasicFragment.java` 75-76行目（extends Fragment implements OnRequestPermissionsResultCallback）
- E-02: `Camera2BasicFragment.java` 312-314行目（newInstance）
- E-03: `Camera2BasicFragment.java` 318-321行目（onCreateView: fragment_camera2_basic）
- E-04: `Camera2BasicFragment.java` 381-445行目（onViewCreated）
- E-05: `Camera2BasicFragment.java` 323-378行目（updateActiveModel）
- E-06: `Camera2BasicFragment.java` 676-686行目（startBackgroundThread: periodicClassify開始）
- E-07: `Camera2BasicFragment.java` 704-715行目（periodicClassify）
- E-08: `Camera2BasicFragment.java` 808-820行目（classifyFrame）
- E-09: `Camera2BasicFragment.java` 88-89行目（runClassifier, lock）
- E-10: `Camera2BasicFragment.java` 98-101行目（MAX_PREVIEW_WIDTH/HEIGHT）
- E-11: `Camera2BasicFragment.java` 354-356行目（QuantizedMobileNet / FloatMobileNet生成）
- E-12: `Camera2BasicFragment.java` 371-376行目（setNumThreads, useGpu, useNNAPI）
- E-13: `Camera2BasicFragment.java` 477-483行目（onDestroy: classifier.close()）
- E-14: `Camera2BasicFragment.java` 613-634行目（openCamera）
- E-15: `画面一覧.csv` No.9行
- E-16: `画面機能マッピング.csv` 画面No.9行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Fragmentを継承しOnRequestPermissionsResultCallbackを実装 | E-01 | ○ |
| C-02 | newInstance()ファクトリメソッドで生成 | E-02 | ○ |
| C-03 | fragment_camera2_basicレイアウトを使用 | E-03 | ○ |
| C-04 | モデル選択: QuantizedMobileNet / FloatMobileNet | E-05, E-11 | ○ |
| C-05 | デバイス選択: CPU / GPU / NNAPI | E-04, E-12 | ○ |
| C-06 | NumberPickerでスレッド数（1-10） | E-04 (432-442行目) | ○ |
| C-07 | periodicClassifyで定期的に分類実行 | E-07 | ○ |
| C-08 | periodicClassifyは自己再スケジュール | E-07 (713行目) | ○ |
| C-09 | classifyFrame()でtextureView.getBitmap→classifyFrame→showToast | E-08 | ○ |
| C-10 | lockオブジェクトでrunClassifier同期 | E-09, E-07 | ○ |
| C-11 | MAX_PREVIEW_WIDTH=1920, MAX_PREVIEW_HEIGHT=1080 | E-10 | ○ |
| C-12 | バックグラウンドスレッド開始時にupdateActiveModel | E-06 (685行目) | ○ |
| C-13 | updateActiveModelでclassifier.close()後に再生成 | E-05 (341-344行目) | ○ |
| C-14 | useGpu()/useNNAPI()でデリゲート切り替え | E-12 | ○ |
| C-15 | onDestroy()でclassifier.close() | E-13 | ○ |
| C-16 | FragmentCompat.requestPermissions()で権限リクエスト | E-14 (615行目) | ○ |
| C-17 | Semaphore(1)で2500msタイムアウトカメラオープン | E-14 (625-626行目) | ○ |
| C-18 | updateActiveModelのIOException処理 | E-05 (361-364行目) | ○ |
| C-19 | "Failed to load model"メッセージ | E-05 (359行目) | ○ |
| C-20 | HANDLE_THREAD_NAME="CameraBackground" | E-01 (83行目) | ○ |
| C-21 | ImageClassifierの抽象クラス構造の詳細 | **根拠なし** | △ |
| C-22 | fragment_camera2_basic.xmlのView ID構成（texture, text, device, model, np） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ImageClassifier.javaの実装を直接参照していないため、classifyFrame()、getImageSizeX/Y()等の内部ロジックは未確認
  - 候補：ImageClassifier.java / ImageClassifierQuantizedMobileNet.java / ImageClassifierFloatMobileNet.java
- fragment_camera2_basic.xmlを直接参照していないため、texture/text/device/model/np等のView IDは推測
  - 候補：fragment_camera2_basic.xml

## 5) リスクフラグ（レビュー観点）
- 0: UI操作→updateActiveModel→分類器切り替えのフローはソースコードから確認済みで低リスク
- 0: periodicClassify→classifyFrame→TextViewの表示フローはソースコードから確認済みで低リスク
- 1: ImageClassifierの内部実装は中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] ImageClassifier.javaのclassifyFrame()がSpannableStringBuilderに結果を書き込むことを確認
- [ ] fragment_camera2_basic.xmlにtexture/text/device/model/npのView IDが存在することを確認
- [ ] ImageClassifierQuantizedMobileNet/FloatMobileNetのモデルファイルパスを確認
