# 通知設計書 10-TensorBoard

## 概要

本ドキュメントは、TensorFlow Kerasの`TensorBoard`コールバックに関する通知設計書である。`TensorBoard`はTensorBoard用のイベントログ（メトリクス、グラフ、ヒストグラム、プロファイリング等）を出力する。

### 本通知の処理概要

`TensorBoard`は、トレーニング中のメトリクス、モデルグラフ、重みヒストグラム、プロファイリング情報等をTensorBoardで可視化可能なイベントログ形式でディスクに書き出すコールバックである。

**業務上の目的・背景**：TensorBoardはTensorFlowに付属する可視化ツールであり、トレーニングの進捗監視、モデル構造の理解、性能ボトルネックの特定等に広く使用される。`TensorBoard`コールバックはこれらの可視化に必要なデータを自動的にイベントログとして出力する。

**通知の送信タイミング**：エポック終了時（`on_epoch_end`）にメトリクスサマリーとヒストグラムを出力する。バッチ単位（`update_freq`が整数の場合）ではバッチごとにサマリーを出力する。プロファイリングは`profile_batch`で指定されたバッチ範囲で実行する。

**通知の受信者**：ファイルシステム（`log_dir`に指定されたディレクトリへのイベントファイル書き出し）。TensorBoardツールがこれらのファイルを読み込んで可視化する。

**通知内容の概要**：メトリクスサマリー（loss、accuracy等のスカラー値）、モデルグラフ構造、重み/活性化ヒストグラム、プロファイリング結果、Embedding可視化データ、学習率推移、ステップ/秒パフォーマンス。

**期待されるアクション**：ユーザが`tensorboard --logdir=log_dir`コマンドでTensorBoardを起動し、ブラウザでトレーニング状況を可視化・分析する。

## 通知種別

ファイル出力通知（TensorBoardイベントログファイルの書き出し）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期/非同期混合（SummaryWriterが内部でバッファリング） |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

`log_dir`引数で指定されたディレクトリ配下に`train/`と`validation/`サブディレクトリを作成し、それぞれにイベントファイルを書き出す。分散トレーニング時は`distributed_file_utils.write_dirpath`でチーフワーカーのみが書き込む。

## 通知テンプレート

### メール通知の場合

該当なし

### 本文テンプレート

```
（ファイル出力のため標準出力へのテンプレートなし。
TensorBoardイベントファイル形式（tfevents）で出力される）
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| events.out.tfevents.* | TFEvents | 常に | メトリクスサマリー |
| projector_config.pbtxt | protobuf text | embeddings_freq > 0 | Embedding設定 |
| プロファイルデータ | Chrome trace等 | profile_batch > 0 | プロファイリング結果 |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| log_dir | ログ出力先ディレクトリ | コンストラクタ引数（デフォルト: 'logs'） | Yes |
| histogram_freq | ヒストグラム出力頻度（エポック単位） | コンストラクタ引数（デフォルト: 0） | No |
| write_graph | グラフ出力の有無 | コンストラクタ引数（デフォルト: True） | No |
| write_images | 重み画像出力の有無 | コンストラクタ引数（デフォルト: False） | No |
| write_steps_per_second | ステップ/秒出力の有無 | コンストラクタ引数（デフォルト: False） | No |
| update_freq | サマリー出力頻度 | コンストラクタ引数（デフォルト: 'epoch'） | No |
| profile_batch | プロファイリング対象バッチ | コンストラクタ引数（デフォルト: 2） | No |
| embeddings_freq | Embedding出力頻度 | コンストラクタ引数（デフォルト: 0） | No |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| トレーニング開始 | on_train_begin | 常に発火 | SummaryWriterの初期化、プロファイリング準備 |
| バッチ開始 | on_train_batch_begin | _should_trace or write_steps_per_second | プロファイリング開始、バッチ時間計測開始 |
| バッチ終了 | on_train_batch_end | 同上 | グラフ出力、プロファイリング停止、steps/sec記録 |
| エポック開始 | on_epoch_begin | write_steps_per_second | イテレーション数とタイム累積のリセット |
| エポック終了 | on_epoch_end | 常に発火 | メトリクスサマリー、ヒストグラム、Embedding出力 |
| テスト開始 | on_test_begin | 常に発火 | 検証用SummaryWriter設定 |
| テスト終了 | on_test_end | 常に発火 | 検証メトリクスvs iterations出力 |
| トレーニング終了 | on_train_end | 常に発火 | SummaryWriter close、一時ディレクトリ削除 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| histogram_freq == 0 | ヒストグラム出力をスキップ |
| embeddings_freq == 0 | Embedding出力をスキップ |
| profile_batch == 0 | プロファイリングを無効化 |
| update_freq == 'epoch' | バッチ単位のサマリー出力をスキップ |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[on_train_begin] --> B[SummaryWriter初期化]
    B --> C[on_epoch_begin]
    C --> D[on_train_batch_begin]
    D --> E{profile_batch到達?}
    E -->|Yes| F[_start_trace: プロファイリング開始]
    E -->|No| G[on_train_batch_end]
    F --> G
    G --> H{_should_write_train_graph?}
    H -->|Yes| I[_write_keras_model_train_graph]
    H -->|No| J{write_steps_per_second?}
    I --> J
    J -->|Yes| K[batch_steps_per_second記録]
    J -->|No| L{プロファイリング停止タイミング?}
    K --> L
    L -->|Yes| M[_stop_trace: プロファイリング停止・保存]
    L -->|No| N[次のバッチへ]
    M --> N
    N --> O[on_epoch_end]
    O --> P[_log_epoch_metrics: メトリクスサマリー出力]
    P --> Q{histogram_freq到達?}
    Q -->|Yes| R[_log_weights: ヒストグラム出力]
    Q -->|No| S{embeddings_freq到達?}
    R --> S
    S -->|Yes| T[_log_embeddings: Embedding出力]
    S -->|No| U[次のエポックへ]
    T --> U
    U --> V[on_train_end]
    V --> W[SummaryWriter close]
    W --> X[一時ディレクトリ削除]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（ファイルシステムのみ使用）

### 更新テーブル一覧

該当なし（ファイルシステムへの書き出し）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ValueError | profile_batchが不正値 | コンストラクタでValueErrorをraise |
| ValueError | 認識できないkwargsが渡された場合 | コンストラクタでValueErrorをraise |
| JSONシリアライズ失敗 | モデルのJSON化に失敗 | 警告出力、グラフ出力をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | update_freqで制御 |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

- ログディレクトリにはモデル構造やメトリクスが含まれるため、適切なアクセス権限管理が必要
- TensorBoardをリモートアクセス可能にする場合は認証設定が必要
- プロファイリングデータにはシステム情報が含まれる可能性がある

## 備考

- `_supports_tf_logs = True`が設定されている
- `update_freq='batch'`は内部的に`update_freq=1`に変換される
- SummaryWriterは遅延初期化（Lazily initialized）で、必要時に初めてイベントファイルが作成される
- V1互換の非推奨kwargs（`write_grads`、`batch_size`、`embeddings_layer_names`、`embeddings_data`）は警告付きで無視される
- profile_batchはウォームアップのため、初回は空のプロファイリングを実行する（行2376-2377）
- `version_utils.TensorBoardVersionSelector`を継承してTF1/TF2バージョン互換を実現

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `TensorBoard.__init__`（行2146-2180）。log_dir、histogram_freq、write_graph、update_freq、profile_batch等のパラメータ群 |
| 1-2 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `_init_profile_batch`（行2333-2382）。プロファイリングバッチ範囲の検証と初期化 |

**読解のコツ**: TensorBoardコールバックは最も複雑なコールバックの一つ。パラメータが多いため、`__init__`を注意深く読むことが重要。`_writers`辞書でtrain/val用のSummaryWriterを管理する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `set_model`（行2209-2227）。ログディレクトリ設定、SummaryWriter初期化、グラフ出力 |
| 2-2 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `on_train_begin`（行2384-2388）。グローバルバッチカウンタリセット、SummaryWriter push |
| 2-3 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `on_epoch_end`（行2447-2455）。メトリクスサマリー、ヒストグラム、Embedding出力 |

**主要処理フロー**:
1. **行2212-2218**: `_log_write_dir`、`_train_dir`、`_val_dir`の設定
2. **行2223-2225**: write_graph有効時のモデルサマリー出力
3. **行2384-2388**: トレーニング開始時のカウンタリセットとSummaryWriter push
4. **行2449**: `_log_epoch_metrics(epoch, logs)` でメトリクスサマリー出力
5. **行2451-2452**: histogram_freq到達時の`_log_weights`呼び出し
6. **行2454-2455**: embeddings_freq到達時の`_log_embeddings`呼び出し

#### Step 3: バッチレベル処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `on_train_batch_begin`（行2416-2424）。グローバルバッチカウンタ管理、プロファイリング開始 |
| 3-2 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `on_train_batch_end`（行2426-2439）。グラフ出力、steps/sec記録、プロファイリング停止 |

#### Step 4: メトリクス出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `_log_epoch_metrics`（行2485-2499）。train/valログの分離、学習率収集、steps/sec計算 |

### プログラム呼び出し階層図

```
model.fit()
    |
    +-- TensorBoard.set_model(model)
    |       +-- _get_log_write_dir()
    |       +-- _write_keras_model_summary()  # write_graph=True
    |       +-- _configure_embeddings()       # embeddings_freq > 0
    |
    +-- CallbackList.on_train_begin()
    |       +-- TensorBoard.on_train_begin()
    |               +-- _push_writer(_train_writer, _train_step)
    |
    +-- [エポックループ]
    |       +-- TensorBoard.on_epoch_begin()
    |       |
    |       +-- [バッチループ]
    |       |       +-- TensorBoard.on_train_batch_begin()
    |       |       |       +-- _start_trace()  # profile_batch到達時
    |       |       |
    |       |       +-- TensorBoard.on_train_batch_end()
    |       |               +-- _write_keras_model_train_graph()  # 初回のみ
    |       |               +-- summary_ops_v2.scalar('batch_steps_per_second')
    |       |               +-- _stop_trace()  # profile_batch終了時
    |       |
    |       +-- TensorBoard.on_epoch_end()
    |               +-- _log_epoch_metrics(epoch, logs)
    |               |       +-- summary_ops_v2.scalar() [train/valそれぞれ]
    |               +-- _log_weights(epoch)       # histogram_freq到達時
    |               +-- _log_embeddings(epoch)    # embeddings_freq到達時
    |
    +-- CallbackList.on_train_end()
            +-- TensorBoard.on_train_end()
                    +-- _pop_writer()
                    +-- _stop_trace()  # 未完了のトレース停止
                    +-- _close_writers()
                    +-- _delete_tmp_write_dir()
```

### データフロー図

```
[入力]                     [処理]                              [出力]

モデル構造             ---> set_model()                    ---> train/events.out.tfevents.*
                            _write_keras_model_summary()         (Kerasモデルグラフ)

バッチ終了時           ---> on_train_batch_end()           ---> train/events.out.tfevents.*
  {steps_per_second}        summary_ops_v2.scalar()              (batch_steps_per_second)

エポック終了時logs     ---> _log_epoch_metrics()           ---> train/events.out.tfevents.*
  {loss, accuracy,          train/valログ分離                     (trainメトリクス)
   val_loss, val_acc}       summary_ops_v2.scalar()        ---> validation/events.out.tfevents.*
                                                                 (valメトリクス)

モデル重み             ---> _log_weights()                 ---> train/events.out.tfevents.*
                            summary_ops_v2.histogram()           (重みヒストグラム)

プロファイル           ---> _start_trace/_stop_trace       ---> train/plugins/profile/
                            profiler.start()/stop()              (プロファイリングデータ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| callbacks.py | `tensorflow/python/keras/callbacks.py` | ソース | TensorBoardクラス定義 |
| summary_ops_v2.py | `tensorflow/python/ops/summary_ops_v2.py` | ソース | サマリー出力関数（scalar, histogram, trace_on/export等） |
| profiler_v2.py | `tensorflow/python/profiler/profiler_v2.py` | ソース | プロファイリングAPI |
| distributed_file_utils.py | `tensorflow/python/keras/distribute/distributed_file_utils.py` | ソース | 分散ファイルパス管理 |
| version_utils.py | `tensorflow/python/keras/utils/version_utils.py` | ソース | TF1/TF2バージョン互換 |
| generic_utils.py | `tensorflow/python/keras/utils/generic_utils.py` | ソース | Progbarユーティリティ |
