# 通知設計書 3-ProgbarLogger

## 概要

本ドキュメントは、TensorFlow Kerasの`ProgbarLogger`コールバックに関する通知設計書である。`ProgbarLogger`はトレーニングメトリクスを標準出力へプログレスバー形式で出力する。

### 本通知の処理概要

`ProgbarLogger`は、トレーニング・評価・予測の各フェーズにおいて、進捗状況とメトリクス値をプログレスバーとして標準出力に表示するコールバックである。

**業務上の目的・背景**：機械学習モデルのトレーニングは長時間にわたることが多く、ユーザがリアルタイムで進捗を把握できることが重要である。`ProgbarLogger`はエポック・バッチの進捗をコンソールに視覚的に表示し、ユーザが学習の進行状況やメトリクスの推移を確認できるようにする。

**通知の送信タイミング**：エポック開始時にプログレスバーをリセットし、各バッチ終了時にプログレスバーを更新し、エポック終了時にプログレスバーを確定する。`verbose=1`の場合はバッチごと、`verbose=2`の場合はエポックごとの表示となる。

**通知の受信者**：標準出力を監視しているユーザ（コンソール画面）。

**通知内容の概要**：エポック番号、バッチ進捗、メトリクス値（loss、accuracy等）をプログレスバー形式で表示。

**期待されるアクション**：ユーザがトレーニング進捗を確認し、必要に応じてトレーニングの中断やハイパーパラメータの調整を検討する。

## 通知種別

標準出力通知（コンソールプログレスバー表示）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

`verbose`パラメータが0でない場合に標準出力へ出力する。`verbose=1`ではプログレスバー表示、`verbose=2`ではエポック単位の行出力。

## 通知テンプレート

### メール通知の場合

該当なし

### 本文テンプレート

```
Epoch 1/10
32/32 [==============================] - 2s 50ms/step - loss: 0.5000 - accuracy: 0.7500
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| epoch | エポック番号 | on_epoch_beginの引数 | Yes |
| epochs | 総エポック数 | self.params['epochs'] | Yes |
| target | 総ステップ/サンプル数 | self.params['steps']またはself.params['samples'] | No |
| metrics | メトリクス値 | logs辞書 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| エポック開始 | on_epoch_begin | verbose > 0 かつ epochs > 1 | エポック番号表示 |
| バッチ終了 | on_train_batch_end | verbose == 1 | プログレスバー更新 |
| エポック終了 | on_epoch_end | 常に | プログレスバー確定 |
| テスト開始 | on_test_begin | fit外での呼び出し時 | 評価用プログレスバー初期化 |
| テストバッチ終了 | on_test_batch_end | fit外での呼び出し時 | 評価用プログレスバー更新 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| verbose == 0 | 非表示モード |
| _called_in_fit == True | fit内でのtest_batch_endは抑止 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[on_epoch_begin] --> B[プログレスバーリセット・初期化]
    B --> C{verbose > 0 かつ epochs > 1?}
    C -->|Yes| D[Epoch N/M 表示]
    C -->|No| E[スキップ]
    D --> F[on_train_batch_end]
    E --> F
    F --> G{verbose == 1?}
    G -->|Yes| H[プログレスバー更新]
    G -->|No| I[スキップ]
    H --> J[on_epoch_end]
    I --> J
    J --> K[プログレスバー確定表示]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリ処理のみ）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ValueError | count_modeが'samples'でも'steps'でもない場合 | コンストラクタで即座にraiseする |
| AttributeError | model._train_counterが存在しない場合 | try-exceptで_call_batch_hooks=Trueにフォールバック |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

特になし。メトリクス値のみを標準出力に表示する。

## 備考

- `_supports_tf_logs = True`が設定されている
- `count_mode`は`'samples'`または`'steps'`を指定でき、プログレスバーの進捗単位が変わる
- `_implements_train_batch_hooks`等はself._call_batch_hooksの値に応じて動的に変わる
- Progbarユーティリティクラス（`generic_utils.Progbar`）に描画を委譲

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `ProgbarLogger`クラス定義（行968-1131）。`use_steps`、`seen`、`progbar`、`target`等のインスタンス変数 |
| 1-2 | generic_utils.py | `tensorflow/python/keras/utils/generic_utils.py` | `Progbar`クラス。プログレスバーの描画ロジック |

**読解のコツ**: `ProgbarLogger`は進捗管理のみを担い、実際のプログレスバー描画は`Progbar`クラスに委譲している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `set_params`（行1008-1025）。verbose、target、_call_batch_hooksの設定 |
| 2-2 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `on_epoch_begin`（行1040-1044）。プログレスバーリセットとエポック番号表示 |

**主要処理フロー**:
1. **行1009**: `self.verbose = params['verbose']` でverboseレベル設定
2. **行1011-1014**: steps/samplesからtarget値を決定
3. **行1018**: `self._call_batch_hooks = self.verbose == 1` でバッチフック呼び出し制御
4. **行1041-1042**: `_reset_progbar`と`_maybe_init_progbar`でプログレスバー初期化

#### Step 3: バッチ更新処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `_batch_update_progbar`（行1102-1120）。バッチごとのプログレスバー更新ロジック |
| 3-2 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `_finalize_progbar`（行1122-1131）。エポック終了時のプログレスバー確定処理 |

**主要処理フロー**:
- **行1106-1107**: `self.seen = batch + 1`（stepsモード、1-indexed）
- **行1117-1120**: verbose==1時にProgbar.updateを呼び出し

### プログラム呼び出し階層図

```
model.fit()
    |
    +-- CallbackList.on_epoch_begin()
    |       +-- ProgbarLogger.on_epoch_begin()
    |               +-- _reset_progbar()      # seen=0, progbar=None
    |               +-- _maybe_init_progbar()  # Progbarインスタンス生成
    |               +-- print('Epoch N/M')     # verbose > 0 かつ epochs > 1
    |
    +-- [バッチループ]
    |       +-- CallbackList.on_train_batch_end()
    |               +-- ProgbarLogger.on_train_batch_end()
    |                       +-- _batch_update_progbar()
    |                               +-- _maybe_init_progbar()
    |                               +-- Progbar.update()
    |
    +-- CallbackList.on_epoch_end()
            +-- ProgbarLogger.on_epoch_end()
                    +-- _finalize_progbar()
                            +-- Progbar.update(target, finalize=True)
```

### データフロー図

```
[入力]                     [処理]                            [出力]

params                ---> set_params()                  ---> verbose, target設定
  {verbose, epochs,
   steps}

バッチ終了時のlogs     ---> _batch_update_progbar()      ---> 標準出力
  {loss: 0.5,               Progbar.update(seen, items)       [=====>...] - loss: 0.5
   accuracy: 0.8}

エポック終了時のlogs   ---> _finalize_progbar()           ---> 標準出力
                            Progbar.update(target,             [==========] - loss: 0.45
                                           finalize=True)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| callbacks.py | `tensorflow/python/keras/callbacks.py` | ソース | ProgbarLoggerクラス定義 |
| generic_utils.py | `tensorflow/python/keras/utils/generic_utils.py` | ソース | Progbarクラス（プログレスバー描画） |
| tf_utils.py | `tensorflow/python/keras/utils/tf_utils.py` | ソース | sync_to_numpy_or_python_type関数 |
