# 通知設計書 4-History

## 概要

本ドキュメントは、TensorFlow Kerasの`History`コールバックに関する通知設計書である。`History`はトレーニング履歴（loss/metricsの推移）を記録し、`model.fit()`の戻り値として通知する。

### 本通知の処理概要

`History`は、各エポック終了時にメトリクス値を辞書に記録し、トレーニング全体の履歴を保持するコールバックである。`model.fit()`の戻り値として返され、ユーザがトレーニング結果を事後分析できるようにする。

**業務上の目的・背景**：トレーニングの学習曲線（loss/accuracyの推移）を分析することは、モデルの過学習・未学習の診断やハイパーパラメータ調整に不可欠である。`History`はこの情報を自動的に記録し、`model.history`属性および`fit()`戻り値として提供する。

**通知の送信タイミング**：`on_train_begin`でエポックリストを初期化し、各エポック終了時（`on_epoch_end`）にメトリクス値を`self.history`辞書に追加する。

**通知の受信者**：`model.fit()`の呼び出し元コード。`History`オブジェクトが`model.history`属性およびfit()の戻り値として設定される。

**通知内容の概要**：エポックごとのloss、各種メトリクスの推移履歴。`history.history`はキーがメトリクス名、値がエポックごとの値リストの辞書。

**期待されるアクション**：ユーザが学習曲線をプロットしてモデル性能を分析する。過学習・未学習の判定やハイパーパラメータの調整を行う。

## 通知種別

アプリ内通知（Pythonオブジェクト属性としての返却）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | 高（全Kerasモデルに自動適用） |
| リトライ | 無し |

### 送信先決定ロジック

常にトレーニング中のモデルの`model.history`属性に自身を設定する。`model.fit()`は`History`オブジェクトを戻り値として返す。

## 通知テンプレート

### メール通知の場合

該当なし

### 本文テンプレート

```python
# history.historyの構造
{
    'loss': [0.5, 0.4, 0.35, ...],
    'accuracy': [0.7, 0.8, 0.85, ...],
    'val_loss': [0.6, 0.5, 0.45, ...],
    'val_accuracy': [0.65, 0.75, 0.8, ...]
}
# history.epochの構造
[0, 1, 2, ...]
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| epoch | エポックインデックスのリスト | on_epoch_endの引数epoch | Yes |
| history | メトリクス名をキー、値リストを値とする辞書 | on_epoch_endのlogs | Yes |
| params | トレーニングパラメータ | set_paramsで設定 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| トレーニング開始 | on_train_begin | 常に発火 | epoch リストを初期化 |
| エポック終了 | on_epoch_end | 常に発火 | メトリクス値を記録 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | 常にメトリクスを記録する |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[on_train_begin] --> B[self.epoch = 空リスト初期化]
    B --> C[エポックループ開始]
    C --> D[on_epoch_end]
    D --> E[epoch番号をself.epochに追加]
    E --> F[logsの各メトリクスをself.historyに追加]
    F --> G[self.model.history = self に設定]
    G --> H{次のエポック?}
    H -->|Yes| D
    H -->|No| I[model.fit()がHistoryオブジェクトを返却]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリ処理のみ）

### 更新テーブル一覧

該当なし

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 特になし | Historyはシンプルな記録処理のため例外は発生しにくい | - |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 該当なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

特になし。メトリクス値のみを保持する。

## 備考

- `History`はすべてのKerasモデルのトレーニングに自動的に適用される
- `model.history`属性としてアクセス可能
- `model.fit()`の戻り値としても返される
- `history.history`辞書にアクセスすることでメトリクス推移を取得できる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `History`クラス定義（行1134-1170）。`self.history`辞書と`self.epoch`リストの2つのデータ構造 |

**読解のコツ**: `History`クラスは非常にシンプルで、`__init__`で`self.history = {}`を初期化し、`on_epoch_end`でメトリクスを追記するのみ。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `on_train_begin`（行1159-1160）。`self.epoch = []`でエポックリスト初期化 |
| 2-2 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `on_epoch_end`（行1162-1170）。メトリクス記録の中核処理 |

**主要処理フロー**:
1. **行1163**: `logs = logs or {}` でNone対策
2. **行1164**: `self.epoch.append(epoch)` でエポック番号を追加
3. **行1165-1166**: `self.history.setdefault(k, []).append(v)` で各メトリクスの値を追加
4. **行1170**: `self.model.history = self` でモデルにHistoryを設定

#### Step 3: Historyの自動登録を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `configure_callbacks`（行111-112）。`model.history = History()`と`callbacks`リストへの追加 |
| 3-2 | callbacks.py | `tensorflow/python/keras/callbacks.py` | `CallbackList._add_default_callbacks`（行263-280）。`add_history=True`時の自動追加 |

### プログラム呼び出し階層図

```
model.fit()
    |
    +-- CallbackList.__init__(add_history=True)
    |       +-- _add_default_callbacks()  # History自動追加
    |
    +-- CallbackList.on_train_begin()
    |       +-- History.on_train_begin()  # self.epoch = []
    |
    +-- [エポックループ]
    |       +-- CallbackList.on_epoch_end()
    |               +-- History.on_epoch_end()
    |                       +-- self.epoch.append(epoch)
    |                       +-- self.history[k].append(v)
    |                       +-- self.model.history = self
    |
    +-- return model.history  # Historyオブジェクト返却
```

### データフロー図

```
[入力]                     [処理]                          [出力]

エポック終了時のlogs   ---> History.on_epoch_end()     ---> self.history辞書
  {loss: 0.45,              epoch番号とメトリクス値を        {loss: [0.5, 0.45],
   accuracy: 0.82}          辞書・リストに追記               accuracy: [0.8, 0.82]}

                                                      ---> model.history属性
                                                           (Historyオブジェクト自身)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| callbacks.py | `tensorflow/python/keras/callbacks.py` | ソース | Historyクラス定義、CallbackList、configure_callbacks |
