---
generated_at: 2026-02-02 10:05:00
metrics:
  claims_total: 9
  claims_with_evidence: 9
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-TerminateOnNaN

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：9 / 9、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/keras/callbacks.py` 行950-965（TerminateOnNaNクラス定義）
- E-02: `tensorflow/python/keras/callbacks.py` 行954-956（__init__メソッド）
- E-03: `tensorflow/python/keras/callbacks.py` 行958-965（on_batch_endメソッド）
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` 行3（TerminateOnNaNの説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NaN損失検出時にトレーニングを終了させる | E-03 (行963-965) | ○ |
| C-02 | on_batch_endでloss値を検査する | E-03 (行958-960) | ○ |
| C-03 | np.isnanとnp.isinfで判定する | E-03 (行963) | ○ |
| C-04 | model.stop_training=Trueを設定する | E-03 (行965) | ○ |
| C-05 | _supports_tf_logs=Trueが設定されている | E-02 (行956) | ○ |
| C-06 | sync_to_numpy_or_python_typeで変換してから判定する | E-03 (行962) | ○ |
| C-07 | 標準出力にバッチ番号付きメッセージを出力する | E-03 (行964) | ○ |
| C-08 | lossがNoneの場合はスキップする | E-03 (行961) | ○ |
| C-09 | 送信方式は同期である | E-01 (コールバック構造) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - TerminateOnNaNは非常にシンプルなコールバックで、ソースコードから全ての挙動を確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] NaN/Inf判定ロジックがソースコードと一致していることを確認
- [ ] _supports_tf_logsの設定が正しいことを確認
