---
generated_at: 2026-02-02 10:30:00
metrics:
  claims_total: 19
  claims_with_evidence: 18
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：27-StreamCallbackRegistry

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：18 / 19、根拠なし：1
- 優先レビュー（高）
  1. **gRPCレスポンスストリーミングとの連携詳細**：具体的な配信実装の確認不足

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/core/tfrt/runtime/stream.h` 行1-285（ヘッダ全体）
- E-02: `tensorflow/core/tfrt/runtime/stream.cc` 行1-241（実装全体）
- E-03: `tensorflow/core/tfrt/runtime/stream.h` 行46-49（StreamedResult構造体）
- E-04: `tensorflow/core/tfrt/runtime/stream.h` 行51-53（StreamCallbackId型）
- E-05: `tensorflow/core/tfrt/runtime/stream.h` 行155-243（StreamCallbackRegistryクラス）
- E-06: `tensorflow/core/tfrt/runtime/stream.h` 行258-280（ScopedStreamCallback）
- E-07: `tensorflow/core/tfrt/runtime/stream.cc` 行132-149（Register実装）
- E-08: `tensorflow/core/tfrt/runtime/stream.cc` 行151-166（Invoke実装）
- E-09: `tensorflow/core/tfrt/runtime/stream.cc` 行83-100（CallbackState::Invoke）
- E-10: `tensorflow/core/tfrt/runtime/stream.cc` 行102-112（CallbackState::Close）
- E-11: `tensorflow/core/tfrt/runtime/stream.cc` 行114-130（CallbackState::InvokeCallback）
- E-12: `tensorflow/core/tfrt/runtime/stream.cc` 行47-81（CreateStreamCallbackId）
- E-13: `tensorflow/core/tfrt/runtime/stream.cc` 行202-224（ScopedStreamCallback::Unregister）
- E-14: `tensorflow/core/tfrt/runtime/stream.h` 行170-174（Register()ドキュメントコメント）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | callback_idとstep_idのペアでコールバックを一意識別 | E-05（行240-242）, E-07 | ○ |
| C-02 | スレッドプール経由で非同期にコールバック実行 | E-09（行93） | ○ |
| C-03 | コールバックはシリアル実行（スレッドセーフ不要） | E-14（行172-174） | ○ |
| C-04 | ScopedStreamCallbackによるRAII管理 | E-06（行266: デストラクタでUnregister） | ○ |
| C-05 | StreamedResultはテンソルマップとenqueued_timeを保持 | E-03 | ○ |
| C-06 | StreamCallbackIdはint64_tベースのSafeId | E-04 | ○ |
| C-07 | CreateStreamCallbackIdでMLIRモジュールを書き換え | E-12（行74-78） | ○ |
| C-08 | tsl::random::New64()でランダムID生成 | E-12（行70-71） | ○ |
| C-09 | 未登録コールバックにNotFoundError返却 | E-08（行157-160） | ○ |
| C-10 | 閉鎖済みコールバックにInternalError返却 | E-09（行87-89） | ○ |
| C-11 | 重複登録にAlreadyExistsError返却 | E-07（行142-143） | ○ |
| C-12 | Close()で未完了コールバック完了待ち | E-10（行107-110） | ○ |
| C-13 | TraceMeプロファイリング組込み | E-11（行119-125）, E-13（行207-213） | ○ |
| C-14 | RecordDequeueLatencyでデキューレイテンシ記録 | E-11（行116-117） | ○ |
| C-15 | RecordCallbackLatencyでコールバックレイテンシ記録 | E-11（行129） | ○ |
| C-16 | GetGlobalStreamCallbackRegistryはグローバルシングルトン | E-02（行231-237） | ○ |
| C-17 | StreamInterfaceFactoryでコントローラ・ワーカーIF登録 | E-01（行99-143） | ○ |
| C-18 | absl::Mutexで全レジストリ操作がスレッドセーフ | E-05（行239）, E-07, E-08 | ○ |
| C-19 | gRPCレスポンスストリーミングとの連携 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-19: StreamCallbackRegistryからgRPCレスポンスストリーミングへの具体的な連携パスは、本設計書で参照したソースコードの範囲では確認できていない。StreamWorkerInterface::InvokeStreamCallback()がリモート呼び出しを行う可能性があるが、具体的な実装は参照範囲外。
  - 候補：StreamWorkerInterfaceの具体的実装クラス / TFRTサービングランタイムのgRPCハンドラ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - RAIIパターンとmutexによる堅牢なリソース管理
- 1: 中リスク - スレッドプールの枯渇時のコールバック遅延リスク

## 6) レビュアーチェックリスト（最小）
- [ ] コールバックのシリアル実行保証がソースコードと一致するか確認
- [ ] ScopedStreamCallbackのRAIIパターンが正確に記載されているか確認
- [ ] Close()での未完了コールバック待ちメカニズムの記述が正確か確認
- [ ] gRPCとの連携に関する記述の妥当性確認
