---
generated_at: 2026-02-02 10:10:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：3-ProgbarLogger

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **verbose=2のエポック単位表示**：verbose=2の具体的な表示挙動の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `tensorflow/python/keras/callbacks.py` 行968-1131（ProgbarLoggerクラス定義）
- E-02: `tensorflow/python/keras/callbacks.py` 行985-998（__init__メソッド）
- E-03: `tensorflow/python/keras/callbacks.py` 行1008-1025（set_paramsメソッド）
- E-04: `tensorflow/python/keras/callbacks.py` 行1040-1044（on_epoch_beginメソッド）
- E-05: `tensorflow/python/keras/callbacks.py` 行1102-1131（_batch_update_progbar, _finalize_progbar）
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行4（ProgbarLoggerの説明）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | トレーニングメトリクスを標準出力へプログレスバー表示する | E-01, E-06 | ○ |
| C-02 | count_modeでstepsまたはsamplesを選択できる | E-02 (行988-993) | ○ |
| C-03 | _supports_tf_logs=Trueが設定されている | E-02 (行987) | ○ |
| C-04 | verbose==1でバッチフックが有効になる | E-03 (行1018) | ○ |
| C-05 | on_epoch_beginでプログレスバーがリセットされる | E-04 (行1041-1042) | ○ |
| C-06 | epochs > 1かつverbose > 0でエポック番号が表示される | E-04 (行1043-1044) | ○ |
| C-07 | _batch_update_progbarでバッチごとの更新が行われる | E-05 (行1102-1120) | ○ |
| C-08 | _finalize_progbarでエポック終了時の確定表示が行われる | E-05 (行1122-1131) | ○ |
| C-09 | _called_in_fitフラグでfit内でのテスト表示を抑止する | E-01 (行1027-1029, 1050-1051) | ○ |
| C-10 | Progbarユーティリティクラスに描画を委譲する | E-05 (行1085-1089, 1120) | ○ |
| C-11 | verbose=2ではエポック単位の行出力となる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-11について：verbose=2の具体的な挙動はProgbarクラス側の実装に依存するため、callbacks.py内では直接確認できない
  - 候補：generic_utils.py Progbarクラス / Keras公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ProgbarLoggerの基本ロジックはソースコードで明確に確認可能
- 1: 中リスク - verbose=2の挙動はProgbarクラスの実装依存

## 6) レビュアーチェックリスト（最小）
- [ ] verbose==1でのプログレスバー更新が正しいことを確認
- [ ] _called_in_fitフラグの動作を確認
- [ ] targetがNoneの場合の動的推定ロジックを確認
