---
generated_at: 2026-02-02 15:00:00
metrics:
  claims_total: 35
  claims_with_evidence: 30
  claims_without_evidence: 5
confidence_derived: 0.86
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：30 / 35、根拠なし：5
- 優先レビュー（高）
  1. **APKインストール手順**：具体的なビルド・配布方法の根拠がプロジェクト内にない
  2. **Android最低バージョン要件**：AndroidManifest.xmlの直接確認ができていない
  3. **サポート連絡先の詳細**：プロジェクト外の情報に依存
  4. **音声認識の認識可能ラベル一覧**：ラベルファイルの直接確認ができていない
  5. **Camera2 APIフォールバック条件**：ソースコード上の条件判定の詳細確認が不完全

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面設計書/1-画像分類画面.md`
- E-02: `docs/code-to-docs/画面設計書/2-物体検出画面.md`
- E-03: `docs/code-to-docs/画面設計書/3-スタイル変換画面.md`
- E-04: `docs/code-to-docs/画面設計書/4-音声認識画面.md`
- E-05: `docs/code-to-docs/画面設計書/9-TFLiteカメラプレビューフラグメント.md`
- E-06: `docs/code-to-docs/画面設計書/10-OVICベンチマーク画面.md`
- E-07: `docs/code-to-docs/画面設計書/11-TFLiteベンチマーク実行画面.md`
- E-08: `docs/code-to-docs/画面設計書/12-デリゲート性能ベンチマーク（レイテンシ）画面.md`
- E-09: `docs/code-to-docs/画面設計書/13-デリゲート性能ベンチマーク（精度）画面.md`
- E-10: `docs/code-to-docs/画面設計書/14-Firebase Game Loopベンチマーク画面.md`
- E-11: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-12: `docs/code-to-docs/画面一覧/画面遷移図.md`
- E-13: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-14: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-15: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv`
- E-16: `docs/code-to-docs/README.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 4つの独立したAndroidアプリで構成されている | E-11, E-12 | ○ |
| C-02 | 画像分類画面はInception v1モデルを使用し224x224入力 | E-01 | ○ |
| C-03 | 物体検出画面はSSD MobileNet v1をデフォルトで使用し300x300入力 | E-02 | ○ |
| C-04 | 物体検出の信頼度閾値はTF_OD_API:0.6、MULTIBOX:0.1、YOLO:0.25 | E-02 | ○ |
| C-05 | スタイル変換画面は26種類のスタイル画像から選択可能 | E-03 | ○ |
| C-06 | スタイル変換の処理解像度は128/192/256/384/512/720から選択 | E-03 | ○ |
| C-07 | スタイル変換画像の保存先は/sdcard/tensorflow/stylized{N}.png | E-03 | ○ |
| C-08 | 音声認識はSpeechActivityで16kHz/モノラル/PCM16ビットで録音 | E-04 | ○ |
| C-09 | 音声認識の認識結果は500ms窓で平滑化される | E-04 | ○ |
| C-10 | 音声認識の信頼度閾値は70%、抑制時間は1500ms | E-04 | ○ |
| C-11 | 音声認識の終了はQUITボタンでProcess.killProcessを呼ぶ | E-04 | ○ |
| C-12 | TFLite DemoはMobileNet v1のQuantized版とFloat版を選択可能 | E-05 | ○ |
| C-13 | TFLite DemoはCPU/GPU/NNAPIのデバイス選択が可能 | E-05 | ○ |
| C-14 | TFLite Demoのスレッド数は1-10で設定可能 | E-05 | ○ |
| C-15 | OVICベンチマークはWALL_TIME=3000ms、MAX_ITERATIONS=100で実行 | E-06 | ○ |
| C-16 | OVICベンチマークはBIG_CORE_MASK=16でCPUアフィニティを設定 | E-06 | ○ |
| C-17 | カメラ権限とストレージ権限が必要 | E-01, E-02, E-03 | ○ |
| C-18 | 音声認識画面ではRECORD_AUDIO権限が必要 | E-04 | ○ |
| C-19 | 各カメラ系画面はCameraActivityを継承し、Camera2/Legacy分岐がある | E-01, E-02, E-03, E-12 | ○ |
| C-20 | 画像分類でのエラーメッセージ「Camera AND storage permission are required」 | E-01 | ○ |
| C-21 | 画像分類でのエラーメッセージ「No Camera Detected」 | E-01 | ○ |
| C-22 | 物体検出でのエラーメッセージ「Classifier could not be initialized」 | E-02 | ○ |
| C-23 | 音声認識でのエラーメッセージ「Audio Record can't initialize!」 | E-04 | ○ |
| C-24 | TFLite Demoでのエラーメッセージ「Failed to load model」 | E-05 | ○ |
| C-25 | ベンチマークActivityはUIなしで処理後にfinish()で終了 | E-07, E-11 | ○ |
| C-26 | Firebase Game LoopベンチマークはTEST_LOOP Intentで起動 | E-10, E-11 | ○ |
| C-27 | TF DemoのモデルファイルはtensorFlow_inception_graph.pb等6ファイル | E-01, E-02, E-03, E-04 | ○ |
| C-28 | OVICベンチマークのテスト画像はtest_image_224.jpg | E-06 | ○ |
| C-29 | ボリュームキーでデバッグモードの切り替えが可能 | E-01, E-02 | ○ |
| C-30 | periodicClassifyによる定期的な分類実行の仕組み | E-05 | ○ |
| C-31 | Android 5.0（API Level 21）以上が対象 | **根拠なし** | △ |
| C-32 | APKファイルの具体的なインストール手順 | **根拠なし** | △ |
| C-33 | 音声認識の認識可能な具体的ラベル一覧 | **根拠なし** | △ |
| C-34 | GPU/NNAPIの具体的な対応デバイス条件 | **根拠なし** | △ |
| C-35 | サポート連絡先（GitHub Issues、Stack Overflow、公式ドキュメント） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-31: Androidの最低対応バージョンはAndroidManifest.xmlのminSdkVersionで定義されるが、画面設計書にはこの情報が含まれていない
  - 候補：AndroidManifest.xml / build.gradle / プロジェクト要件定義書
- C-32: APKファイルのビルド・配布方法はプロジェクト固有のCI/CD設定に依存するため、設計書からは特定できない
  - 候補：CI設定ファイル / ビルドスクリプト / 配布手順書
- C-33: 音声認識のラベル一覧はconv_actions_labels.txtファイルに定義されているが、ファイルの内容を直接確認していない
  - 候補：assets/conv_actions_labels.txt
- C-34: GPU/NNAPIデリゲートの対応条件はAndroidバージョンとハードウェアに依存するが、プロジェクト内に明記されていない
  - 候補：TFLiteデリゲートのドキュメント / 対応デバイス一覧
- C-35: サポート連絡先はTensorFlowの一般的な情報であり、プロジェクト固有の設計書には記載されていない
  - 候補：CONTRIBUTING.md / ISSUES.md / README.md

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）: 画面操作手順（C-01〜C-30）は全て画面設計書に基づき、根拠が明確
- 1（中リスク）: インストール手順（C-32）は一般的なAndroidアプリの手順を記載しているが、プロジェクト固有の配布方法と異なる可能性がある
- 1（中リスク）: Android最低バージョン（C-31）はCamera2 APIの要件から推定しているが、AndroidManifest.xmlの確認が必要
- 0（低リスク）: サポート連絡先（C-35）はTensorFlowプロジェクトの公知情報
- 0（低リスク）: GPU/NNAPIの対応条件（C-34）は一般的なAndroid開発の知識に基づく記載

## 6) レビュアーチェックリスト（最小）
- [ ] 各画面の操作手順が画面設計書の仕様と一致しているか
- [ ] エラーメッセージと対処法が画面設計書のメッセージ仕様と一致しているか
- [ ] モデルファイル名と入力サイズが画面設計書の備考欄と一致しているか
- [ ] 権限要件（カメラ/マイク/ストレージ）が各画面設計書と一致しているか
- [ ] Android最低バージョン（API Level 21）がAndroidManifest.xmlのminSdkVersionと一致するか
- [ ] 業務フローのSTEP構成がプロジェクトの実際の利用フローに適合しているか
- [ ] TFLite Demoのモデル選択・デバイス選択・スレッド数の仕様が画面設計書と一致しているか
- [ ] OVICベンチマークのパラメータ（WALL_TIME、MAX_ITERATIONS、BIG_CORE_MASK）が正しいか
