# TensorFlow Demoアプリケーション 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [アプリの起動・終了手順](#2-アプリの起動終了手順)
3. [トップ画面（ランチャー）](#3-トップ画面ランチャー)

**【業務フローに沿った機能】**
4. [【STEP1】モデルの準備・アプリのインストール](#4-step1モデルの準備アプリのインストール)
5. [【STEP2-3】推論の実行・結果の確認（カメラ系デモ）](#5-step2-3推論の実行結果の確認カメラ系デモ)
6. [【STEP3-4】推論の実行・結果の確認（音声・ベンチマーク系）](#6-step3-4推論の実行結果の確認音声ベンチマーク系)
7. [【STEP4-5】ベンチマーク計測・性能評価（管理者・開発者向け）](#7-step4-5ベンチマーク計測性能評価管理者開発者向け)

**【サポート機能】**
8. [モデル選択・デバイス設定機能](#8-モデル選択デバイス設定機能)
9. [デバッグモード機能](#9-デバッグモード機能)
10. [画像保存・出力機能](#10-画像保存出力機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 TensorFlow Demoアプリケーションとは

TensorFlow Demoアプリケーションは、TensorFlowおよびTensorFlow Liteの機械学習モデルをAndroidデバイス上でリアルタイムに動作させるデモンストレーション用アプリケーション群です。画像分類、物体検出、スタイル変換、音声認識といった代表的な機械学習タスクを、モバイルデバイスのカメラやマイクを使って体験できます。

本アプリケーション群は、以下の4つの独立したAndroidアプリで構成されています。

- **TF Demoアプリ**: TensorFlowの主要な推論機能を体験するデモアプリ
- **TFLite Demoアプリ**: TensorFlow Liteによる軽量推論のデモアプリ
- **OVIC Benchmarkアプリ**: モデルの推論性能を計測するベンチマークアプリ
- **TFLite Benchmarkツール**: コマンドライン/Intent経由でベンチマークを実行するツール群

### 1.2 本システムで行う主要業務

本アプリケーション群は、主に以下の業務を支援します。

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **リアルタイム画像推論** | カメラ映像を使った画像分類（Inception v1）、物体検出（SSD MobileNet / MultiBox / YOLO）、スタイル変換（Neural Style Transfer） |
| **リアルタイム音声推論** | マイク入力を使った音声コマンド認識 |
| **TFLite推論デモ** | TensorFlow Liteモデル（MobileNet v1 量子化版/浮動小数点版）による画像分類、GPU/NNAPI/CPUデリゲートの切替 |
| **性能ベンチマーク** | モデルの推論レイテンシ計測、デリゲート別の性能比較、精度ベンチマーク |

### 1.3 業務フロー概要

本アプリケーション群における業務は、以下の流れで進行します。

```
+-------------------------------------------------------------------+
|                        業務フロー                                  |
+-------------------------------------------------------------------+
|                                                                   |
|  【STEP 1】アプリをインストールし、モデルファイルを配置             |
|      |                                                            |
|  【STEP 2】アプリを起動し、権限（カメラ/マイク）を許可             |
|      |                                                            |
|  【STEP 3】カメラ/マイクを使ってリアルタイム推論を実行・確認       |
|      |                                                            |
|  【STEP 4】必要に応じてモデルやデバイス設定を変更                  |
|      |                                                            |
|  【STEP 5】ベンチマークを実行し、推論性能を評価・記録             |
|                                                                   |
+-------------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **開発者・評価者** | デモアプリでのモデル動作確認、推論結果の検証、デバッグモードによる詳細分析 |
| **ベンチマーク担当者** | 各種ベンチマークの実行、レイテンシ・精度の計測・記録、デリゲート間の性能比較 |
| **デモ担当者** | 顧客やステークホルダーへのデモ実演、スタイル変換画像の保存・共有 |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| 画像分類 | カメラ映像からInceptionモデルで物体を分類 | STEP 2-3 |
| 物体検出 | カメラ映像から物体を検出し、バウンディングボックスで追跡表示 | STEP 2-3 |
| スタイル変換 | カメラ映像に芸術的スタイルをリアルタイム適用 | STEP 2-3 |
| 音声認識 | マイクからの音声コマンドを認識 | STEP 2-3 |
| TFLite画像分類 | TFLite形式のMobileNetモデルで画像を分類 | STEP 2-4 |
| OVICベンチマーク | 分類/検出モデルのレイテンシを計測 | STEP 5 |
| デリゲートベンチマーク | GPU/NNAPI等のデリゲート性能を比較 | STEP 5 |
| デバッグモード | 推論時間、フレームサイズ等の詳細情報を表示 | 随時利用 |

### 1.5 ユーザー種別

| ユーザー種別 | 説明 |
|-------------|------|
| デモ操作者 | TF Demoアプリ、TFLite Demoアプリを使ってリアルタイム推論を実行し、結果を確認する |
| ベンチマーク実行者 | OVICベンチマーク、TFLiteベンチマークツールを使ってモデルの性能を計測する |
| 開発者 | デバッグモードやログを活用し、モデルの動作検証・性能チューニングを行う |

### 1.6 対応環境

**対応デバイス：**
- Android 5.0（API Level 21）以上のAndroidデバイス
- Camera2 API対応デバイス（推奨）。非対応の場合は旧Camera APIにフォールバック
- GPU/NNAPIデリゲート利用時は対応ハードウェアが必要

**必要な権限：**
- カメラ権限（CAMERA）-- 画像分類、物体検出、スタイル変換、TFLite画像分類で使用
- ストレージ権限（WRITE_EXTERNAL_STORAGE）-- スタイル変換画像の保存で使用
- マイク権限（RECORD_AUDIO）-- 音声認識で使用

---

## 2. アプリの起動・終了手順

### 2.1 アプリの起動方法

各デモアプリはAndroidのホーム画面（ランチャー）から個別に起動します。

**TF Demoアプリの起動：**

1. Androidデバイスのホーム画面またはアプリ一覧を開きます
2. 以下のいずれかのアプリアイコンをタップします
   - 「画像分類」（ClassifierActivity）
   - 「物体検出」（DetectorActivity）
   - 「スタイル変換」（StylizeActivity）
   - 「音声認識」（SpeechActivity）
3. 初回起動時にカメラ/マイク/ストレージの権限リクエストが表示されます
4. 「許可」をタップして権限を付与します
5. カメラプレビューまたは音声入力画面が表示され、自動的に推論が開始されます

**TFLite Demoアプリの起動：**

1. ホーム画面から「TFLite Demo」アプリアイコンをタップします
2. カメラ権限の許可を求められた場合は「許可」をタップします
3. カメラプレビュー画面が表示され、MobileNetモデルによる画像分類が自動的に開始されます

**OVIC Benchmarkアプリの起動：**

1. ホーム画面から「OVIC Benchmark」アプリアイコンをタップします
2. ベンチマーク実行画面が表示されます
3. 特別な権限は不要です

### 2.2 アプリの終了方法

**TF Demoアプリ（画像分類/物体検出/スタイル変換）：**
1. Androidの「戻る」ボタンまたはジェスチャーでアプリを閉じます
2. またはタスク一覧からスワイプして終了します

**音声認識アプリ：**
1. 画面下部の「QUIT」ボタンをタップします
2. アプリが即座に終了します

> **注意**: 音声認識アプリの「QUIT」ボタンはプロセスを強制終了します。Androidの戻るボタンでは録音スレッドが停止しない場合があるため、必ず「QUIT」ボタンで終了してください。

### 2.3 権限が拒否された場合

カメラやマイクの権限を拒否した場合、以下のメッセージが表示されます。

| メッセージ | 対処法 |
|-----------|--------|
| "Camera AND storage permission are required for this demo" | Androidの「設定」>「アプリ」から該当アプリの権限を手動で有効にしてください |

---

## 3. トップ画面（ランチャー）

### 3.1 アプリ一覧

各デモアプリはAndroidランチャーに個別のアイコンとして登録されます。トップ画面のような統合メニューは存在せず、目的に応じたアプリを直接起動します。

| アプリ名 | アイコンの識別 | 機能概要 |
|---------|-------------|---------|
| 画像分類（ClassifierActivity） | TF Demoアプリ | カメラ映像のリアルタイム画像分類 |
| 物体検出（DetectorActivity） | TF Demoアプリ | カメラ映像のリアルタイム物体検出・追跡 |
| スタイル変換（StylizeActivity） | TF Demoアプリ | カメラ映像への芸術的スタイル適用 |
| 音声認識（SpeechActivity） | TF Demoアプリ | マイクからの音声コマンド認識 |
| TFLiteカメラ（CameraActivity） | TFLite Demoアプリ | TFLiteモデルによる画像分類 |
| OVICベンチマーク（OvicBenchmarkerActivity） | OVIC Benchmarkアプリ | 推論性能ベンチマーク |

### 3.2 各アプリへのアクセス方法

起動したいアプリのアイコンをタップするだけで該当画面に直接アクセスできます。アプリ間の画面遷移機能はありません。各アプリは独立して動作します。

---

## 4. 【STEP1】モデルの準備・アプリのインストール

> **業務フローでの位置**: デモ実行の前に、アプリケーションのインストールとモデルファイルの配置を行うステップです。

### 4.1 アプリのインストール

**前提条件：**
- Android 5.0以上のデバイスが必要です
- 開発者モードが有効になっている（開発ビルドの場合）

**手順：**

1. ビルド済みのAPKファイルをデバイスに転送します
2. APKファイルをタップしてインストールします
3. 「不明なアプリのインストール」の許可を求められた場合は許可します
4. インストールが完了すると、ランチャーにアプリアイコンが追加されます

### 4.2 モデルファイルの確認

各アプリには、以下のモデルファイルがassetsディレクトリに事前に同梱されています。

**TF Demoアプリ：**

| モデルファイル | 用途 | 入力サイズ |
|-------------|------|-----------|
| tensorflow_inception_graph.pb | 画像分類（Inception v1） | 224x224 |
| ssd_mobilenet_v1_android_export.pb | 物体検出（SSD MobileNet） | 300x300 |
| multibox_model.pb | 物体検出（MultiBox） | 224x224 |
| graph-tiny-yolo-voc.pb | 物体検出（YOLO） | 416x416 |
| stylize_quantized.pb | スタイル変換 | 可変（128-720） |
| conv_actions_frozen.pb | 音声認識 | 16000サンプル |

**TFLite Demoアプリ：**

| モデルファイル | 用途 |
|-------------|------|
| MobileNet v1 Quantized（.tflite） | 量子化画像分類 |
| MobileNet v1 Float（.tflite） | 浮動小数点画像分類 |

**OVIC Benchmarkアプリ：**

| モデルファイル | 用途 |
|-------------|------|
| quantized_model.lite | 分類ベンチマーク |
| detect.lite | 検出ベンチマーク |

> **注意**: モデルファイルはアプリのビルド時にassetsディレクトリに含まれている必要があります。モデルの差し替えを行う場合はアプリの再ビルドが必要です。

---

## 5. 【STEP2-3】推論の実行・結果の確認（カメラ系デモ）

> **業務フローでの位置**: アプリを起動し、カメラ映像を使ったリアルタイム推論を実行して結果を確認するステップです。

### 5.1 画像分類の実行手順

**業務シーン**: カメラに写した物体をリアルタイムに分類し、分類結果を確認する場合に使用します。

**前提条件**: カメラ権限が許可されていること。

**手順：**

1. ランチャーから「画像分類」アプリを起動します
2. カメラプレビューが表示されます
3. 分類したい物体にカメラを向けます
4. 画面下部に分類結果（ラベル名と信頼度）が自動的に表示されます
5. カメラを動かすと、リアルタイムで分類結果が更新されます

**関連画面**: 画像分類画面（ClassifierActivity）

**注意点・Tips:**
- 入力画像は224x224ピクセルにリサイズ・クロップされます
- ImageNetの1000クラスに基づく分類が行われます
- フレーム処理中に新しいフレームが到着した場合、処理中のフレームが完了するまで新フレームはスキップされます

### 5.2 物体検出の実行手順

**業務シーン**: カメラ映像内の物体を検出し、バウンディングボックスと追跡表示を確認する場合に使用します。

**前提条件**: カメラ権限が許可されていること。

**手順：**

1. ランチャーから「物体検出」アプリを起動します
2. カメラプレビューが表示されます
3. 検出したい物体にカメラを向けます
4. 検出された物体の周囲にバウンディングボックス（色付きの枠線）が表示されます
5. 検出された物体のラベル名と信頼度がバウンディングボックス上に表示されます
6. 物体が移動すると、MultiBoxTrackerが追跡してバウンディングボックスが追従します

**関連画面**: 物体検出画面（DetectorActivity）

**注意点・Tips:**
- デフォルトではSSD MobileNet v1（TF Object Detection API）モデルが使用されます
- 信頼度が60%未満の検出結果は自動的にフィルタリングされます
- 3種類の検出モデル（TF_OD_API / MULTIBOX / YOLO）に対応しています（ソースコード上の設定変更が必要）

### 5.3 スタイル変換の実行手順

**業務シーン**: カメラ映像にリアルタイムで芸術的スタイルを適用し、変換結果を確認・保存する場合に使用します。

**前提条件**: カメラ権限およびストレージ権限が許可されていること。

**手順：**

1. ランチャーから「スタイル変換」アプリを起動します
2. カメラプレビューと、画面下部にスタイル画像のグリッドが表示されます
3. グリッドからスタイル画像をタップして選択します
4. スライダーをドラッグしてスタイルのブレンド比率を調整します（0.0-1.0）
5. カメラプレビューにスタイルが適用された映像がオーバーレイ表示されます

**スタイル画像の選択・ブレンド操作：**
- 26種類のスタイル画像から選択できます
- スライダー操作で複数のスタイルをブレンドできます（合計が1.0に自動正規化されます）
- Android TVではD-padの方向キーでスタイルグリッドを操作できます

**処理解像度の変更：**
- 「サイズ」ボタンをタップすると、処理解像度が循環します（128 / 192 / 256 / 384 / 512 / 720）
- 解像度が高いほど画質が向上しますが、処理速度が低下します
- デフォルトは256です

**スタイル変換済み画像の保存：**
- 「save」ボタンをタップすると、現在のスタイル変換済み画像がSDカードに保存されます
- 保存先: `/sdcard/tensorflow/stylized{番号}.png`
- 保存成功時にToastで保存先パスが表示されます

**関連画面**: スタイル変換画面（StylizeActivity）

**注意点・Tips:**
- 高解像度（512、720）ではフレームレートが低下する場合があります
- 複数スタイルのブレンドでは、各スライダー値の合計が自動的に1.0に正規化されます

---

## 6. 【STEP3-4】推論の実行・結果の確認（音声・ベンチマーク系）

> **業務フローでの位置**: カメラ以外の入力（マイク、テスト画像）を使って推論やベンチマークを実行するステップです。

### 6.1 音声認識の実行手順

**業務シーン**: マイクからの音声入力でコマンド認識の動作を確認する場合に使用します。

**前提条件**: マイク権限（RECORD_AUDIO）が許可されていること。

**手順：**

1. ランチャーから「音声認識」アプリを起動します
2. マイク権限の許可を求められた場合は「許可」をタップします
3. 認識可能な音声ラベルのリストが画面に表示されます
4. デバイスのマイクに向かって音声コマンドを発話します
5. 認識されたラベルがリスト上でハイライトアニメーションにより強調表示されます
6. 終了する場合は「QUIT」ボタンをタップします

**関連画面**: 音声認識画面（SpeechActivity）

**注意点・Tips:**
- サンプリングレートは16kHz、1秒分の音声データで推論を実行します
- 認識結果は直近500ミリ秒の結果を平均化して平滑化されます
- 信頼度が70%未満の認識結果は表示されません
- 同じコマンドの連続認識は1500ミリ秒間抑制されます
- アンダースコア（_）で始まるラベルは非表示です

### 6.2 TFLite画像分類の実行手順

**業務シーン**: TensorFlow Liteモデルの動作を確認し、モデルやデバイス設定による違いを比較する場合に使用します。

**前提条件**: カメラ権限が許可されていること。

**手順：**

1. ランチャーから「TFLite Demo」アプリを起動します
2. カメラプレビューと設定UIが表示されます
3. カメラを分類したい物体に向けます
4. 画面上部のTextViewに分類結果（ラベルと信頼度）が定期的に更新表示されます

**モデルの切り替え：**
- 画面のモデル選択リストから「MobileNet v1 Quantized」または「MobileNet v1 Float」を選択します
- 選択すると、モデルが自動的に再読み込みされます

**デバイスの切り替え：**
- 画面のデバイス選択リストから「CPU」「GPU」「NNAPI」のいずれかを選択します
- GPU/NNAPIは対応デバイスでのみ正常に動作します

**スレッド数の調整：**
- NumberPickerで推論に使用するスレッド数を1から10の間で設定できます
- スレッド数を増やすとマルチコアデバイスで推論速度が向上する場合があります

**関連画面**: TFLiteカメラ画面（CameraActivity）、TFLiteカメラプレビューフラグメント（Camera2BasicFragment）

---

## 7. 【STEP4-5】ベンチマーク計測・性能評価（管理者・開発者向け）

> **業務フローでの位置**: モデルの推論性能を定量的に計測し、評価・記録するステップです。

### 7.1 OVICベンチマークの実行手順

**業務シーン**: 画像分類モデルまたは物体検出モデルの推論レイテンシを計測する場合に使用します。

**前提条件**: OVIC Benchmarkアプリがインストールされていること。特別な権限は不要です。

**手順：**

1. ランチャーから「OVIC Benchmark」アプリを起動します
2. ベンチマーク画面が表示されます
3. 以下のいずれかのボタンをタップします
   - 「分類」ボタン: 画像分類モデル（quantized_model.lite）のベンチマークを実行
   - 「検出」ボタン: 物体検出モデル（detect.lite）のベンチマークを実行
4. ベンチマークが自動的に実行されます（最大3000ミリ秒または100回の反復）
5. 完了後、TextViewに以下の結果が表示されます
   - モデルパス
   - 平均レイテンシ（ミリ秒）
   - 実行回数

**関連画面**: OVICベンチマーク画面（OvicBenchmarkerActivity）

**注意点・Tips:**
- ベンチマーク実行中はデバイスのビッグコア（BIG_CORE_MASK=16）にCPUアフィニティが設定されます
- テスト画像は `test_image_224.jpg` が使用されます
- 正確な計測のため、ベンチマーク実行中は他のアプリを操作しないでください

### 7.2 TFLiteベンチマークツールの実行手順

**業務シーン**: Intent経由またはadbコマンドでTFLiteモデルのベンチマークを自動実行する場合に使用します。

**前提条件**: TFLite Benchmarkツールがインストールされていること。adbが利用可能な開発環境が必要です。

**手順（adb経由）：**

1. デバイスをPCに接続し、adb接続を確認します
2. 以下のコマンドでベンチマークを実行します

```
adb shell am start -n org.tensorflow.lite.benchmark/.BenchmarkModelActivity \
  --es args '"--graph=/path/to/model.tflite"'
```

3. ベンチマーク結果はlogcatに出力されます
4. Activityはベンチマーク完了後に自動終了します

**デリゲート性能ベンチマーク（レイテンシ）：**

```
adb shell am start -n org.tensorflow.lite.benchmark.delegateperformance/.BenchmarkLatencyActivity \
  --es "tflite_settings_files" "/path/to/settings.json" \
  --es "args" '"--model_path=/path/to/model.tflite"'
```

**デリゲート性能ベンチマーク（精度）：**

```
adb shell am start -n org.tensorflow.lite.benchmark.delegateperformance/.BenchmarkAccuracyActivity \
  --es "tflite_settings_files" "/path/to/settings.json"
```

**Firebase Game Loopベンチマーク：**
- Firebase Test Lab上で自動実行されます
- Game Loop Intent（com.google.intent.action.TEST_LOOP）で起動されます

**関連画面**: TFLiteベンチマーク実行画面、デリゲート性能ベンチマーク画面

**注意点・Tips:**
- ベンチマークActivityはUIを持たず、処理完了後に自動終了します
- Hexagonデリゲートを使用する場合は `--use_hexagon` 引数を指定してください

---

## 8. モデル選択・デバイス設定機能

### 8.1 TFLite Demoアプリでのモデル選択

TFLite Demoアプリでは、以下の2種類のモデルを切り替えて使用できます。

| モデル | 特徴 |
|--------|------|
| MobileNet v1 Quantized | INT8量子化モデル。推論速度が速く、メモリ使用量が少ない |
| MobileNet v1 Float | 浮動小数点（FP32）モデル。量子化モデルより精度が高い場合がある |

**切り替え手順：**
1. 画面のモデル選択リスト（ListView）をタップします
2. 使用したいモデルを選択します
3. モデルが自動的に再読み込みされ、次の推論から適用されます

### 8.2 デバイス（デリゲート）設定

TFLite Demoアプリでは、推論に使用するデバイスを切り替えられます。

| デバイス | 説明 | 備考 |
|---------|------|------|
| CPU | CPUで推論を実行（デフォルト） | 全デバイスで利用可能 |
| GPU | GPUデリゲートで推論を実行 | GPU対応デバイスが必要 |
| NNAPI | Android NNAPIデリゲートで推論を実行 | NNAPI対応デバイス（Android 8.1以上）が必要 |

**切り替え手順：**
1. 画面のデバイス選択リスト（ListView）をタップします
2. 使用したいデバイスを選択します
3. デバイスが自動的に切り替わり、次の推論から適用されます

### 8.3 スレッド数の設定

CPU推論時のスレッド数を1から10の間で設定できます。

**設定手順：**
1. 画面のNumberPickerでスレッド数を選択します
2. 設定が即座に反映されます

> **注意**: スレッド数を過度に増やすと、デバイスの負荷が増大し、逆に推論速度が低下する場合があります。デバイスのCPUコア数を目安に設定してください。

---

## 9. デバッグモード機能

### 9.1 デバッグモードの有効化

TF Demoアプリ（画像分類/物体検出/スタイル変換）では、デバッグモードを有効にすることで、推論に関する詳細情報を確認できます。

**有効化手順：**
1. デモアプリの実行中に、以下のいずれかのキーを押下します
   - ボリュームキー（上または下）
   - L1ボタン（ゲームコントローラー接続時）
   - D-padセンターキー
2. デバッグオーバーレイが画面上に表示されます
3. 再度同じキーを押すとデバッグモードが無効になります

### 9.2 デバッグモードで表示される情報

| 表示項目 | 説明 |
|---------|------|
| フレームサイズ | カメラから取得されるフレームのピクセルサイズ |
| クロップサイズ | モデル入力用にリサイズ・クロップされたサイズ |
| 回転角度 | カメラセンサーの回転角度 |
| 推論時間 | 1回の推論にかかった時間（ミリ秒） |
| クロップ画像 | モデルに入力された画像のプレビュー |

---

## 10. 画像保存・出力機能

### 10.1 スタイル変換画像の保存

スタイル変換アプリで生成された画像をデバイスに保存できます。

**保存手順：**
1. スタイル変換アプリでスタイルを適用した状態にします
2. 「save」ボタンをタップします
3. 画像が `/sdcard/tensorflow/stylized{番号}.png` に保存されます
4. 保存先パスがToastメッセージで表示されます

**保存画像の確認：**
- デバイスのファイルマネージャーで `/sdcard/tensorflow/` フォルダを開きます
- `stylized0.png`、`stylized1.png` のように連番で保存されます

> **注意**: ストレージ権限が許可されていない場合、保存に失敗します。

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
======================================================
【STEP 1】アプリをインストールし、モデルファイルを配置 -> 4章参照
    |
【STEP 2】アプリを起動し、権限（カメラ/マイク）を許可 -> 2章参照
    |
【STEP 3】カメラ/マイクを使ってリアルタイム推論を実行 -> 5章、6章参照
    |
【STEP 4】必要に応じてモデルやデバイス設定を変更 -> 8章参照
    |
【STEP 5】ベンチマークを実行し、推論性能を評価・記録 -> 7章参照
======================================================
```

### 11.1 【デモ担当者】STEP1-2: 事前準備

デモ実施前に、アプリのインストールと動作確認を行います。

1. 対象のAndroidデバイスにデモアプリをインストールします（4章参照）
2. 各アプリを一度起動し、権限を許可します（2章参照）
3. カメラプレビューが正常に表示され、推論結果が出力されることを確認します
4. 必要に応じてデバッグモードで推論時間を確認します（9章参照）

### 11.2 【デモ担当者】STEP3: リアルタイム推論のデモ実演

デモ対象に応じたアプリを起動し、リアルタイム推論を実演します。

**画像分類デモの場合：**
1. 「画像分類」アプリを起動します
2. さまざまな物体にカメラを向けて、分類結果を見せます
3. 信頼度の変化を説明します

**物体検出デモの場合：**
1. 「物体検出」アプリを起動します
2. 複数の物体が映る場所にカメラを向けます
3. バウンディングボックスが追跡する様子を見せます

**スタイル変換デモの場合：**
1. 「スタイル変換」アプリを起動します
2. スタイルグリッドからスタイルを選択します
3. スライダーでブレンド比率を調整して効果の違いを見せます
4. 気に入った結果は「save」ボタンで保存します

### 11.3 【ベンチマーク担当者】STEP4-5: 性能計測

モデルの推論性能を計測し、記録します。

1. OVICベンチマークアプリを起動します（7.1節参照）
2. 「分類」ボタンで分類モデルのレイテンシを計測します
3. 「検出」ボタンで検出モデルのレイテンシを計測します
4. 結果をメモまたはスクリーンショットで記録します
5. TFLite Demoアプリでモデル/デバイスを切り替えながら推論速度を比較します（8章参照）

---

## 12. よくある質問と対処法

### 12.1 アプリ起動に関するQ&A

**Q: アプリを起動してもカメラプレビューが表示されません**

A: 以下を確認してください。
- カメラ権限が許可されているか確認してください（Androidの「設定」>「アプリ」>「権限」）
- 他のアプリがカメラを占有していないか確認してください
- デバイスを再起動してから再度試してください

**Q: "No Camera Detected" と表示されます**

A: デバイスにカメラが搭載されていないか、カメラが使用不能な状態です。カメラ搭載デバイスで実行してください。

### 12.2 推論結果に関するQ&A

**Q: 画像分類の結果が不正確です**

A: 以下の点を確認してください。
- InceptionモデルはimageNetの1000クラスに基づいて分類します。認識対象外の物体では正確な結果が得られません
- 十分な照明のある環境でカメラを使用してください
- カメラを安定させて、ブレのない映像を入力してください

**Q: 物体検出で検出結果が表示されません**

A: 信頼度が閾値（TF_OD_API: 60%、MULTIBOX: 10%、YOLO: 25%）未満の検出結果はフィルタリングされます。検出対象の物体をカメラに大きく映すように近づけてみてください。

**Q: 音声認識で認識されたラベルがハイライトされません**

A: 以下を確認してください。
- マイク権限が許可されているか確認してください
- 信頼度の閾値は70%です。明瞭に発話してください
- 同じコマンドは1500ミリ秒間隔を空ける必要があります

### 12.3 ベンチマークに関するQ&A

**Q: OVICベンチマークの結果が "Benchmarker failed to run on more than one images." と表示されます**

A: ベンチマークの実行に失敗しています。モデルファイル（quantized_model.lite / detect.lite）がassetsに正しく配置されているか確認してください。

**Q: TFLite Demoでモデル読み込みに失敗します**

A: "Failed to load model" というメッセージが表示された場合、モデルファイルがassetsに存在しないか破損している可能性があります。アプリを再インストールしてください。

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| "Camera AND storage permission are required for this demo" | カメラまたはストレージ権限が未付与 | Androidの「設定」>「アプリ」から権限を手動で有効にする |
| "No Camera Detected" | カメラデバイスが検出されない | カメラ搭載デバイスで実行する |
| "Classifier could not be initialized" | 物体検出モデルの初期化に失敗 | アプリを再インストールする。モデルファイルがassetsに存在するか確認する |
| "Audio Record can't initialize!" | AudioRecordの初期化に失敗 | マイク権限を確認する。他のアプリがマイクを占有していないか確認する |
| "Problem reading label file!" | ラベルファイルの読み込みに失敗 | アプリを再インストールする |
| "Failed to load model" | TFLiteモデルの読み込みに失敗 | モデルファイルの存在と整合性を確認する。アプリを再インストールする |
| "Failed" | カメラセッション設定に失敗 | アプリを再起動する。他のカメラ使用アプリを終了する |

### 13.2 よくあるトラブルと解決方法

**カメラプレビューが回転して表示される**

カメラセンサーの回転角度とデバイスの向きの関係で、プレビューが回転する場合があります。CameraActivity内で自動補正が行われますが、一部のデバイスでは正しく補正されない場合があります。デバイスを縦持ちまたは横持ちに変更して確認してください。

**スタイル変換のフレームレートが低い**

処理解像度を下げることでフレームレートを改善できます。「サイズ」ボタンをタップして128や192に変更してください。

**GPU/NNAPIデリゲートで推論が失敗する**

一部のデバイスではGPUデリゲートやNNAPIデリゲートがサポートされていません。CPUに切り替えて動作を確認してください。

**ベンチマーク結果が安定しない**

以下の点を確認してください。
- ベンチマーク実行中は他のアプリを操作しないでください
- デバイスの温度が上昇するとサーマルスロットリングで性能が低下します。十分に冷却してから再実行してください
- CPUアフィニティ設定にはroot権限が必要な場合があります

### 13.3 サポートへの連絡方法

TensorFlowに関する問い合わせは以下のチャネルを利用してください。

- **GitHub Issues**: https://github.com/tensorflow/tensorflow/issues
- **Stack Overflow**: `tensorflow` タグで質問を投稿
- **公式ドキュメント**: https://www.tensorflow.org/

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-02-02 | 初版作成 |

---

*本マニュアルは、TensorFlow Demoアプリケーション群のエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
