---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 30
  claims_with_evidence: 26
  claims_without_evidence: 4
confidence_derived: 0.87
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：26 / 30、根拠なし：4
- 優先レビュー（高）
  1. **RTO/RPOの具体値**：根拠不足（アプリケーション依存のため具体値なし）
  2. **マルチテナント環境のDoS対策詳細**：根拠不足（SECURITY.mdに概要のみ記載）
  3. **分散トレーニングスループット目標値**：根拠不足（ハードウェア依存のため具体値なし）
  4. **テスト体制の網羅性**：根拠不足（configure.pyのフィルタ設定のみが根拠、実際のテストカバレッジは未確認）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `tensorflow/python/distribute/collective_util.py` - Collective通信オプション（timeout_seconds=120.0, bytes_per_pack）
- E-02: `tensorflow/python/profiler/profiler_client.py` - Profiler Client API（num_tracing_attempts=3, duration_ms）
- E-03: `tensorflow/python/data/experimental/service/server_lib.py` - tf.data Service設定（DispatcherConfig, WorkerConfig）
- E-04: `tensorflow/python/eager/context.py` - Eager実行コンテキスト（_KEEP_ALIVE_SECS=600, メモリ管理, _device_parsing_cache）
- E-05: `SECURITY.md` - セキュリティモデル・脆弱性報告プロセス
- E-06: `tensorflow/dtensor/python/heartbeat.py` - DTensorハートビート機構
- E-07: `tensorflow/python/distribute/coordinator/cluster_coordinator.py` - クラスタコーディネーター（Watchdog, transient_timeouts_threshold）
- E-08: `tensorflow/python/checkpoint/async_checkpoint_helper.py` - 非同期チェックポイント
- E-09: `configure.py` - ビルド設定（CUDA, コンパイラ, プラットフォーム検出, テストフィルタ）
- E-10: `tensorflow/tf_version.bzl` - バージョン管理（TF_VERSION = "2.21.0"）
- E-11: `tensorflow/core/function/polymorphism/function_cache.py` - 関数キャッシュ
- E-12: `tensorflow/security/advisory/` - セキュリティアドバイザリディレクトリ
- E-13: `tensorflow/security/fuzzing/` - ファジングテストディレクトリ
- E-14: `tensorflow/python/distribute/` - 分散戦略モジュール群

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Collective通信のデフォルトタイムアウトは120秒 | E-01 | ○ |
| C-02 | Profilerのリトライ回数デフォルトは3回 | E-02 | ○ |
| C-03 | tf.data Serviceワーカーのディスパッチャータイムアウトはデフォルト1時間 | E-03 | ○ |
| C-04 | gRPCサーバーKeep Aliveは600秒 | E-04 | ○ |
| C-05 | worker_max_concurrent_snapshotsでスナップショット同時処理数を制御可能 | E-03 | ○ |
| C-06 | bytes_per_packでCollective通信のパック分割サイズを設定可能 | E-01 | ○ |
| C-07 | CUDA Compute Capabilityのデフォルトは3.5,7.0 | E-09 | ○ |
| C-08 | tf.data Serviceのフォールトトレラントモードでディスパッチャー復旧が可能 | E-03 | ○ |
| C-09 | WorkerConfigでハートビート間隔とタイムアウトを設定可能 | E-03 | ○ |
| C-10 | DTensorハートビートで異常検知時にlogging.fatalで停止 | E-06 | ○ |
| C-11 | クラスタコーディネーターはトランジェントタイムアウトを一定回数まで無視 | E-07 | ○ |
| C-12 | 非同期チェックポイントによるバックグラウンド保存が可能 | E-08 | ○ |
| C-13 | RTO（障害復旧時間）はアプリケーション依存 | **根拠なし** | △ |
| C-14 | RPO（目標復旧時点）は最終チェックポイント保存時点 | E-08 | ○ |
| C-15 | 信頼できる入力フォーマットはPNG, BMP, GIF, WAV, RAW, RAW_PADDED, CSV, PROTO | E-05 | ○ |
| C-16 | tf.train.Serverは認証プロトコルを含まず暗号化されない | E-05 | ○ |
| C-17 | マルチテナント環境のDoS対策にレートリミット・ACL・監視を推奨 | E-05 | ○ |
| C-18 | セキュリティ脆弱性修正は四半期リリースにバッチ処理 | E-05 | ○ |
| C-19 | Linux, macOS, Windows, Cygwinをサポート | E-09 | ○ |
| C-20 | Android NDK v19/20/21/25対応 | E-09 | ○ |
| C-21 | CUDAとROCmは排他的に設定 | E-09 | ○ |
| C-22 | Clang v16/17/18に対応 | E-09 | ○ |
| C-23 | 分散トレーニングの具体的なスループット値はハードウェア依存 | **根拠なし** | △ |
| C-24 | テストはsmall/mediumサイズをデフォルト実行 | E-09 | ○ |
| C-25 | セマンティックバージョニングで現行v2.21.0 | E-10 | ○ |
| C-26 | TensorFlow Profilerでgprc経由のオンデマンドプロファイリングが可能 | E-02 | ○ |
| C-27 | GPUメモリの動的成長・制限・統計取得が可能 | E-04 | ○ |
| C-28 | abseil-py loggingをプロジェクト全体で使用 | E-04, E-06, E-08 | ○ |
| C-29 | job_gc_check_interval_ms/job_gc_timeout_msでジョブGC設定が可能 | E-03 | ○ |
| C-30 | テスト体制がセキュリティテスト（ファジング）を含む完全な品質保証体制である | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: RTOの具体的な数値目標に関する記載がソースコードおよびドキュメントに存在しない。TensorFlowはフレームワークであるため、RTOはデプロイメント環境に依存する
  - 候補：運用ドキュメント / デプロイメントガイド / SLA定義書
- C-23: 分散トレーニングのスループット目標値はベンチマーク結果に依存するため、ソースコードからは読み取れない
  - 候補：ベンチマーク結果 / パフォーマンスガイド / TensorFlow公式ドキュメント
- C-30: ファジングテストの存在は確認できるが、テストカバレッジの全体像やCI/CDパイプラインとの統合状況は未確認
  - 候補：CI設定ファイル / テストレポート / CONTRIBUTING.md
- C-13に関連するDoS対策の具体的な実装については、SECURITY.mdに概要が記載されているのみで、ソースコード上の実装は確認できなかった（ユーザー責任の範囲）

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: RTO/RPOの具体的な数値目標が定義されていない。フレームワークとしての性質上やむを得ないが、TensorFlowを利用するアプリケーションでは個別に定義が必要
- **1（中リスク）**: tf.train.Serverが認証・暗号化を持たない点は、本番環境でのデプロイ時に追加のセキュリティ対策が必須
- **0（低リスク）**: テストフィルタリングの設定は確認できるが、実際のテストカバレッジ率は未検証
- **0（低リスク）**: レートリミットの実装がソースコードから確認できなかった（マルチテナント環境では外部対策が必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 性能要件のタイムアウト値・リトライ回数が実際のソースコードのデフォルト値と一致しているか
- [ ] SECURITY.mdの記載内容とセキュリティ要件セクションの記述が整合しているか
- [ ] 分散戦略のリストが現在サポートされている戦略を網羅しているか
- [ ] tf.data ServiceのDispatcherConfig/WorkerConfigのパラメータが最新のソースと一致しているか
- [ ] バージョン番号（v2.21.0）が正しいか
- [ ] CUDA/ROCm/NCCLの対応状況が最新のconfigure.pyと一致しているか
- [ ] RTO/RPO/スループットの「アプリケーション依存」という記述がプロジェクトの文脈で適切か
