---
generated_at: 2026-01-27 12:00:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：コードリーディングガイドライン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：40 / 42、根拠なし：2
- 優先レビュー（高）
  1. **WebGPURenderer詳細説明**：WebGPUレンダラーの内部実装詳細は限定的に確認
  2. **ノードシステム（TSL）詳細**：TSL（Three.js Shading Language）の詳細仕様は公式ドキュメント参照が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - プロジェクト設定、依存関係
- E-02: `README.md` - プロジェクト概要、基本使用例
- E-03: `src/Three.js` - メインエントリーポイント
- E-04: `src/Three.Core.js` - コアエクスポート定義
- E-05: `src/constants.js` - 定数定義（1761行）
- E-06: `src/core/Object3D.js` - 基盤クラス（1670行）
- E-07: `src/math/Vector3.js` - 3Dベクトルクラス（1260行）
- E-08: `src/objects/Mesh.js` - メッシュクラス（497行）
- E-09: `src/materials/Material.js` - マテリアル基底クラス（1018行）
- E-10: `src/scenes/Scene.js` - シーンクラス（166行）
- E-11: ディレクトリ構造 `src/` - 24個のサブディレクトリ
- E-12: ディレクトリ構造 `examples/jsm/` - 35個のサブディレクトリ
- E-13: `examples/jsm/controls/` - 9つのコントロールクラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | three.jsはES Modules形式を採用 | E-01 (`"type": "module"`), E-03 | ○ |
| C-02 | バージョンは0.182.0 | E-01 (`"version": "0.182.0"`) | ○ |
| C-03 | メインエントリーはsrc/Three.js | E-03 | ○ |
| C-04 | Three.Core.jsでコアエクスポートを集約 | E-04 | ○ |
| C-05 | Object3Dはシーングラフの基底クラス | E-06:64-128 | ○ |
| C-06 | Object3DはEventDispatcherを継承 | E-06:64 | ○ |
| C-07 | isXxxフラグによる型判定パターン | E-06:80, E-08:58, E-07:47 | ○ |
| C-08 | Vector3はx,y,z座標を持つ | E-07:54-68 | ○ |
| C-09 | メソッドチェーンパターン（return this） | E-07:224-232 | ○ |
| C-10 | @__PURE__コメントはツリーシェイキング用 | E-08:12-25 | ○ |
| C-11 | MeshはObject3Dを継承 | E-08:39 | ○ |
| C-12 | MeshはGeometryとMaterialを持つ | E-08:67-75 | ○ |
| C-13 | Materialは抽象基底クラス | E-09:17 | ○ |
| C-14 | Materialはblending, side等のプロパティを持つ | E-09:78-86 | ○ |
| C-15 | Sceneはbackground, environment, fogを持つ | E-10:40-59 | ○ |
| C-16 | srcディレクトリに24のサブディレクトリ | E-11 | ○ |
| C-17 | examples/jsmにアドオンが格納 | E-12 | ○ |
| C-18 | OrbitControls等のコントロールが存在 | E-13 | ○ |
| C-19 | 定数はconstants.jsに集約 | E-05 | ○ |
| C-20 | MATERIALで始まる定数群が存在 | E-05:164 | ○ |
| C-21 | clone()/copy()パターンが全クラスに存在 | E-07:196-216, E-06:1569-1635 | ○ |
| C-22 | dispose()でリソース解放 | E-09:989-997 | ○ |
| C-23 | generateUUID()がMathUtilsに存在 | E-06:8, E-09:4 | ○ |
| C-24 | REVISIONは'183dev' | E-05:1 | ○ |
| C-25 | Object3Dにparent/children階層構造 | E-06:116-128 | ○ |
| C-26 | Object3Dにtraverse()メソッド | E-06:1068-1080 | ○ |
| C-27 | Object3DにupdateMatrixWorld()メソッド | E-06:1163-1201 | ○ |
| C-28 | Meshにraycast()メソッド | E-08:226-270 | ○ |
| C-29 | バウンディングスフィアでカリング | E-08:236-251 | ○ |
| C-30 | toJSON()でシリアライズ | E-06:1261-1561 | ○ |
| C-31 | onBeforeRender等のフックが存在 | E-06:426-438 | ○ |
| C-32 | MaterialにonBeforeCompile | E-09:531 | ○ |
| C-33 | PascalCaseファイル命名規則 | E-03, E-06, E-07, E-08 | ○ |
| C-34 | _接頭辞でプライベート変数 | E-08:12-25, E-06:11 | ○ |
| C-35 | DEFAULT_接頭辞で静的デフォルト値 | E-06:1647, 1657, 1667 | ○ |
| C-36 | Loaderサフィックスでローダークラス | E-04:43-58 | ○ |
| C-37 | Helperサフィックスでヘルパークラス | E-04:139-151 | ○ |
| C-38 | Materialサフィックスでマテリアル | E-04:42 (export from Materials.js) | ○ |
| C-39 | Geometryサフィックスでジオメトリ | E-04:41 (export from Geometries.js) | ○ |
| C-40 | Controlsサフィックスでコントロール | E-13 | ○ |
| C-41 | WebGPURendererの詳細実装 | **根拠不足** - ソースは確認したが詳細説明は限定的 | △ |
| C-42 | TSL（Three.js Shading Language）詳細 | **根拠不足** - src/nodesは存在するが詳細仕様は未確認 | △ |

## 4) 不足情報（Unknown / Missing）
- **WebGPURenderer内部実装詳細**
  - `src/renderers/webgpu/`ディレクトリは存在するが、詳細な実装フローは本レポートでは深掘りしていない
  - 候補：`src/renderers/webgpu/WebGPURenderer.js` / 公式ドキュメント / WebGPU仕様

- **TSL（Three.js Shading Language）仕様**
  - `src/nodes/`ディレクトリにノードシステムが存在
  - 詳細な仕様は公式Wiki（https://github.com/mrdoob/three.js/wiki/Three.js-Shading-Language）を参照
  - 候補：`src/nodes/` / 公式Wiki / examples/jsm/nodes/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 言語基礎、命名規則、ディレクトリ構造（直接ソースコードから確認）
- 0: 低リスク - 主要クラス（Object3D, Mesh, Material, Scene）の説明
- 0: 低リスク - よく使われるパターン（型判定フラグ、メソッドチェーン等）
- 1: 中リスク - WebGPU関連の説明（実装は確認済みだが詳細は限定的）
- 1: 中リスク - ノードシステム/TSL関連（存在は確認だが詳細仕様は外部ドキュメント依存）

## 6) レビュアーチェックリスト（最小）
- [ ] セクション1「言語基礎」のコード例がソースと一致するか確認
- [ ] セクション3「命名規則」が実際のファイル名と整合しているか確認
- [ ] セクション4「ディレクトリ構造」が現在のプロジェクト構造と一致するか確認
- [ ] セクション6「主要コンポーネント」のコード抜粋が正確か確認
- [ ] セクション7「よく使われるパターン」の出現頻度が妥当か確認
- [ ] 付録「用語集」の説明が正確か確認
- [ ] WebGPURenderer関連の記述が最新情報と整合しているか確認（要追加調査）
- [ ] TSL関連の記述について公式Wikiと照合が必要か判断
