---
generated_at: 2026-01-27 13:35:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：40 / 42、根拠なし：2
- 優先レビュー（高）
  1. **ノードシステムキャッシュTTL**: 内部実装の詳細確認必要
  2. **TSL正式名称**: 公式ドキュメントでの確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - バージョン、依存関係、ビルド設定
- E-02: `src/Three.js` - メインエントリポイント
- E-03: `src/Three.Core.js` - コアモジュールエクスポート
- E-04: `src/Three.WebGPU.js` - WebGPUエントリポイント
- E-05: `src/core/Object3D.js` - シーングラフノード基底クラス
- E-06: `src/core/EventDispatcher.js` - イベントシステム
- E-07: `src/scenes/Scene.js` - シーンクラス
- E-08: `src/objects/Mesh.js` - メッシュクラス
- E-09: `src/renderers/WebGLRenderer.js` - WebGLレンダラー
- E-10: `src/renderers/common/Renderer.js` - 共通レンダラー基盤
- E-11: `src/renderers/webgpu/WebGPURenderer.js` - WebGPUレンダラー
- E-12: `src/nodes/Nodes.js` - ノードシステムエクスポート
- E-13: `src/nodes/TSL.js` - Three.js Shading Language
- E-14: `src/materials/Material.js` - マテリアル基底クラス（ディレクトリ確認）
- E-15: `src/geometries/` - ジオメトリディレクトリ構成
- E-16: `src/loaders/` - ローダーディレクトリ構成
- E-17: `examples/jsm/Addons.js` - Addonsエクスポート
- E-18: `README.md` - プロジェクト概要
- E-19: `src/constants.js` - 定数定義
- E-20: `src/utils.js` - ユーティリティ関数

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Three.jsバージョンは0.182.0 | E-01 | ○ |
| C-02 | WebGLとWebGPUをバックエンドとして使用 | E-02, E-04, E-09, E-11 | ○ |
| C-03 | コンポーネントベースアーキテクチャを採用 | E-05, E-08, E-07 | ○ |
| C-04 | EventDispatcherによるイベント駆動設計 | E-06 | ○ |
| C-05 | Object3Dはシーングラフノードの基底クラス | E-05 | ○ |
| C-06 | SceneはObject3Dを継承 | E-07 | ○ |
| C-07 | MeshはObject3Dを継承しGeometry+Materialを保持 | E-08 | ○ |
| C-08 | WebGLRendererはWebGL 2のみサポート（r163以降） | E-09 | ○ |
| C-09 | ノードシステムはnodes/ディレクトリに存在 | E-12 | ○ |
| C-10 | TSL (Three.js Shading Language)が存在 | E-13 | ○ |
| C-11 | 共通レンダラー基盤がrenderers/common/に存在 | E-10 | ○ |
| C-12 | WebGPURendererがrenderers/webgpu/に存在 | E-11 | ○ |
| C-13 | MaterialsにMeshStandardMaterial等が存在 | E-14 | ○ |
| C-14 | 20種類以上のジオメトリプリミティブが存在 | E-15 | ○ |
| C-15 | 複数のローダークラスが存在 | E-16 | ○ |
| C-16 | Addonsはexamples/jsm/に分離 | E-17 | ○ |
| C-17 | ESModules形式を採用 | E-01 | ○ |
| C-18 | Rollupでビルド | E-01 | ○ |
| C-19 | ESLintでリント | E-01 | ○ |
| C-20 | QUnitでユニットテスト | E-01 | ○ |
| C-21 | Puppeteerでe2eテスト | E-01 | ○ |
| C-22 | 対応ブラウザは"> 1%, not dead, not ie 11" | E-01 | ○ |
| C-23 | Three.Coreにコアモジュールが集約 | E-03 | ○ |
| C-24 | WebAudio APIを使用 | E-03 (AudioListener等のexport) | ○ |
| C-25 | WebXR APIをサポート | E-03 (WebXRController) | ○ |
| C-26 | constants.jsに定数が定義 | E-19 | ○ |
| C-27 | utils.jsにlog, warn, error関数 | E-20 | ○ |
| C-28 | warnOnce関数で警告重複抑制 | E-20 | ○ |
| C-29 | Cache (loaders/Cache.js)でアセットキャッシュ | E-16 | ○ |
| C-30 | isXxxフラグで型判定 | E-05, E-08, E-09 | ○ |
| C-31 | Vector3, Matrix4等のMathモジュール | E-05 (import文) | ○ |
| C-32 | traverse()メソッドでシーングラフ走査 | E-05 (Object3D) | ○ |
| C-33 | clone()メソッドでインスタンス複製 | E-07 (Scene.copy) | ○ |
| C-34 | toJSON()でシリアライゼーション | E-07 | ○ |
| C-35 | PerspectiveCamera, OrthographicCamera存在 | E-03 | ○ |
| C-36 | DirectionalLight, PointLight, SpotLight存在 | E-03 | ○ |
| C-37 | SkinnedMesh, InstancedMesh存在 | E-03 | ○ |
| C-38 | ShaderMaterial, RawShaderMaterial存在 | E-14 (ディレクトリ) | ○ |
| C-39 | NodeMaterialがmaterials/nodes/に存在 | E-04 | ○ |
| C-40 | Fog, FogExp2がscenes/に存在 | E-03 | ○ |
| C-41 | NodeCacheのTTLはレンダリングフレーム | **根拠なし** | △ |
| C-42 | TSLの正式名称は「Three.js Shading Language」 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **NodeCacheのTTL**：内部実装の動作確認が必要。ソースコード上でのキャッシュ有効期間の明示的な定義が確認できず。
  - 候補：`src/nodes/core/NodeCache.js` / レンダラー実装 / 公式ドキュメント
- **TSLの正式名称**：ソースコード内ではTSLとして参照されているが、正式な展開形の公式定義を確認できず。
  - 候補：公式ドキュメント / リリースノート / コミュニティディスカッション

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 基本的なモジュール構成、継承関係、エントリポイント
- **0（低リスク）**: バージョン情報、依存関係
- **1（中リスク）**: ノードシステムの内部動作詳細（キャッシュ戦略等）
- **0（低リスク）**: レンダリングパイプラインの概要フロー
- **1（中リスク）**: 設計原則の適用箇所（解釈の余地あり）

## 6) レビュアーチェックリスト（最小）
- [ ] package.jsonとドキュメントのバージョン番号が一致しているか確認
- [ ] レイヤー定義が実際のディレクトリ構成と整合しているか確認
- [ ] モジュール依存関係図がimport文と一致しているか確認
- [ ] 継承関係がソースコードのextends句と一致しているか確認
- [ ] △の項目（C-41, C-42）について追加調査が必要か判断
- [ ] 設計原則の適用例が実際のコードパターンと合致しているか確認
- [ ] ミドルウェア構成の「該当なし」が適切か確認（サーバーサイド想定を含めていないか）
