# アーキテクチャ構成図

## 全体アーキテクチャ

```mermaid
graph TB
    subgraph Application["Application Layer"]
        UserApp[User Application Code]
    end

    subgraph API["Three.js API Layer"]
        Core[Three.Core.js]
        WebGPUEntry[Three.WebGPU.js]
        MainEntry[Three.js]
    end

    subgraph SceneGraph["Scene Graph"]
        Scene[Scene]
        Camera[Camera]
        Object3D[Object3D]
        Mesh[Mesh]
        Light[Light]
        Group[Group]
    end

    subgraph Components["Components"]
        Geometry[BufferGeometry]
        Material[Material]
        Texture[Texture]
    end

    subgraph NodeSystem["Node System"]
        Nodes[Nodes.js]
        TSL[TSL.js]
        NodeBuilder[NodeBuilder]
        NodeMaterial[NodeMaterial]
    end

    subgraph Rendering["Rendering Layer"]
        Renderer[Renderer]
        RenderList[RenderList]
        RenderObject[RenderObject]
        Pipelines[Pipelines]
        Bindings[Bindings]
    end

    subgraph Backend["Backend Layer"]
        WebGLRenderer[WebGLRenderer]
        WebGPURenderer[WebGPURenderer]
        WebGPUBackend[WebGPUBackend]
        WebGLBackend[WebGLBackend]
    end

    subgraph BrowserAPIs["Browser APIs"]
        WebGL[WebGL 2 API]
        WebGPU[WebGPU API]
        Canvas[Canvas API]
    end

    UserApp --> Core
    UserApp --> WebGPUEntry
    UserApp --> MainEntry

    Core --> SceneGraph
    Core --> Components
    MainEntry --> WebGLRenderer
    WebGPUEntry --> NodeSystem
    WebGPUEntry --> WebGPURenderer

    SceneGraph --> Rendering
    Components --> Rendering
    NodeSystem --> Rendering

    Rendering --> Backend

    WebGLRenderer --> WebGL
    WebGPURenderer --> WebGPUBackend
    WebGPURenderer --> WebGLBackend
    WebGPUBackend --> WebGPU
    WebGLBackend --> WebGL
    Backend --> Canvas
```

## モジュール依存関係

```mermaid
graph LR
    subgraph Core["core/"]
        EventDispatcher
        Object3D
        BufferGeometry
        BufferAttribute
        RenderTarget
        Raycaster
    end

    subgraph Math["math/"]
        Vector2
        Vector3
        Vector4
        Matrix3
        Matrix4
        Quaternion
        Euler
        Color
    end

    subgraph Objects["objects/"]
        Mesh
        Line
        Points
        Sprite
        SkinnedMesh
        InstancedMesh
    end

    subgraph Scenes["scenes/"]
        Scene
        Fog
    end

    subgraph Cameras["cameras/"]
        Camera
        PerspectiveCamera
        OrthographicCamera
    end

    subgraph Lights["lights/"]
        Light
        DirectionalLight
        PointLight
        SpotLight
    end

    subgraph Materials["materials/"]
        Material
        MeshBasicMaterial
        MeshStandardMaterial
        ShaderMaterial
    end

    EventDispatcher --> Object3D
    Object3D --> Mesh
    Object3D --> Line
    Object3D --> Scene
    Object3D --> Camera
    Object3D --> Light

    Math --> Core
    Math --> Objects
    Math --> Cameras

    BufferGeometry --> Mesh
    Material --> Mesh
```

## クラス継承関係

```mermaid
classDiagram
    class EventDispatcher {
        +addEventListener()
        +removeEventListener()
        +dispatchEvent()
    }

    class Object3D {
        +position: Vector3
        +rotation: Euler
        +scale: Vector3
        +matrix: Matrix4
        +matrixWorld: Matrix4
        +add()
        +remove()
        +traverse()
    }

    class Scene {
        +background
        +environment
        +fog
    }

    class Camera {
        +matrixWorldInverse
        +projectionMatrix
    }

    class PerspectiveCamera {
        +fov
        +aspect
        +near
        +far
    }

    class OrthographicCamera {
        +left
        +right
        +top
        +bottom
    }

    class Mesh {
        +geometry
        +material
        +raycast()
    }

    class Light {
        +color
        +intensity
    }

    class DirectionalLight {
        +target
        +shadow
    }

    class PointLight {
        +distance
        +decay
    }

    EventDispatcher <|-- Object3D
    Object3D <|-- Scene
    Object3D <|-- Camera
    Object3D <|-- Mesh
    Object3D <|-- Light
    Camera <|-- PerspectiveCamera
    Camera <|-- OrthographicCamera
    Light <|-- DirectionalLight
    Light <|-- PointLight
```

## マテリアル継承関係

```mermaid
classDiagram
    class Material {
        +uuid
        +name
        +type
        +side
        +transparent
        +opacity
        +clone()
        +dispose()
    }

    class MeshBasicMaterial {
        +color
        +map
        +wireframe
    }

    class MeshStandardMaterial {
        +color
        +roughness
        +metalness
        +normalMap
    }

    class MeshPhysicalMaterial {
        +clearcoat
        +transmission
        +ior
    }

    class ShaderMaterial {
        +vertexShader
        +fragmentShader
        +uniforms
    }

    class RawShaderMaterial {
    }

    class NodeMaterial {
        +vertexNode
        +fragmentNode
        +build()
    }

    Material <|-- MeshBasicMaterial
    Material <|-- MeshStandardMaterial
    Material <|-- ShaderMaterial
    MeshStandardMaterial <|-- MeshPhysicalMaterial
    ShaderMaterial <|-- RawShaderMaterial
    ShaderMaterial <|-- NodeMaterial
```

## レンダリングパイプライン

```mermaid
sequenceDiagram
    participant App as Application
    participant Renderer as Renderer
    participant Scene as Scene
    participant RenderList as RenderList
    participant Pipeline as Pipelines
    participant Backend as Backend
    participant GPU as GPU API

    App->>Renderer: render(scene, camera)
    Renderer->>Scene: traverse()
    Scene-->>Renderer: Object3D list
    Renderer->>Renderer: Frustum Culling
    Renderer->>RenderList: push(objects)
    RenderList->>RenderList: sort()
    loop Each RenderObject
        Renderer->>Pipeline: getPipeline(material, geometry)
        Pipeline-->>Renderer: Pipeline
        Renderer->>Backend: draw(renderObject)
        Backend->>GPU: Draw Commands
    end
    GPU-->>App: Frame Complete
```

## ノードシステム構成

```mermaid
graph TB
    subgraph TSL["TSL (Three.js Shading Language)"]
        float[float]
        vec2[vec2]
        vec3[vec3]
        vec4[vec4]
        mat3[mat3]
        mat4[mat4]
    end

    subgraph NodeCore["Node Core"]
        Node[Node]
        NodeBuilder[NodeBuilder]
        NodeFrame[NodeFrame]
        NodeCache[NodeCache]
    end

    subgraph AccessorNodes["Accessor Nodes"]
        TextureNode[TextureNode]
        BufferNode[BufferNode]
        UniformNode[UniformNode]
        AttributeNode[AttributeNode]
    end

    subgraph MathNodes["Math Nodes"]
        OperatorNode[OperatorNode]
        MathNode[MathNode]
        ConditionalNode[ConditionalNode]
    end

    subgraph DisplayNodes["Display Nodes"]
        ColorSpaceNode[ColorSpaceNode]
        ToneMappingNode[ToneMappingNode]
        NormalMapNode[NormalMapNode]
    end

    subgraph LightingNodes["Lighting Nodes"]
        LightsNode[LightsNode]
        ShadowNode[ShadowNode]
        EnvironmentNode[EnvironmentNode]
    end

    subgraph MaterialNodes["Material Nodes"]
        NodeMaterial[NodeMaterial]
        MeshBasicNodeMaterial[MeshBasicNodeMaterial]
        MeshStandardNodeMaterial[MeshStandardNodeMaterial]
    end

    TSL --> NodeCore
    NodeCore --> AccessorNodes
    NodeCore --> MathNodes
    NodeCore --> DisplayNodes
    NodeCore --> LightingNodes
    AccessorNodes --> MaterialNodes
    MathNodes --> MaterialNodes
    DisplayNodes --> MaterialNodes
    LightingNodes --> MaterialNodes
```

## アセットローディングフロー

```mermaid
sequenceDiagram
    participant App as Application
    participant Loader as Loader
    participant FileLoader as FileLoader
    participant Cache as Cache
    participant Server as Server/Network

    App->>Loader: load(url, onLoad, onProgress, onError)
    Loader->>Cache: check(url)
    alt Cache Hit
        Cache-->>Loader: Cached Data
    else Cache Miss
        Loader->>FileLoader: load(url)
        FileLoader->>Server: fetch(url)
        Server-->>FileLoader: Response
        FileLoader->>Cache: store(url, data)
        FileLoader-->>Loader: Loaded Data
    end
    Loader->>Loader: parse(data)
    Loader-->>App: onLoad(result)
```

## WebXRアーキテクチャ

```mermaid
graph TB
    subgraph Application["Application"]
        VRApp[VR/AR Application]
    end

    subgraph XRSystem["XR System"]
        XRManager[XRManager]
        WebXRController[WebXRController]
        XRRenderTarget[XRRenderTarget]
    end

    subgraph Rendering["Rendering"]
        Renderer[Renderer]
        ArrayCamera[ArrayCamera]
        StereoCamera[StereoCamera]
    end

    subgraph BrowserXR["Browser XR API"]
        WebXRAPI[WebXR Device API]
        XRSession[XRSession]
        XRFrame[XRFrame]
    end

    VRApp --> XRManager
    XRManager --> WebXRController
    XRManager --> XRRenderTarget
    XRManager --> Renderer
    Renderer --> ArrayCamera
    Renderer --> StereoCamera
    XRManager --> WebXRAPI
    WebXRAPI --> XRSession
    XRSession --> XRFrame
```

## ビルド成果物構成

```mermaid
graph LR
    subgraph Source["Source (src/)"]
        ThreeJS[Three.js]
        ThreeCore[Three.Core.js]
        ThreeWebGPU[Three.WebGPU.js]
        ThreeTSL[Three.TSL.js]
    end

    subgraph Build["Build Output (build/)"]
        CJS[three.cjs]
        ESM[three.module.js]
        ESMMin[three.module.min.js]
        CoreJS[three.core.js]
        WebGPUJS[three.webgpu.js]
        TSLJS[three.tsl.js]
    end

    subgraph Addons["Addons (examples/jsm/)"]
        AddonsJS[Addons.js]
        Controls[controls/]
        Loaders[loaders/]
        Effects[effects/]
        Exporters[exporters/]
    end

    ThreeJS --> CJS
    ThreeJS --> ESM
    ESM --> ESMMin
    ThreeCore --> CoreJS
    ThreeWebGPU --> WebGPUJS
    ThreeTSL --> TSLJS

    AddonsJS --> Controls
    AddonsJS --> Loaders
    AddonsJS --> Effects
    AddonsJS --> Exporters
```
