---
generated_at: 2026-01-27 11:40:00
metrics:
  claims_total: 28
  claims_with_evidence: 24
  claims_without_evidence: 4
confidence_derived: 0.86
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：24 / 28、根拠なし：4
- 優先レビュー（高）
  1. **threejs.org ホスティング詳細**：公式サイトのインフラ詳細が未確認
  2. **npm publish手順**：実際のリリースワークフローが未確認
  3. **GitHub Actions実行環境詳細**：ubuntu-latestの具体的スペックは外部依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - プロジェクト設定、依存関係、スクリプト定義
- E-02: `.github/workflows/ci.yml` - CIワークフロー定義
- E-03: `.github/workflows/codeql-code-scanning.yml` - セキュリティスキャン設定
- E-04: `.github/workflows/read-size.yml` - バンドルサイズ計測ワークフロー
- E-05: `.github/workflows/report-size.yml` - サイズレポートワークフロー
- E-06: `.github/workflows/protected-folders.yml` - 保護フォルダチェック
- E-07: `utils/build/rollup.config.js` - ビルド設定
- E-08: `utils/server.js` - 開発サーバー実装
- E-09: `README.md` - プロジェクト概要、リンク情報
- E-10: `build/` ディレクトリ - ビルド出力ファイル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | three.jsはnpmパッケージとして配信される | E-01 (name: "three") | ○ |
| C-02 | バージョン0.182.0 | E-01 (version: "0.182.0") | ○ |
| C-03 | GitHub Actionsを使用 | E-02, E-03, E-04, E-05, E-06 | ○ |
| C-04 | Node.js 24を使用 | E-02 (node-version: 24) | ○ |
| C-05 | Rollup 4.6.0+でビルド | E-01 (devDependencies) | ○ |
| C-06 | ESLint 9.0.0+でリント | E-01 (devDependencies) | ○ |
| C-07 | QUnit 2.19.4+でテスト | E-01 (devDependencies) | ○ |
| C-08 | Puppeteer 24.25.0+でE2E | E-01 (devDependencies) | ○ |
| C-09 | E2Eテストは5並列実行 | E-02 (matrix.CI: [0,1,2,3,4]) | ○ |
| C-10 | CodeQLで週次セキュリティスキャン | E-03 (cron: '29 23 * * 0') | ○ |
| C-11 | build/, docs/は保護フォルダ | E-06 | ○ |
| C-12 | 開発サーバーはポート8080 | E-08, E-01 (scripts.dev) | ○ |
| C-13 | ポート競合時は自動リトライ | E-08 (tryListen, maxAttempts=20) | ○ |
| C-14 | Range Requestsサポート | E-08 (range handling) | ○ |
| C-15 | three.module.jsはESM形式 | E-07 (format: 'esm') | ○ |
| C-16 | three.cjsはCommonJS形式 | E-07 (format: 'cjs') | ○ |
| C-17 | terserで圧縮 | E-07 (terser plugin) | ○ |
| C-18 | GLSLプラグインでシェーダー最適化 | E-07 (glsl function) | ○ |
| C-19 | バンドルサイズをPRコメントで報告 | E-05 (create-or-update-comment) | ○ |
| C-20 | WebGL/WebGPU/WebGPU Nodesの3種類計測 | E-04, E-05 | ○ |
| C-21 | fail-fast: false設定 | E-02 (fail-fast: false) | ○ |
| C-22 | jsDelivrでCDN配信 | E-09 (jsdelivr badge) | ○ |
| C-23 | threejs.orgでドキュメント配信 | E-09 (homepage) | ○ |
| C-24 | 最小権限の権限設定 | E-02, E-03, E-04, E-06 (permissions) | ○ |
| C-25 | threejs.orgのホスティング詳細 | **根拠なし** | △ |
| C-26 | npm publishの具体的手順 | **根拠なし** | △ |
| C-27 | Dependabotの設定詳細 | **根拠なし** | △ |
| C-28 | GitHub Actions Runnerの詳細スペック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **threejs.org ホスティング**：公式サイトのサーバー構成、CDN設定などの詳細情報が未確認
  - 候補：GitHub Pages / Vercel / Netlify / カスタムホスティング
- **npm publishワークフロー**：リリース時の自動化手順が未確認
  - 候補：手動publish / GitHub Actions自動化 / semantic-release
- **Dependabot設定**：.github/dependabot.ymlの存在が未確認
  - 候補：設定あり / 設定なし / Renovate使用
- **GitHub Actions Runner詳細**：ubuntu-latestの具体的なCPU/メモリは外部依存
  - 候補：GitHub公式ドキュメント参照

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: CI/CD設定、ビルド設定、開発サーバー設定 - 全て実ファイルから確認済み
- **1（中リスク）**: 外部サービス連携（npm, jsDelivr）- 公開情報とREADMEから推測可能
- **2（高リスク）**: threejs.orgホスティング詳細 - プロジェクト外の情報のため未確認

## 6) レビュアーチェックリスト（最小）
- [ ] CI/CDワークフローの設定が最新のGitHub Actions仕様に準拠しているか
- [ ] バンドルサイズの記載値が最新ビルド出力と一致しているか
- [ ] 開発サーバーのセキュリティ設定（path traversal対策等）が適切か
- [ ] threejs.orgの実際のホスティング構成を確認し、必要に応じて追記
- [ ] npm publishプロセスの詳細を確認し、必要に応じて追記
