# インフラ構成図

## 全体構成図

```mermaid
graph TB
    subgraph "開発者環境"
        DEV[開発者]
        LOCAL[ローカル開発サーバー<br/>Node.js HTTP Server<br/>Port 8080]
    end

    subgraph "ソースコード管理"
        GH[GitHub Repository<br/>mrdoob/three.js]
    end

    subgraph "CI/CD パイプライン"
        GHA[GitHub Actions]

        subgraph "ワークフロー"
            CI[CI Workflow<br/>Lint, Unit Test, E2E]
            SIZE[Size Check Workflow<br/>Bundle Size Monitoring]
            CODEQL[CodeQL Workflow<br/>Security Scan]
            PROTECT[Protected Folders<br/>Auto-generated Check]
        end
    end

    subgraph "パッケージ配信"
        NPM[npm Registry<br/>package: three]
        JSDELIVR[jsDelivr CDN]
        UNPKG[unpkg CDN]
    end

    subgraph "ドキュメント・サイト"
        DOCS[threejs.org<br/>Documentation]
        EXAMPLES[Examples]
    end

    subgraph "エンドユーザー"
        BROWSER[Webブラウザ]
        NODEJS[Node.js環境]
    end

    DEV -->|開発・テスト| LOCAL
    DEV -->|git push/PR| GH

    GH -->|trigger| GHA
    GHA --> CI
    GHA --> SIZE
    GHA --> CODEQL
    GHA --> PROTECT

    GH -->|npm publish| NPM
    NPM -->|auto sync| JSDELIVR
    NPM -->|auto sync| UNPKG

    BROWSER -->|import| JSDELIVR
    BROWSER -->|import| UNPKG
    NODEJS -->|npm install| NPM

    BROWSER --> DOCS
    BROWSER --> EXAMPLES
```

## CI/CDパイプライン詳細

```mermaid
graph LR
    subgraph "Pull Request トリガー"
        PR[Pull Request]
    end

    subgraph "CI ワークフロー"
        CHECKOUT1[Git Checkout]
        INSTALL1[npm ci]
        LINT[Lint<br/>eslint src]
        UNIT[Unit Test<br/>QUnit]
        ADDONS[Unit Addons Test]
        E2E_COV[E2E Coverage Check]
    end

    subgraph "E2E テスト（並列）"
        E2E0[E2E Test CI=0]
        E2E1[E2E Test CI=1]
        E2E2[E2E Test CI=2]
        E2E3[E2E Test CI=3]
        E2E4[E2E Test CI=4]
    end

    subgraph "サイズチェック"
        BUILD[Build]
        TREESHAKE[Tree-shake Test]
        MEASURE[Size Measurement]
        REPORT[PR Comment Report]
    end

    PR --> CHECKOUT1
    CHECKOUT1 --> INSTALL1
    INSTALL1 --> LINT
    LINT --> UNIT
    UNIT --> ADDONS
    ADDONS --> E2E_COV

    INSTALL1 --> E2E0
    INSTALL1 --> E2E1
    INSTALL1 --> E2E2
    INSTALL1 --> E2E3
    INSTALL1 --> E2E4

    PR --> BUILD
    BUILD --> TREESHAKE
    TREESHAKE --> MEASURE
    MEASURE --> REPORT
```

## ビルド出力構成

```mermaid
graph TB
    subgraph "ソースファイル"
        SRC_CORE[src/Three.Core.js]
        SRC_MAIN[src/Three.js]
        SRC_GPU[src/Three.WebGPU.js]
        SRC_NODES[src/Three.WebGPU.Nodes.js]
        SRC_TSL[src/Three.TSL.js]
    end

    subgraph "Rollup ビルドプロセス"
        ROLLUP[Rollup]
        GLSL[GLSL Plugin<br/>シェーダー最適化]
        HEADER[Header Plugin<br/>ライセンス挿入]
        TERSER[Terser Plugin<br/>圧縮]
    end

    subgraph "ビルド出力 (build/)"
        OUT_CORE[three.core.js<br/>1.4MB]
        OUT_MODULE[three.module.js<br/>634KB]
        OUT_GPU[three.webgpu.js<br/>2.0MB]
        OUT_NODES[three.webgpu.nodes.js<br/>2.0MB]
        OUT_TSL[three.tsl.js<br/>33KB]
        OUT_CJS[three.cjs<br/>2.1MB]

        OUT_CORE_MIN[three.core.min.js<br/>383KB]
        OUT_MODULE_MIN[three.module.min.js<br/>357KB]
        OUT_GPU_MIN[three.webgpu.min.js<br/>622KB]
        OUT_NODES_MIN[three.webgpu.nodes.min.js<br/>620KB]
        OUT_TSL_MIN[three.tsl.min.js<br/>23KB]
    end

    SRC_CORE --> ROLLUP
    SRC_MAIN --> ROLLUP
    SRC_GPU --> ROLLUP
    SRC_NODES --> ROLLUP
    SRC_TSL --> ROLLUP

    ROLLUP --> GLSL
    GLSL --> HEADER
    HEADER --> OUT_CORE
    HEADER --> OUT_MODULE
    HEADER --> OUT_GPU
    HEADER --> OUT_NODES
    HEADER --> OUT_TSL
    HEADER --> OUT_CJS

    HEADER --> TERSER
    TERSER --> OUT_CORE_MIN
    TERSER --> OUT_MODULE_MIN
    TERSER --> OUT_GPU_MIN
    TERSER --> OUT_NODES_MIN
    TERSER --> OUT_TSL_MIN
```

## 開発サーバー構成

```mermaid
graph TB
    subgraph "ローカル開発環境"
        CLI[npm run dev]
        BUILD_DEV[dev.js<br/>開発ビルド]
        SERVER[server.js<br/>HTTP Server]
    end

    subgraph "サーバー機能"
        STATIC[静的ファイル配信]
        DIRLIST[ディレクトリリスティング]
        MIME[MIMEタイプ判定]
        RANGE[Range Requests]
    end

    subgraph "ポート管理"
        PORT[デフォルト: 8080]
        RETRY[自動リトライ<br/>最大20回]
    end

    subgraph "配信コンテンツ"
        EXAMPLES_DIR["/examples"]
        BUILD_DIR["/build"]
        DOCS_DIR["/docs"]
        MANUAL_DIR["/manual"]
    end

    CLI --> BUILD_DEV
    BUILD_DEV --> SERVER
    SERVER --> STATIC
    SERVER --> DIRLIST
    SERVER --> MIME
    SERVER --> RANGE

    SERVER --> PORT
    PORT --> RETRY

    STATIC --> EXAMPLES_DIR
    STATIC --> BUILD_DIR
    STATIC --> DOCS_DIR
    STATIC --> MANUAL_DIR
```

## セキュリティ構成

```mermaid
graph TB
    subgraph "GitHub Security"
        CODEQL[CodeQL Analysis<br/>JavaScript Security Scan]
        DEPENDABOT[Dependabot<br/>依存関係更新]
        PROTECTED[Protected Folders<br/>build/ docs/]
    end

    subgraph "権限管理"
        READ[contents: read]
        WRITE_PR[pull-requests: write]
        WRITE_SEC[security-events: write]
    end

    subgraph "スキャン対象"
        SRC[src/**]
        EXAMPLES_CODE[examples/**]
        UTILS[utils/**]
    end

    subgraph "結果出力"
        ALERTS[Security Alerts]
        PR_COMMENTS[PR Comments]
    end

    CODEQL --> READ
    CODEQL --> WRITE_SEC

    SRC --> CODEQL
    EXAMPLES_CODE --> CODEQL
    UTILS --> CODEQL

    CODEQL --> ALERTS
    PROTECTED --> PR_COMMENTS
```

## パッケージ配信フロー

```mermaid
sequenceDiagram
    participant Dev as 開発者
    participant GH as GitHub
    participant NPM as npm Registry
    participant CDN as jsDelivr/unpkg
    participant User as エンドユーザー

    Dev->>GH: リリースタグ作成
    GH->>NPM: npm publish
    NPM->>NPM: パッケージ登録
    NPM-->>CDN: 自動同期

    User->>NPM: npm install three
    NPM-->>User: パッケージダウンロード

    User->>CDN: import from CDN URL
    CDN-->>User: ライブラリ配信
```
