# インフラ設計書

## 概要

本ドキュメントは、three.js（JavaScript 3Dライブラリ）プロジェクトのインフラストラクチャ設計について記載する。three.jsはクライアントサイドで動作するJavaScriptライブラリであり、サーバーサイドのインフラストラクチャは主にCI/CD、開発環境、およびパッケージ配信に関連する。

## システム構成

### 全体構成

three.jsはnpmパッケージとして配信されるJavaScriptライブラリである。プロジェクトのインフラストラクチャは以下の主要コンポーネントで構成される。

1. **ソースコード管理**: GitHub（https://github.com/mrdoob/three.js）
2. **CI/CDパイプライン**: GitHub Actions
3. **パッケージ配信**: npm Registry
4. **CDN配信**: jsDelivr、unpkg
5. **ドキュメント配信**: threejs.org

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| GitHub Actions Runner | CI/CDワークフロー実行 | ubuntu-latest（GitHub管理） | オンデマンド |
| npm Registry | パッケージホスティング | npm管理 | npm管理 |
| jsDelivr CDN | ライブラリ配信 | CDNエッジサーバー | グローバル分散 |

### ネットワーク構成

本プロジェクトは外部サービスに依存したネットワーク構成となる。

- **ソースリポジトリ**: GitHub（HTTPS/SSH）
- **CI/CD**: GitHub Actionsワークフロー
- **パッケージ配信**: npm Registry（HTTPS）
- **CDN配信**: jsDelivr、unpkg（HTTPS）

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Node.js | 24 | ビルド、テスト実行 |
| Rollup | 4.6.0+ | バンドル作成 |
| ESLint | 9.0.0+ | コード品質チェック |
| QUnit | 2.19.4+ | ユニットテスト |
| Puppeteer | 24.25.0+ | E2Eテスト |
| terser | 0.4.0+ | コード圧縮 |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub | ソースコード管理、Issue管理、PR管理 | HTTPS/SSH |
| GitHub Actions | CI/CDパイプライン実行 | GitHub統合 |
| npm Registry | パッケージ公開・配信 | HTTPS（npm CLI） |
| jsDelivr | CDN配信 | HTTPS（自動同期） |
| Bundlephobia | バンドルサイズ計測 | HTTPS |
| CodeQL | セキュリティスキャン | GitHub統合 |

## スケーリング設計

本プロジェクトはクライアントサイドライブラリであるため、サーバーサイドのスケーリングは外部サービスに依存する。

### ビルド/テスト実行のスケーリング

- **GitHub Actions**: 並列ジョブ実行によるスケーリング
  - E2Eテストは5つの並列ジョブ（CI: 0-4）で分散実行
  - fail-fast: false設定により、一部失敗時も他のジョブは継続

### パッケージ配信のスケーリング

- **npm Registry**: グローバル分散インフラストラクチャ
- **jsDelivr CDN**: エッジキャッシュによるグローバル配信
  - 自動的にnpmパッケージをCDNにミラーリング

## 可用性設計

### CI/CD可用性

- GitHub Actionsは高可用性インフラストラクチャ上で動作
- ワークフロー失敗時はアーティファクトとログが保持される
- pull_request、push、scheduleの複数トリガーをサポート

### パッケージ配信可用性

- npm Registryは複数リージョンで冗長化
- jsDelivrはマルチCDNアーキテクチャ（Cloudflare、Fastly、Bunny等）

### セキュリティ設計

- **CodeQL**: 週次スケジュール（毎週日曜23:29 UTC）でセキュリティスキャン
- **Protected Folders**: build/、docs/フォルダは自動生成されるため、PRでの変更を制限
- **ワークフロー権限**: 最小権限原則に基づいた権限設定
  - contents: read
  - pull-requests: write（レポート用）
  - security-events: write（CodeQL用）

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Git履歴 | コミットごと | 永続 |
| ビルドアーティファクト | GitHub Artifacts | ワークフロー実行ごと | 90日（デフォルト） |
| npmパッケージ | npm Registry | リリースごと | 永続（unpublish制限あり） |

## 監視設計

### CI/CDパイプライン監視

- **GitHub Actions**: ワークフロー実行状況の可視化
  - 成功/失敗ステータスの確認
  - 実行時間のモニタリング
  - アーティファクトのダウンロード

### バンドルサイズ監視

- **Read Size / Report Size ワークフロー**: PRごとにバンドルサイズを計測
  - WebGL、WebGPU、WebGPU Nodesの3種類のビルドを計測
  - minified + gzip後のサイズを報告
  - Tree-shaking後のサイズも計測
  - PRコメントでBefore/After/Diffを表示

### セキュリティ監視

- **CodeQL Analysis**: JavaScriptコードのセキュリティ脆弱性スキャン
  - security-and-qualityクエリセットを使用
  - GitHub Security Alertsと連携

## 開発環境

### ローカル開発サーバー

- カスタムHTTPサーバー（utils/server.js）
  - デフォルトポート: 8080
  - ポート競合時は自動的に別ポートを使用（最大20回試行）
  - ディレクトリリスティング機能
  - 各種メディアタイプのMIME対応
  - Range Requestsサポート（動画ストリーミング対応）

### ビルド出力

| ファイル名 | 形式 | 用途 |
| --- | --- | --- |
| three.module.js | ESM | メインモジュール（WebGL） |
| three.webgpu.js | ESM | WebGPUレンダラー |
| three.webgpu.nodes.js | ESM | WebGPU + ノードシステム |
| three.tsl.js | ESM | TSL（Three Shading Language） |
| three.cjs | CommonJS | Node.js/レガシー環境向け |
| *.min.js | ESM (minified) | 本番環境用圧縮版 |

## 備考

- three.jsはクライアントサイドライブラリであり、本番サーバーインフラは各利用者のプロジェクトに依存
- ライブラリ自体のインフラはGitHub、npm、CDNの外部サービスで構成
- 開発者向けの開発サーバーはNode.js標準ライブラリのみで実装
- バージョン0.182.0時点の設計
