---
generated_at: 2026-01-27 14:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 22
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：22 / 25、根拠なし：3
- 優先レビュー（高）
  1. **監査ログ機能の有無**：コードレビューでログ収集機能が存在しないことを確認したが、外部プラグイン等での拡張可能性は未検証
  2. **TLS設定の推奨事項**：ライブラリはプロトコル非依存だが、推奨設定の記載がアプリケーション側依存となっている
  3. **入力検証の網羅性**：主要なLoaderクラスは確認したが、全てのexamplesローダーは未検証

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/loaders/Loader.js` - Loaderベースクラス（crossOrigin, withCredentials設定）
- E-02: `src/loaders/FileLoader.js` - Fetch APIによるファイル読み込み実装
- E-03: `src/loaders/Cache.js` - キャッシュ機能の実装
- E-04: `src/loaders/ImageLoader.js` - 画像読み込みのcrossOrigin設定
- E-05: `src/loaders/ObjectLoader.js` - JSONパース・メタデータ検証
- E-06: `src/nodes/code/ScriptableNode.js` - Function()コンストラクタによる動的コード実行
- E-07: `SECURITY.md` - 脆弱性報告ポリシー
- E-08: `package.json` - プロジェクト設定・依存関係
- E-09: `.github/workflows/codeql-code-scanning.yml` - CodeQL静的解析設定
- E-10: `.github/workflows/protected-folders.yml` - 保護フォルダー設定
- E-11: `eslint.config.js` - ESLintルール設定
- E-12: `src/utils.js` - コンソール出力関数（warn, error, log）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Three.jsはクライアントサイドライブラリでありサーバー認証機能を持たない | E-01, E-08 | ○ |
| C-02 | withCredentialsによる認証情報送信設定が可能 | E-01, E-02 | ○ |
| C-03 | requestHeaderによるカスタムヘッダー設定が可能 | E-01, E-02 | ○ |
| C-04 | crossOriginのデフォルト値は'anonymous' | E-01 | ○ |
| C-05 | withCredentialsのデフォルト値はfalse | E-01 | ○ |
| C-06 | Fetch APIでAbortSignalによるキャンセルをサポート | E-02 | ○ |
| C-07 | Cacheはデフォルトで無効（enabled: false） | E-03 | ○ |
| C-08 | ImageLoaderはcrossOrigin属性を設定する | E-04 | ○ |
| C-09 | ObjectLoaderはJSON.parseの例外処理を行う | E-05 | ○ |
| C-10 | ObjectLoaderはmetadata.type検証を行う | E-05 | ○ |
| C-11 | ScriptableNodeはFunction()コンストラクタを使用 | E-06 | ○ |
| C-12 | FileLoaderはDOMParserを使用してdocument応答を処理 | E-02 | ○ |
| C-13 | 脆弱性報告先はhello@mrdoob.com | E-07 | ○ |
| C-14 | 脆弱性対応期間は90日 | E-07 | ○ |
| C-15 | CodeQL静的解析が設定されている | E-09 | ○ |
| C-16 | CodeQLはsecurity-and-qualityクエリセットを使用 | E-09 | ○ |
| C-17 | buildとdocsフォルダーはPRで保護されている | E-10 | ○ |
| C-18 | ESLintでno-throw-literalがerror設定 | E-11 | ○ |
| C-19 | Three.jsはランタイム依存関係を持たない | E-08 | ○ |
| C-20 | コンソール出力関数（warn, error, log）が存在する | E-12 | ○ |
| C-21 | FileLoaderはcredentialsオプションを適切に設定 | E-02 | ○ |
| C-22 | プロジェクトバージョンは0.182.0 | E-08 | ○ |
| C-23 | 監査ログ機能は提供されていない | **根拠なし（推定）** | △ |
| C-24 | innerHTML/outerHTML/evalの使用は最小限 | **部分的確認** | △ |
| C-25 | 全入力検証パターンの網羅性 | **部分的確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **監査ログ機能の確認**：全ソースコードを走査してログ収集機能が存在しないことを網羅的に確認する必要がある
  - 候補：src/全体のgrep / examples/jsm/全体のgrep / test/全体のgrep
- **危険な関数の使用調査**：innerHTML/outerHTML/eval/document.writeの使用箇所をsrc以外でも確認する必要がある
  - 候補：examples/jsm/ / editor/ / manual/
- **全Loaderの入力検証確認**：examples/jsm/loaders/配下の各種ローダーの入力検証パターンを確認する必要がある
  - 候補：GLTFLoader / FBXLoader / OBJLoader / 他

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - crossOrigin/withCredentials設定（ドキュメント通りの実装）
- **0: 低リスク** - Cache機能（デフォルト無効、オプトイン）
- **1: 中リスク** - ScriptableNodeのFunction()使用（信頼できるコードのみ実行する想定だが、文書化が必要）
- **1: 中リスク** - DOMParser使用（responseType='document'時のみで限定的だが、信頼できないソース対策の記載が必要）
- **0: 低リスク** - CodeQL静的解析（継続的にセキュリティチェックが実施される）

## 6) レビュアーチェックリスト（最小）
- [ ] ScriptableNodeのFunction()使用が適切に文書化されているか確認
- [ ] examples/jsm/loaders/配下の主要ローダーで入力検証が行われているか抽出確認
- [ ] innerHTML/eval等の危険関数がexamplesやeditorで使用されていないか確認
- [ ] CodeQL設定ファイル（.github/codeql-config.yml）の内容を確認
- [ ] 最新の依存関係に既知の脆弱性がないかnpm auditで確認
