---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **単体テストカバレッジ目標**：明示的な数値目標の根拠なし
  2. **E2Eカバレッジ97%**：README記載だが具体的測定方法の検証が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - プロジェクト設定、依存関係、npmスクリプト定義
- E-02: `.github/workflows/ci.yml` - CI/CDパイプライン設定
- E-03: `.github/workflows/codeql-code-scanning.yml` - CodeQLセキュリティスキャン設定
- E-04: `test/unit/README.md` - 単体テスト実行方法
- E-05: `test/unit/three.source.unit.js` - コアライブラリ単体テストインポート一覧
- E-06: `test/unit/three.addons.unit.js` - アドオン単体テストインポート一覧
- E-07: `test/e2e/README.md` - E2Eテストの概要と使用方法
- E-08: `test/e2e/puppeteer.js` - E2Eテスト実装、設定値、例外リスト
- E-09: `test/unit/utils/qunit-utils.js` - カスタムQUnitアサーション定義
- E-10: `eslint.config.js` - ESLint設定
- E-11: `test/rollup.treeshake.config.js` - Tree-shakeテスト設定
- E-12: `test/e2e/check-coverage.js` - カバレッジ確認スクリプト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | three.jsバージョン0.182.0 | E-01 | ○ |
| C-02 | QUnitバージョン^2.19.4 | E-01 | ○ |
| C-03 | Puppeteerバージョン^24.25.0 | E-01 | ○ |
| C-04 | ESLintバージョン^9.0.0 | E-01 | ○ |
| C-05 | Rollupバージョン^4.6.0 | E-01 | ○ |
| C-06 | Node.js 24使用 | E-02 | ○ |
| C-07 | 5並列ジョブ実行 | E-02, E-08 | ○ |
| C-08 | E2Eテストカバレッジ97% | E-07 | ○ |
| C-09 | ピクセル差分許容値0.3% | E-08 | ○ |
| C-10 | ピクセル閾値0.1 | E-08 | ○ |
| C-11 | レンダリングタイムアウト5秒 | E-08 | ○ |
| C-12 | ネットワークタイムアウト5分 | E-08 | ○ |
| C-13 | 再試行回数2回 | E-08 | ○ |
| C-14 | スクリーンショット解像度400x250 | E-08 | ○ |
| C-15 | JPG品質95% | E-08 | ○ |
| C-16 | ネットワークアイドル2秒 | E-08 | ○ |
| C-17 | 例外リスト約40件 | E-08 | ○ |
| C-18 | CodeQL週次実行 | E-03 | ○ |
| C-19 | カスタムアサーション（numEqual、smartEqual等） | E-09 | ○ |
| C-20 | 単体テスト対象モジュール一覧 | E-05 | ○ |
| C-21 | アドオンテスト対象（BufferGeometryUtils等） | E-06 | ○ |
| C-22 | testコマンド構成（lint + unit + unit-addons） | E-01 | ○ |
| C-23 | Tree-shakeテスト設定 | E-11 | ○ |
| C-24 | カバレッジ確認スクリプト存在 | E-12 | ○ |
| C-25 | ブラウザテストURL | E-04 | ○ |
| C-26 | デバッグ方法（debugger使用） | E-04 | ○ |
| C-27 | 単体テストカバレッジ数値目標 | **根拠なし** | △ |
| C-28 | E2Eカバレッジ測定方法の詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- **単体テストのカバレッジ数値目標**：package.jsonやCI設定にカバレッジ測定ツール（Istanbul/nyc等）の設定が見当たらない。明示的なカバレッジ目標は推測に基づく。
  - 候補：カバレッジ測定ツールの導入 / カバレッジ目標の明文化 / 既存のカバレッジレポート確認
- **E2Eカバレッジ97%の測定方法**：README.mdに記載があるが、算出方法（362件中何件がテスト対象か）の詳細検証が必要。
  - 候補：examples/ディレクトリのファイル数カウント / exceptionListの件数確認 / 自動計算スクリプトの確認

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：テストフレームワーク、ツールバージョン、CI/CD設定 - 全て根拠あり
- 1（中リスク）：E2Eカバレッジ97%の数値 - READMEに記載があるが最新状態の検証推奨
- 1（中リスク）：単体テストカバレッジ目標 - 明示的な測定ツール設定がないため推定値

## 6) レビュアーチェックリスト（最小）
- [ ] QUnit、Puppeteer、ESLintのバージョンがpackage.jsonと一致しているか確認
- [ ] CI/CDワークフローのジョブ構成が実際の.github/workflows/ci.ymlと一致しているか確認
- [ ] E2Eテストの設定値（タイムアウト、ピクセル閾値等）がpuppeteer.jsと一致しているか確認
- [ ] 例外リストの件数が最新の状態と一致しているか確認
- [ ] 単体テストカバレッジ目標について、プロジェクトの方針を確認し必要に応じて修正
- [ ] E2Eカバレッジ97%の数値が最新の状態を反映しているか確認
