# テスト方針書

## 概要

本ドキュメントは、three.js（バージョン0.182.0）プロジェクトにおけるテスト方針を定義する。three.jsはJavaScript 3Dグラフィックスライブラリであり、WebGL/WebGPUを使用したクロスブラウザ3Dレンダリングを提供する。本テスト方針では、単体テスト、E2E（End-to-End）テスト、静的解析を含む包括的なテスト戦略を規定する。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のモジュール・クラス（Math、Core、Materials、Geometries等）の動作検証 | 開発者 |
| 結合テスト | アドオンモジュール（BufferGeometryUtils、NURBSCurve、USDZExporter等）とコア機能の連携検証 | 開発者 |
| E2Eテスト | サンプル（examples）のスクリーンショット比較による視覚的回帰テスト | CI/CD自動実行 |
| Tree-shakeテスト | バンドルサイズ最適化とデッドコード除去の検証 | CI/CD自動実行 |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | QUnitによるAPIの機能検証、JSON往復検証、クローン検証 | コミット時、PR作成時 |
| 視覚回帰テスト | Puppeteerによるスクリーンショット比較（ピクセル差分0.3%以内） | PR作成時 |
| 静的解析（Lint） | ESLintによるコード品質・スタイルチェック | コミット時、PR作成時 |
| セキュリティテスト | CodeQLによる脆弱性スキャン | PR作成時、週次スケジュール実行 |
| カバレッジ確認テスト | サンプルとスクリーンショットの網羅性確認 | PR作成時 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 単体テスト実行（Node.js）、ブラウザテスト | Node.js 24、npm |
| ブラウザ環境 | 単体テストのブラウザ実行、手動デバッグ | `http://localhost:8080/test/unit/UnitTests.html` |
| CI/CD環境（GitHub Actions） | 自動テスト実行、E2Eテスト並列化 | ubuntu-latest、Node.js 24、5並列ジョブ |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| QUnit | 単体テストフレームワーク | ^2.19.4 |
| Puppeteer | E2Eテスト（スクリーンショット撮影・比較） | ^24.25.0 |
| ESLint | 静的解析（コード品質チェック） | ^9.0.0 |
| CodeQL | セキュリティ脆弱性スキャン | v4（GitHub Actions） |
| Rollup | Tree-shakeテスト、バンドルサイズ検証 | ^4.6.0 |
| SwiftShader | E2Eテスト用ソフトウェアレンダリング | Puppeteer内蔵 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| E2Eテストカバレッジ（サンプル） | 97%（362件中約350件） |
| 単体テストカバレッジ | 主要モジュール（animation、cameras、core、extras、geometries、helpers、lights、loaders、materials、math、objects、renderers、scenes、textures）の全クラス |
| アドオンテストカバレッジ | BufferGeometryUtils、ColorSpaces、NURBSCurve、USDZExporter |
| ピクセル差分許容値 | 0.3%（E2Eスクリーンショット比較） |

## テストデータ

### 単体テスト用データ

- **数学定数**: `test/unit/utils/math-constants.js`で定義された精度定数
- **カスタムアサーション**: `test/unit/utils/qunit-utils.js`で定義（numEqual、smartEqual、equalKey等）
- **比較ユーティリティ**: `test/unit/utils/SmartComparer.js`によるオブジェクト深層比較

### E2Eテスト用データ

- **参照スクリーンショット**: `examples/screenshots/`ディレクトリに格納（JPG、400x250px）
- **決定論的インジェクション**: `test/e2e/deterministic-injection.js`によるMath.random、タイマー、rAFのモック化
- **例外リスト**: 長時間実行、WebGPU専用、Webcam必須等の理由で除外されるサンプル約40件

## 不具合管理

- **Issue管理**: GitHub Issues（https://github.com/mrdoob/three.js/issues）
- **E2Eテスト失敗時の対応**:
  1. `npm run make-screenshot <example_name>`で新しいスクリーンショットを生成
  2. 視覚的変更が意図的でない場合はコードを修正
  3. 解決できない場合は例外リスト（`exceptionList`）への追加を検討
- **再試行ポリシー**: E2Eテストは最大2回の試行（`numAttempts = 2`）

## CI/CD連携

### GitHub Actions ワークフロー

#### CIワークフロー（`.github/workflows/ci.yml`）

**トリガー**: Pull Request（build/docs/files除外）

**ジョブ構成**:

1. **test ジョブ**
   - Lintテスト: `npm run lint`
   - 単体テスト: `npm run test-unit`
   - アドオン単体テスト: `npm run test-unit-addons`
   - カバレッジ確認: `npm run test-e2e-cov`

2. **e2e ジョブ**（5並列）
   - ビルド: `npm run build-module`
   - E2Eテスト: `npm run test-e2e`
   - 失敗時のスクリーンショット保存（Artifact）

#### CodeQLワークフロー（`.github/workflows/codeql-code-scanning.yml`）

**トリガー**: devブランチへのpush/PR、週次スケジュール

**実行内容**: JavaScriptコードのセキュリティ・品質スキャン

### ローカル実行コマンド

```bash
# 全テスト実行（lint + unit + unit-addons）
npm test

# 単体テスト
npm run test-unit
npm run test-unit-addons

# E2Eテスト
npm run test-e2e

# 特定サンプルのE2Eテスト
npm run test-e2e <example_name>

# スクリーンショット生成
npm run make-screenshot <example_name>

# Tree-shakeテスト
npm run test-treeshake

# Lintチェック
npm run lint
```

## 備考

### E2Eテストの技術的詳細

- **ネットワークアイドル検出**: `networkidle0`で2秒間リクエストがない状態を検出
- **レンダリングタイムアウト**: 5秒（`renderTimeout = 5`）
- **ネットワークタイムアウト**: 5分（`networkTimeout = 5`）
- **スクリーンショット品質**: JPG 95%品質、800x500px（2倍スケール後400x250px）
- **ピクセル比較閾値**: 1ピクセルあたり0.1の誤差許容（`pixelThreshold = 0.1`）

### テストの制限事項

- 一部のテストはブラウザ環境でのみ実行可能
- WebGPU専用サンプルはE2Eテスト対象外（SwiftShaderがWebGL専用のため）
- Webcam、Video等の外部デバイス依存サンプルはE2Eテスト対象外
- 長時間実行サンプル（1分以上）はE2Eテスト対象外

### テストの拡張方針

- 新しいモジュール追加時は対応する`.tests.js`ファイルを作成
- 新しいサンプル追加時はスクリーンショットを生成し`files.json`に登録
- QUnit.todoからQUnit.testへの変更忘れに注意
