# ER図

## 概要

本ドキュメントは、three.jsプロジェクトのER図（Entity-Relationship Diagram）について記載するものです。

## ER図

three.jsはクライアントサイドの3Dレンダリングライブラリであり、データベースを使用していないため、データベースのER図は存在しません。

```mermaid
erDiagram
    NOTE {
        string message "three.jsはデータベースを使用していません"
        string type "フロントエンドライブラリ"
        string purpose "3Dグラフィックスレンダリング"
    }
```

## 参考: three.jsのオブジェクト構造

three.jsはデータベースを使用しませんが、参考としてメモリ上で管理される主要なオブジェクトの関係を示します。

```mermaid
erDiagram
    Scene ||--o{ Object3D : contains
    Object3D ||--o{ Object3D : children
    Object3D ||--o| Geometry : has
    Object3D ||--o| Material : has
    Material ||--o{ Texture : uses

    Scene {
        string uuid PK
        string name
        Object3D children
    }

    Object3D {
        string uuid PK
        string name
        Vector3 position
        Euler rotation
        Vector3 scale
    }

    Geometry {
        string uuid PK
        BufferAttribute attributes
        BufferAttribute index
    }

    Material {
        string uuid PK
        string name
        string type
        number opacity
        boolean transparent
    }

    Texture {
        string uuid PK
        string name
        Image image
        number mapping
    }
```

## 備考

上記の「オブジェクト構造」はデータベースのER図ではなく、three.jsのJavaScriptオブジェクト間の関係を示したものです。これらのオブジェクトはブラウザのメモリ上で管理され、データベースには永続化されません。

### 主要なオブジェクトの説明

| オブジェクト | 説明 |
| --- | --- |
| Scene | 3Dシーン全体を表すルートコンテナ |
| Object3D | 全ての3Dオブジェクトの基底クラス |
| Geometry | 頂点、法線、UVなどのジオメトリデータ |
| Material | オブジェクトの色、透明度などの外観定義 |
| Texture | マテリアルに適用されるテクスチャ画像 |
