---
generated_at: 2026-01-27 10:30:00
metrics:
  claims_total: 21
  claims_with_evidence: 21
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：バッチ一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：21 / 21、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在するため、優先レビュー項目はありません

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - npmスクリプト定義
- E-02: `utils/build/rollup.config.js` - Rollupビルド設定
- E-03: `utils/build/dev.js` - 開発用ビルドスクリプト
- E-04: `utils/build/preview.js` - プレビュー用スクリプト
- E-05: `utils/docs/jsdoc.config.json` - JSDoc設定
- E-06: `test/e2e/puppeteer.js` - E2Eテストスクリプト
- E-07: `test/e2e/check-coverage.js` - カバレッジチェックスクリプト
- E-08: `test/rollup.treeshake.config.js` - tree-shakingテスト設定
- E-09: `.github/workflows/ci.yml` - CI/CDワークフロー
- E-10: `.github/workflows/read-size.yml` - バンドルサイズ計測ワークフロー
- E-11: `.github/workflows/report-size.yml` - バンドルサイズレポートワークフロー
- E-12: `.github/workflows/codeql-code-scanning.yml` - CodeQL解析ワークフロー
- E-13: `.github/workflows/protected-folders.yml` - 保護フォルダチェックワークフロー

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npm run build - Rollupを使用してthree.jsライブラリ全体をビルド | E-01, E-02 | ○ |
| C-02 | npm run build-module - モジュール版のみをビルド | E-01, E-02 | ○ |
| C-03 | npm run build-docs - JSDocを使用してAPIドキュメント生成 | E-01, E-05 | ○ |
| C-04 | npm run dev - 開発用ビルドの作成と開発サーバー起動 | E-01, E-03 | ○ |
| C-05 | npm run preview - Rollupウォッチモードとサーバーを並列起動 | E-01, E-04 | ○ |
| C-06 | npm run lint - コアソースコードのESLint静的解析 | E-01 | ○ |
| C-07 | npm run lint-fix - 全ソースコードのESLintエラーを自動修正 | E-01 | ○ |
| C-08 | npm run test - リントと単体テストを一括実行 | E-01 | ○ |
| C-09 | npm run test-unit - QUnitを使用してコア単体テスト実行 | E-01 | ○ |
| C-10 | npm run test-unit-addons - QUnitを使用してアドオン単体テスト実行 | E-01 | ○ |
| C-11 | npm run test-e2e - Puppeteerを使用してE2Eテスト実行 | E-01, E-06 | ○ |
| C-12 | npm run test-e2e-cov - カバレッジチェック実行 | E-01, E-07 | ○ |
| C-13 | npm run test-e2e-webgpu - WebGPU関連のE2Eテスト実行 | E-01, E-06 | ○ |
| C-14 | npm run test-treeshake - tree-shakingテスト実行 | E-01, E-08 | ○ |
| C-15 | npm run make-screenshot - 参照スクリーンショット生成 | E-01, E-06 | ○ |
| C-16 | ci.yml test job - Lint・単体テスト・カバレッジチェック実行 | E-09 | ○ |
| C-17 | ci.yml e2e job - E2Eテストを5並列で実行 | E-09 | ○ |
| C-18 | read-size.yml - バンドルサイズ計測 | E-10 | ○ |
| C-19 | report-size.yml - バンドルサイズ比較結果をPRにコメント | E-11 | ○ |
| C-20 | codeql-code-scanning.yml - CodeQLによるセキュリティ解析 | E-12 | ○ |
| C-21 | protected-folders.yml - build/とdocs/フォルダへの変更制限 | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし
  - 全ての主張について、ソースコードまたは設定ファイルから根拠を確認済み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードと設定ファイルから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] package.jsonのscriptsセクションと一覧の整合性を確認
- [ ] GitHub Actionsワークフローファイルの内容と説明の一致を確認
- [ ] 将来追加されたスクリプトやワークフローがある場合は一覧への追加を検討
