# バッチ設計書 1-npm run build

## 概要

本ドキュメントは、three.jsライブラリのプロダクションビルドを生成する `npm run build` コマンドの設計仕様を定義します。

### 本バッチの処理概要

このバッチは、three.jsライブラリ全体を配布可能な形式にコンパイル・バンドルする処理を行います。Rollupバンドラーを使用して、ESM（ECMAScript Modules）形式、CommonJS形式、およびminified版の複数の出力形式を生成します。

**業務上の目的・背景**：three.jsは世界中の開発者が利用する3Dグラフィックスライブラリであり、npm経由での配布やCDN経由での利用に対応するため、複数の形式でビルド成果物を提供する必要があります。開発中のソースコードから、本番環境で利用可能な最適化されたバンドルを生成することで、エンドユーザーに高品質なライブラリを提供します。

**バッチの実行タイミング**：リリース前の最終ビルド時、CI/CDパイプラインでのテスト前、または開発者が手動でビルド成果物を確認したい場合に随時実行されます。

**主要な処理内容**：
1. GLSLシェーダーコードの最適化（コメント除去、空白圧縮）
2. ライセンスヘッダーの付与
3. ESM形式でのコアモジュール・WebGPUモジュール・TSLモジュールのビルド
4. 各モジュールのminified版の生成（terserによる圧縮）
5. CommonJS形式でのビルド出力

**前後の処理との関連**：開発時は `npm run dev` で簡易ビルドを使用し、本番リリース時に本バッチを実行します。ビルド後は `npm run test` でテストを実行し、品質を確認します。

**影響範囲**：build/ディレクトリ配下のすべての成果物が再生成されます。npm publish時にはこれらの成果物がパッケージに含まれます。

## バッチ種別

ビルド処理 / コード変換

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / CI/CD |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v18以上がインストールされていること |
| 依存パッケージ | `npm install` により依存パッケージがインストール済みであること |
| ソースコード | src/配下にソースコードが存在すること |

### 実行可否判定

package.jsonが存在し、node_modulesディレクトリが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --configOnlyModule | フラグ | No | false | 指定時はモジュール版のみビルド（最初の3設定） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/Three.Core.js | JavaScript | コアモジュールのエントリポイント |
| src/Three.js | JavaScript | メインモジュールのエントリポイント |
| src/Three.WebGPU.js | JavaScript | WebGPUモジュールのエントリポイント |
| src/Three.WebGPU.Nodes.js | JavaScript | WebGPU Nodesモジュールのエントリポイント |
| src/Three.TSL.js | JavaScript | TSLモジュールのエントリポイント |
| utils/build/rollup.config.js | JavaScript | Rollup設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| build/three.core.js | ESM | コアモジュール（非圧縮） |
| build/three.module.js | ESM | メインモジュール（非圧縮） |
| build/three.webgpu.js | ESM | WebGPUモジュール（非圧縮） |
| build/three.webgpu.nodes.js | ESM | WebGPU Nodesモジュール（非圧縮） |
| build/three.tsl.js | ESM | TSLモジュール（非圧縮） |
| build/three.core.min.js | ESM | コアモジュール（圧縮版） |
| build/three.module.min.js | ESM | メインモジュール（圧縮版） |
| build/three.webgpu.min.js | ESM | WebGPUモジュール（圧縮版） |
| build/three.webgpu.nodes.min.js | ESM | WebGPU Nodesモジュール（圧縮版） |
| build/three.tsl.min.js | ESM | TSLモジュール（圧縮版） |
| build/three.cjs | CommonJS | CommonJS形式出力 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 上記参照 |
| 出力先 | build/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. Rollup設定ファイルの読み込み
   └─ utils/build/rollup.config.jsを解析
2. GLSLプラグインによるシェーダー処理
   └─ .glsl.jsファイルのコメント除去・圧縮
3. ヘッダープラグインによるライセンス付与
   └─ 各出力ファイルにMITライセンスヘッダーを追加
4. ESM版コアモジュールのビルド（ビルド設定1）
   └─ three.core.js, three.webgpu.nodes.jsを出力
5. ESM版メインモジュールのビルド（ビルド設定2）
   └─ three.core.js, three.module.js, three.webgpu.jsを出力
6. ESM版TSLモジュールのビルド（ビルド設定3）
   └─ three.tsl.jsを出力（three/webgpuを外部依存として扱う）
7. minified版コアモジュールのビルド（ビルド設定4）
   └─ terserによる圧縮処理
8. minified版メインモジュールのビルド（ビルド設定5）
   └─ terserによる圧縮処理
9. minified版TSLモジュールのビルド（ビルド設定6）
   └─ terserによる圧縮処理
10. CommonJS版のビルド（ビルド設定7）
    └─ three.cjsを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Rollup設定読み込み]
    B --> C[GLSLシェーダー処理]
    C --> D[ESM版ビルド]
    D --> E[minified版ビルド]
    E --> F[CommonJS版ビルド]
    F --> G[ライセンスヘッダー付与]
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイルベースの処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENOENT | ファイル不在 | ソースファイルが見つからない | ソースコードの存在確認 |
| PARSE_ERROR | 構文エラー | JavaScriptの構文エラー | ソースコードの修正 |
| PLUGIN_ERROR | プラグインエラー | Rollupプラグインでのエラー | 設定ファイルの確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ビルドエラー発生時は、コンソール出力のエラーメッセージを確認し、該当するソースファイルまたは設定ファイルを修正してから再実行します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル出力） |
| コミットタイミング | 各ファイル出力完了時 |
| ロールバック条件 | エラー発生時は出力途中で停止 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 7ビルド設定 × 複数ファイル |
| 目標処理時間 | 60秒以内 |
| メモリ使用量上限 | 2048MB |

## 排他制御

同時実行は許可されていますが、同一出力先への並列書き込みは競合する可能性があります。CIでは単一ジョブでの実行を推奨します。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ビルド開始時 | Rollup起動メッセージ |
| 進捗ログ | 各ビルド設定処理時 | 出力ファイル名、サイズ |
| 終了ログ | ビルド完了時 | 完了メッセージ |
| エラーログ | エラー発生時 | エラー詳細、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 300秒 | CI/CD通知 |
| エラー件数 | 1件以上 | CI/CD通知 |

## 備考

- Rollup v4.6.0以上を使用
- @rollup/plugin-terser v0.4.0以上で圧縮処理を実行
- GLSLシェーダーはMagicStringライブラリで文字列操作
- ライセンスヘッダーは「Copyright 2010-2026 Three.js Authors」「SPDX-License-Identifier: MIT」を含む
