# バッチ設計書 10-npm run test-unit-addons

## 概要

本ドキュメントは、three.jsアドオン（examples/jsm）の単体テストを実行する `npm run test-unit-addons` コマンドの設計仕様を定義します。

### 本バッチの処理概要

このバッチは、QUnitテストフレームワークを使用してthree.jsのアドオンモジュール（examples/jsm配下）の単体テストを実行します。BufferGeometryUtils、ColorSpaces、NURBSCurve、USDZExporterなどのアドオンユーティリティに対応するテストを実行し、機能の正常動作を検証します。

**業務上の目的・背景**：three.jsのアドオンは、コアライブラリを拡張する重要な機能群です。エクスポーター、ローダー、ユーティリティ、特殊なカーブ/サーフェス処理など、多岐にわたるアドオンの品質を保証するために、単体テストが必要です。

**バッチの実行タイミング**：CI/CDパイプラインでの自動実行（PR作成時・push時）、ローカル開発時のコード検証、アドオン追加・修正後の動作確認として随時実行されます。

**主要な処理内容**：
1. QUnitテストランナーの初期化
2. テストエントリポイント（three.addons.unit.js）の読み込み
3. 各アドオンのテストファイルのインポート
4. テストスイートの実行
5. アサーション結果の集計と報告

**前後の処理との関連**：`npm run test` の一部として `npm run test-unit` の後に実行されます。単独で実行することも可能です。`npm run test-unit` と合わせてライブラリ全体のテストを構成します。

**影響範囲**：ファイルの変更は行いません（読み取り専用）。テスト結果に基づいて終了コードが設定されます。

## バッチ種別

単体テスト / 品質保証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 / CI自動 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / PR作成時 / push時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v18以上がインストールされていること |
| 依存パッケージ | `npm install` により依存パッケージがインストール済みであること |
| アドオンコード | examples/jsm/配下にアドオンコードが存在すること |
| テストコード | test/unit/addons/配下にテストコードが存在すること |

### 実行可否判定

package.jsonが存在し、node_modulesディレクトリが存在し、test/unit/three.addons.unit.jsが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 追加パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| test/unit/three.addons.unit.js | JavaScript | テストエントリポイント |
| test/unit/addons/utils/BufferGeometryUtils.tests.js | JavaScript | BufferGeometryUtilsテスト |
| test/unit/addons/math/ColorSpaces.tests.js | JavaScript | ColorSpacesテスト |
| test/unit/addons/curves/NURBSCurve.tests.js | JavaScript | NURBSCurveテスト |
| test/unit/addons/exporters/USDZExporter.tests.js | JavaScript | USDZExporterテスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | テスト結果、成功/失敗の詳細 |
| 終了コード | 数値 | 0: 全成功, 1: 失敗あり |

### 出力ファイル仕様

ファイル出力なし（コンソール出力のみ）

## 処理フロー

### 処理シーケンス

```
1. QUnitテストランナーの起動
   └─ qunit test/unit/three.addons.unit.js を実行
2. テストモジュールのロード
   └─ 各アドオンに対応するテストをインポート
3. テストスイートの実行
   └─ 各テストケースを順次実行
4. アサーション評価
   └─ 期待値と実際値を比較
5. 結果の集計
   └─ 成功/失敗数をカウント
6. 結果の出力
   └─ サマリーを表示し、終了コードを設定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[QUnit起動]
    B --> C[テストモジュールロード]
    C --> D[テスト実行]
    D --> E{全テスト成功?}
    E -->|成功| F[終了コード0で終了]
    E -->|失敗| G[失敗詳細を出力]
    G --> H[終了コード1で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（読み取り専用）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | テスト失敗 | アサーションが失敗 | テストまたはアドオンコードの修正 |
| 1 | テストエラー | テスト実行時の例外 | テストコードの修正 |
| ENOENT | ファイル不在 | テストファイルが見つからない | パスの確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

テスト失敗時は、出力された失敗詳細を確認し、該当するアドオンコードまたはテストコードを修正して再実行します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 4テストファイル、数十アサーション |
| 目標処理時間 | 30秒以内 |
| メモリ使用量上限 | 256MB |

## 排他制御

同時実行可能。読み取り専用のため競合なし。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| モジュールログ | 各モジュールテスト開始時 | モジュール名 |
| テストログ | 各テストケース実行時 | テストケース名、結果 |
| 失敗ログ | アサーション失敗時 | 期待値、実際値、スタックトレース |
| サマリーログ | 全テスト完了時 | 総テスト数、成功数、失敗数、経過時間 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 失敗テスト数 | 1件以上 | CI/CD通知 |
| 処理時間 | 60秒 | CI/CD通知 |

## 備考

- QUnit v2.19.4以上を使用
- 現在のテスト対象アドオン：
  - **utils/BufferGeometryUtils**: ジオメトリ操作ユーティリティのテスト
  - **math/ColorSpaces**: カラースペース変換のテスト
  - **curves/NURBSCurve**: NURBS曲線のテスト
  - **exporters/USDZExporter**: USDZ形式エクスポーターのテスト
- コアテスト（test-unit）と比較してテスト数は少ない
- アドオンの追加に応じてテストファイルを追加可能
- ヘッドレス環境で実行（ブラウザ不要）
- ES Modulesをサポート
- examples/jsm/配下の全アドオンがテストされているわけではない（テストカバレッジは部分的）
