# バッチ設計書 18-read-size.yml

## 概要

本ドキュメントは、three.jsプロジェクトにおけるGitHub Actionsワークフロー「Read size」の設計仕様を定義する。

### 本バッチの処理概要

PRのソースコード変更に対してthree.jsライブラリをビルドし、バンドルサイズを計測してArtifactとしてアップロードするワークフローである。tree-shakingテストも同時に実行し、フルバンドルとtree-shaking後のサイズを両方計測する。

**業務上の目的・背景**：three.jsはブラウザで動作するライブラリであり、バンドルサイズはパフォーマンスに直接影響する。PRごとにバンドルサイズの変化を追跡することで、意図しないサイズ増加を早期に検出し、ライブラリの軽量性を維持する。このワークフローはread-onlyな環境で実行され、セキュリティを確保しつつPRコードをチェックアウトして計測を行う。

**バッチの実行タイミング**：PRイベントでトリガー（src/、package.json、utils/build/の変更時のみ）。

**主要な処理内容**：
1. リポジトリのチェックアウト（PRコード）
2. Node.js 24環境のセットアップ
3. npm依存関係のインストール
4. フルビルドの実行（npm run build）
5. tree-shakingテストの実行（npm run test-treeshake）
6. バンドルサイズの計測（WebGL、WebGPU、WebGPU Nodes各版）
7. gzip圧縮後サイズの計測
8. 計測結果をJSONファイルとしてArtifactにアップロード

**前後の処理との関連**：このワークフローの完了後、report-size.ymlが自動トリガーされ、PRにコメントとして結果を投稿する。

**影響範囲**：GitHub Actions Artifact（sizes.json）。

## バッチ種別

CI/CD / バンドルサイズ計測 / GitHub Actions ワークフロー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | PRごと（条件付き） |
| 実行時刻 | PR作成・更新時 |
| 実行曜日 | 不定 |
| 実行日 | 不定 |
| トリガー | pull_request イベント（paths条件付き） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHub Actions | GitHub Actionsが有効であること |
| ubuntu-latest | ubuntu-latestランナーが使用可能であること |
| Node.js 24 | Node.js 24がインストール可能であること |

### 実行可否判定

- paths: src/**, package.json, utils/build/** のいずれかが変更されていること
- PRが作成または更新されていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 自動トリガーのためパラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| リポジトリ全体（PRコード） | Git | actions/checkout@v6によるチェックアウト |
| package.json | JSONファイル | npm scripts定義 |
| package-lock.json | JSONファイル | npm ci用の依存関係ロックファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Actions Artifact | JSONファイル | sizes.jsonとしてアップロード |
| GitHub Actions ログ | テキスト | 各ステップの実行結果 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | sizes.json |
| 出力先 | GitHub Actions Artifact |
| 形式 | JSON |
| 内容 | バンドルサイズ（WebGL/WebGPU/WebGPU Nodes、各種サイズ）、PR番号 |

sizes.jsonの構造:
```json
{
  "filesize": <WebGL full size>,
  "gzip": <WebGL gzip size>,
  "treeshaken": <WebGL treeshaken size>,
  "treeshakenGzip": <WebGL treeshaken gzip size>,
  "filesize2": <WebGPU full size>,
  "gzip2": <WebGPU gzip size>,
  "treeshaken2": <WebGPU treeshaken size>,
  "treeshakenGzip2": <WebGPU treeshaken gzip size>,
  "filesize3": <WebGPU Nodes full size>,
  "gzip3": <WebGPU Nodes gzip size>,
  "treeshaken3": <WebGPU Nodes treeshaken size>,
  "treeshakenGzip3": <WebGPU Nodes treeshaken gzip size>,
  "pr": <PR番号>
}
```

## 処理フロー

### 処理シーケンス

```
1. Git checkout
   └─ actions/checkout@v6でPRコードをチェックアウト

2. Install Node
   └─ actions/setup-node@v6でNode.js 24をセットアップ
   └─ npmキャッシュを有効化

3. Install dependencies
   └─ npm ciで依存関係をインストール

4. Build
   └─ npm run buildでフルビルドを実行

5. Test tree-shaking
   └─ npm run test-treeshakeでtree-shakingテストを実行

6. Read bundle sizes
   └─ statコマンドでファイルサイズを取得
   └─ gzipコマンドで圧縮後サイズを取得
   └─ WebGL、WebGPU、WebGPU Nodes各版を計測

7. Upload artifact
   └─ sizes.jsonをArtifactとしてアップロード
```

### フローチャート

```mermaid
flowchart TD
    A[PR作成/更新] --> B{paths条件<br>該当?}
    B -->|No| C[ワークフロースキップ]
    B -->|Yes| D[read-sizeジョブ開始]
    D --> E[Git checkout<br>PRコード]
    E --> F[Node.js 24セットアップ]
    F --> G[npm ci]
    G --> H[npm run build]
    H --> I[npm run test-treeshake]
    I --> J[WebGLサイズ計測]
    J --> K[WebGPUサイズ計測]
    K --> L[WebGPU Nodesサイズ計測]
    L --> M[gzip圧縮後サイズ計測]
    M --> N[sizes.json生成]
    N --> O[Artifactアップロード]
    O --> P[ワークフロー完了]
    P --> Q[report-size.ymlトリガー]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ビルドエラー | npm run buildが失敗 | コードを修正 |
| - | tree-shakeエラー | npm run test-treeshakeが失敗 | コードを修正 |
| - | ファイル不在 | ビルド成果物がない | ビルドエラーを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. GitHub ActionsのUIでエラーログを確認
2. ビルドエラーの場合はコードを修正
3. 修正をコミットしてPRを更新

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ワークフロー |
| 目標処理時間 | 5分以内（通常） |
| メモリ使用量上限 | ubuntu-latestランナーの制限内 |

## 排他制御

- 同一PRに対して最新のコミットのみ実行

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ステップ開始 | 各ステップ開始時 | ステップ名 |
| サイズ計測結果 | 計測完了時 | 各ファイルのサイズ（バイト） |
| Artifact | アップロード時 | アップロードされたファイル情報 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー結果 | 失敗時 | GitHub Actions通知 |

## 備考

- ワークフロー名: "Read size"
- ジョブ名: "Tree-shaking"
- permissions: contents: read（読み取り専用環境、セキュリティ対策）
- このワークフローはread-only環境で実行され、PRコードを安全にチェックアウト可能
- 参考: https://securitylab.github.com/research/github-actions-preventing-pwn-requests/
- report-size.ymlがworkflow_runイベントでこのワークフローの完了をトリガーとして起動
- 計測対象ファイル:
  - build/three.module.min.js（WebGL）
  - build/three.webgpu.min.js（WebGPU）
  - build/three.webgpu.nodes.min.js（WebGPU Nodes）
  - test/treeshake/index.bundle.min.js（WebGL tree-shaken）
  - test/treeshake/index.webgpu.bundle.min.js（WebGPU tree-shaken）
  - test/treeshake/index.webgpu.nodes.bundle.min.js（WebGPU Nodes tree-shaken）
