# バッチ設計書 19-report-size.yml

## 概要

本ドキュメントは、three.jsプロジェクトにおけるGitHub Actionsワークフロー「Report size」の設計仕様を定義する。

### 本バッチの処理概要

read-sizeワークフロー完了後に自動トリガーされ、PRのバンドルサイズ変化をベースブランチ（dev）と比較し、結果をPRコメントとして投稿するワークフローである。PRブランチとベースブランチの両方のバンドルサイズを取得し、差分をフォーマットして分かりやすく表示する。

**業務上の目的・背景**：開発者がPRのバンドルサイズへの影響を即座に把握できるようにするため。バンドルサイズの増減をBefore/After/Diffの形式で可視化することで、コードレビュー時にパフォーマンスへの影響を考慮した判断が可能になる。このワークフローはpull-requests: write権限を持つが、PRコードをチェックアウトせずベースブランチのみをチェックアウトすることでセキュリティを確保している。

**バッチの実行タイミング**：read-sizeワークフローが成功完了した後に自動トリガー（workflow_runイベント）。

**主要な処理内容**：
1. read-sizeワークフローのArtifact（sizes.json）をダウンロード
2. ベースブランチ（dev）をチェックアウト
3. ベースブランチでフルビルドとtree-shakingテストを実行
4. ベースブランチのバンドルサイズを計測
5. PRブランチとベースブランチのサイズを比較
6. 差分をフォーマット（KB単位、増減表示）
7. PRに結果をコメントとして投稿（既存コメントがあれば更新）

**前後の処理との関連**：read-size.ymlの成功完了がトリガー。

**影響範囲**：PR上のコメント。

## バッチ種別

CI/CD / バンドルサイズレポート / GitHub Actions ワークフロー

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | read-size完了ごと |
| 実行時刻 | read-size完了時 |
| 実行曜日 | 不定 |
| 実行日 | 不定 |
| トリガー | workflow_run イベント（Read size完了時） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHub Actions | GitHub Actionsが有効であること |
| ubuntu-latest | ubuntu-latestランナーが使用可能であること |
| Node.js 24 | Node.js 24がインストール可能であること |
| read-size成功 | read-sizeワークフローが成功完了していること |

### 実行可否判定

- workflow_run.event == 'pull_request'
- workflow_run.conclusion == 'success'
- Artifact（sizes.json）が存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 自動トリガーのためパラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| sizes.json（Artifact） | JSONファイル | read-sizeからのPRバンドルサイズ |
| ベースブランチ（dev） | Git | actions/checkout@v6によるチェックアウト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| PRコメント | Markdown | バンドルサイズ比較結果 |
| GitHub Actions ログ | テキスト | 各ステップの実行結果 |

### 出力ファイル仕様

PRコメントのフォーマット:
```markdown
### 📦 Bundle size

_Full ESM build, minified and gzipped._

|| Before | After | Diff |
|:-:|:-:|:-:|:-:|
| WebGL | {base} <br> **{base_gzip}** | {pr} <br> **{pr_gzip}** | {diff} <br> **{diff_gzip}** |
| WebGPU | ... | ... | ... |
| WebGPU Nodes | ... | ... | ... |

### 🌳 Bundle size after tree-shaking

_Minimal build including a renderer, camera, empty scene, and dependencies._

|| Before | After | Diff |
|:-:|:-:|:-:|:-:|
| WebGL | ... | ... | ... |
| WebGPU | ... | ... | ... |
| WebGPU Nodes | ... | ... | ... |
```

## 処理フロー

### 処理シーケンス

```
1. Log GitHub context
   └─ デバッグ用にGitHubコンテキストをログ出力

2. Download artifact
   └─ actions/github-scriptでread-sizeのArtifactをダウンロード
   └─ sizes.zipを解凍してsizes.jsonを取得

3. Git checkout（ベースブランチ）
   └─ devブランチをチェックアウト（PRコードではない）

4. Install Node
   └─ actions/setup-node@v6でNode.js 24をセットアップ

5. Install dependencies
   └─ npm ciで依存関係をインストール

6. Build
   └─ npm run buildでフルビルドを実行

7. Test tree-shaking
   └─ npm run test-treeshakeでtree-shakingテストを実行

8. Read sizes（ベースブランチ）
   └─ statコマンドでファイルサイズを取得
   └─ gzip圧縮後サイズを取得

9. Format sizes
   └─ format-size.js、format-diff.jsでサイズを整形
   └─ KB単位に変換、差分を+/-で表示

10. Find existing comment
    └─ peter-evans/find-comment@v4で既存コメントを検索

11. Comment on PR
    └─ peter-evans/create-or-update-comment@v5でコメント投稿/更新
```

### フローチャート

```mermaid
flowchart TD
    A[read-size完了] --> B{success?}
    B -->|No| C[ワークフロースキップ]
    B -->|Yes| D[report-sizeジョブ開始]
    D --> E[Artifactダウンロード<br>sizes.json]
    E --> F[Git checkout<br>ベースブランチ dev]
    F --> G[Node.js 24セットアップ]
    G --> H[npm ci]
    H --> I[npm run build]
    I --> J[npm run test-treeshake]
    J --> K[ベースブランチ<br>サイズ計測]
    K --> L[サイズフォーマット<br>KB単位、差分計算]
    L --> M[既存コメント検索]
    M --> N{既存コメント<br>あり?}
    N -->|Yes| O[コメント更新]
    N -->|No| P[新規コメント作成]
    O --> Q[ワークフロー完了]
    P --> Q
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Artifactなし | read-sizeが失敗 | read-sizeの失敗原因を確認 |
| - | ビルドエラー | ベースブランチのビルドが失敗 | ベースブランチを確認 |
| - | コメント投稿失敗 | 権限不足 | ワークフロー設定を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. GitHub ActionsのUIでエラーログを確認
2. Artifactダウンロードの問題ならread-sizeを確認
3. ベースブランチのビルド問題ならdevブランチを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ワークフロー |
| 目標処理時間 | 5分以内（通常） |
| メモリ使用量上限 | ubuntu-latestランナーの制限内 |

## 排他制御

- 同一PRに対して複数回実行された場合、コメントは更新（edit-mode: replace）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| GitHub context | ジョブ開始時 | GitHubコンテキスト全体（デバッグ用） |
| サイズ計測結果 | 計測完了時 | 各ファイルのサイズ（バイト） |
| フォーマット結果 | フォーマット完了時 | KB単位のサイズ、差分 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー結果 | 失敗時 | GitHub Actions通知 |

## 備考

- ワークフロー名: "Report size"
- ジョブ名: "Comment on PR"
- permissions: pull-requests: write（PRコメント投稿のため）
- 重要: PRコードはチェックアウトしない（セキュリティ対策）
- 参考: https://securitylab.github.com/research/github-actions-preventing-pwn-requests/
- 参考: https://securitylab.github.com/research/github-actions-untrusted-input/
- peter-evans/find-comment@v4で既存コメント検索（author: github-actions[bot]、body-includes: Bundle size）
- peter-evans/create-or-update-comment@v5でコメント投稿/更新
- 環境変数は必ずenvセクション経由で渡す（セキュリティ対策）
- format-size.js、format-diff.jsはtest/treeshake/utils/に存在
