# バッチ設計書 2-npm run build-module

## 概要

本ドキュメントは、three.jsライブラリのモジュール版のみを高速にビルドする `npm run build-module` コマンドの設計仕様を定義します。

### 本バッチの処理概要

このバッチは、three.jsライブラリのESM（ECMAScript Modules）形式のモジュールのみをビルドする処理を行います。フルビルド（npm run build）と比較して、minified版やCommonJS版を生成しないため、開発中の迅速なビルド確認に適しています。

**業務上の目的・背景**：開発者がソースコードを修正した際に、フルビルドを待つことなくモジュール版のみを素早くビルドして動作確認を行いたい場合に使用します。特にウォッチモードでの継続的なビルドと組み合わせることで、開発効率を大幅に向上させることができます。

**バッチの実行タイミング**：開発中の動作確認時、プレビューサーバーとの連携時、またはモジュール版のみが必要なテスト時に随時実行されます。

**主要な処理内容**：
1. Rollup設定ファイルの読み込み（configOnlyModuleフラグ付き）
2. GLSLシェーダーコードの最適化処理
3. ライセンスヘッダーの付与
4. ESM形式でのコアモジュール（three.core.js）のビルド
5. ESM形式でのWebGPU Nodesモジュール（three.webgpu.nodes.js）のビルド
6. ESM形式でのメインモジュール群（three.module.js, three.webgpu.js）のビルド
7. ESM形式でのTSLモジュール（three.tsl.js）のビルド

**前後の処理との関連**：`npm run preview` コマンドの内部でウォッチモード（-w）付きで使用されます。また、開発者が素早くビルド結果を確認したい場合に `npm run build` の代替として使用します。

**影響範囲**：build/ディレクトリ配下のESMモジュール（非圧縮版）のみが生成されます。minified版やCommonJS版は生成されません。

## バッチ種別

ビルド処理 / コード変換（軽量版）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / ウォッチモード |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v18以上がインストールされていること |
| 依存パッケージ | `npm install` により依存パッケージがインストール済みであること |
| ソースコード | src/配下にソースコードが存在すること |

### 実行可否判定

package.jsonが存在し、node_modulesディレクトリが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --configOnlyModule | フラグ | Yes | true（コマンド内で指定済み） | モジュール版のみビルドする |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/Three.Core.js | JavaScript | コアモジュールのエントリポイント |
| src/Three.js | JavaScript | メインモジュールのエントリポイント |
| src/Three.WebGPU.js | JavaScript | WebGPUモジュールのエントリポイント |
| src/Three.WebGPU.Nodes.js | JavaScript | WebGPU Nodesモジュールのエントリポイント |
| src/Three.TSL.js | JavaScript | TSLモジュールのエントリポイント |
| utils/build/rollup.config.js | JavaScript | Rollup設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| build/three.core.js | ESM | コアモジュール（非圧縮） |
| build/three.module.js | ESM | メインモジュール（非圧縮） |
| build/three.webgpu.js | ESM | WebGPUモジュール（非圧縮） |
| build/three.webgpu.nodes.js | ESM | WebGPU Nodesモジュール（非圧縮） |
| build/three.tsl.js | ESM | TSLモジュール（非圧縮） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 上記参照 |
| 出力先 | build/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. Rollup設定ファイルの読み込み
   └─ utils/build/rollup.config.jsを解析（--configOnlyModuleフラグ付き）
2. ビルド設定のフィルタリング
   └─ builds.slice(0, 3)で最初の3つの設定のみ抽出
3. GLSLプラグインによるシェーダー処理
   └─ .glsl.jsファイルのコメント除去・圧縮
4. ヘッダープラグインによるライセンス付与
   └─ 各出力ファイルにMITライセンスヘッダーを追加
5. ESM版コアモジュールのビルド（ビルド設定1）
   └─ three.core.js, three.webgpu.nodes.jsを出力
6. ESM版メインモジュールのビルド（ビルド設定2）
   └─ three.core.js, three.module.js, three.webgpu.jsを出力
7. ESM版TSLモジュールのビルド（ビルド設定3）
   └─ three.tsl.jsを出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[Rollup設定読み込み]
    B --> C[configOnlyModuleフラグ確認]
    C --> D[最初の3設定を抽出]
    D --> E[GLSLシェーダー処理]
    E --> F[ESM版ビルド実行]
    F --> G[ライセンスヘッダー付与]
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイルベースの処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENOENT | ファイル不在 | ソースファイルが見つからない | ソースコードの存在確認 |
| PARSE_ERROR | 構文エラー | JavaScriptの構文エラー | ソースコードの修正 |
| PLUGIN_ERROR | プラグインエラー | Rollupプラグインでのエラー | 設定ファイルの確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

ビルドエラー発生時は、コンソール出力のエラーメッセージを確認し、該当するソースファイルまたは設定ファイルを修正してから再実行します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル出力） |
| コミットタイミング | 各ファイル出力完了時 |
| ロールバック条件 | エラー発生時は出力途中で停止 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 3ビルド設定 × 複数ファイル |
| 目標処理時間 | 30秒以内 |
| メモリ使用量上限 | 1024MB |

## 排他制御

同時実行は許可されていますが、同一出力先への並列書き込みは競合する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ビルド開始時 | Rollup起動メッセージ |
| 進捗ログ | 各ビルド設定処理時 | 出力ファイル名、サイズ |
| 終了ログ | ビルド完了時 | 完了メッセージ |
| エラーログ | エラー発生時 | エラー詳細、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 120秒 | コンソール出力 |
| エラー件数 | 1件以上 | コンソール出力 |

## 備考

- フルビルド（npm run build）の約1/3の処理量
- ウォッチモード（-w）と組み合わせて使用可能
- minified版が不要な開発時に推奨
- builds.slice(0, 3)により最初の3つのビルド設定のみ実行
