# バッチ設計書 20-codeql-code-scanning.yml

## 概要

本ドキュメントは、three.jsプロジェクトにおけるGitHub Actionsワークフロー「CodeQL」の設計仕様を定義する。

### 本バッチの処理概要

GitHubのCodeQL静的解析ツールを使用してJavaScriptコードのセキュリティ脆弱性を検出するワークフローである。週次スケジュールまたはdevブランチへのpush/PRでトリガーされ、セキュリティおよびコード品質の問題を自動検出する。

**業務上の目的・背景**：three.jsは広く使用されているオープンソースライブラリであり、セキュリティ脆弱性が存在すると多数のプロジェクトに影響を与える可能性がある。CodeQLによる自動スキャンを導入することで、潜在的なセキュリティ問題を早期に検出し、安全なコードベースを維持する。また、コード品質の問題も同時に検出することで、メンテナンス性の向上にも寄与する。

**バッチの実行タイミング**：週次スケジュール（日曜23:29 UTC）、devブランチへのpush、devブランチへのPR。

**主要な処理内容**：
1. リポジトリのチェックアウト
2. CodeQL環境の初期化（JavaScript言語設定）
3. コードの自動ビルド
4. CodeQL解析の実行
5. 結果のGitHub Security Eventsへのアップロード

**前後の処理との関連**：独立したセキュリティスキャンワークフロー。検出された問題はGitHub Security tabで確認可能。

**影響範囲**：three.jsソースコード全体（一部サードパーティライブラリを除く）。

## バッチ種別

CI/CD / セキュリティスキャン / GitHub Actions ワークフロー / CodeQL

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 週次 / push / PR |
| 実行時刻 | 23:29 UTC（週次） |
| 実行曜日 | 日曜日（週次） |
| 実行日 | 毎週日曜日 |
| トリガー | schedule / push / pull_request / workflow_dispatch |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHub Advanced Security | CodeQLが使用可能であること |
| ubuntu-latest | ubuntu-latestランナーが使用可能であること |

### 実行可否判定

- scheduleの場合: 指定時刻に自動実行
- pushの場合: devブランチへのpush
- pull_requestの場合: devブランチへのPR
- workflow_dispatchの場合: 手動トリガー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| matrix.language | 文字列 | Yes（自動） | javascript | 解析対象言語 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| リポジトリ全体 | Git | actions/checkout@v6によるチェックアウト |
| .github/codeql-config.yml | YAMLファイル | CodeQL設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Security tab | セキュリティアラート | 検出された脆弱性・問題 |
| GitHub Actions ログ | テキスト | 各ステップの実行結果 |

### 出力ファイル仕様

ファイル出力なし（GitHub Securityへ直接アップロード）

## 処理フロー

### 処理シーケンス

```
1. Checkout repository
   └─ actions/checkout@v6でリポジトリをチェックアウト

2. Initialize CodeQL
   └─ github/codeql-action/init@v4でCodeQL環境を初期化
   └─ 言語: javascript
   └─ 設定ファイル: .github/codeql-config.yml
   └─ クエリ: security-and-quality

3. Autobuild
   └─ github/codeql-action/autobuild@v4で自動ビルド

4. Perform CodeQL Analysis
   └─ github/codeql-action/analyze@v4で解析を実行
   └─ カテゴリ: /language:javascript
```

### フローチャート

```mermaid
flowchart TD
    A[トリガー発生] --> B{トリガー種別}
    B -->|schedule| C[週次: 日曜23:29 UTC]
    B -->|push| D[devブランチへのpush]
    B -->|pull_request| E[devブランチへのPR]
    B -->|workflow_dispatch| F[手動実行]
    C --> G[analyzeジョブ開始]
    D --> G
    E --> G
    F --> G
    G --> H[Git checkout]
    H --> I[CodeQL初期化<br>言語: javascript<br>クエリ: security-and-quality]
    I --> J[Autobuild]
    J --> K[CodeQL解析実行]
    K --> L[結果をGitHub Securityにアップロード]
    L --> M[ワークフロー完了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（データベースを使用しない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | CodeQL初期化エラー | 設定ファイルの問題 | codeql-config.ymlを確認 |
| - | ビルドエラー | Autobuildが失敗 | コードの問題を修正 |
| - | 解析エラー | CodeQLの内部エラー | GitHub Supportに報告 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. GitHub ActionsのUIでエラーログを確認
2. CodeQL設定ファイルの問題であれば修正
3. 繰り返しエラーの場合はGitHub Supportに連絡

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ワークフロー |
| 目標処理時間 | 10-30分（コードベースサイズ依存） |
| メモリ使用量上限 | ubuntu-latestランナーの制限内 |

## 排他制御

- fail-fast: false（複数言語の場合に他をキャンセルしない）

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ステップ開始 | 各ステップ開始時 | ステップ名 |
| 解析結果 | 解析完了時 | 検出された問題数、カテゴリ |
| ステップ完了 | 各ステップ完了時 | 実行時間、成功/失敗 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| セキュリティ問題検出 | 1件以上 | GitHub Security tab、メール通知 |
| ワークフロー結果 | 失敗時 | GitHub Actions通知 |

## 備考

- ワークフロー名: "CodeQL"
- ジョブ名: "Analyze"
- permissions: actions: read, contents: read, security-events: write
- matrix.language: ['javascript']（単一言語）
- クエリ: security-and-quality（セキュリティとコード品質の両方）
- 設定ファイル: .github/codeql-config.yml

### 除外パス（codeql-config.yml）
以下のサードパーティライブラリ・外部コードは解析から除外:
- docs/prettify/**/*.*
- editor/js/libs/**/*.*
- examples/jsm/libs/**/*.*
- examples/jsm/loaders/ifc/**/*.*
- build/*.*
- manual/3rdparty/**/*.*
- utils/docs/template/static/scripts/fuse/**/*.*
- utils/docs/template/static/scripts/prettify/**/*.*

### スケジュール
- cron: '29 23 * * 0' = 毎週日曜日23:29 UTC
- 深夜帯に実行することで、リソース使用が少ない時間帯に解析を行う
