# バッチ設計書 21-protected-folders.yml

## 概要

本ドキュメントは、three.jsプロジェクトにおけるGitHub Actionsワークフロー「Protected Folders Check」の設計仕様を定義するものである。このワークフローはbuild/およびdocs/フォルダへの不正な変更を検出・防止するセキュリティ機能を提供する。

### 本バッチの処理概要

このバッチは、three.jsリポジトリにおけるbuild/とdocs/フォルダへの変更を監視し、権限のないコントリビューターによる変更を自動的にブロックするGitHub Actionsワークフローである。

**業務上の目的・背景**：build/およびdocs/フォルダは、ビルドプロセスやドキュメント生成バッチによって自動生成されるファイルを格納するディレクトリである。これらのフォルダに対する手動変更は、ビルド成果物の整合性を損なう可能性があり、また悪意のあるコードの混入リスクも存在する。このワークフローにより、プロジェクトのセキュリティと成果物の信頼性を維持する。

**バッチの実行タイミング**：Pull Requestがオープンまたは更新され、かつbuild/またはdocs/配下のファイルに変更が含まれている場合に自動的にトリガーされる。イベント駆動型のワークフローであり、スケジュール実行ではない。

**主要な処理内容**：
1. Pull Requestイベントの検出（paths: build/**, docs/**に変更がある場合のみトリガー）
2. PRの作成者の権限レベル（author_association）の確認
3. OWNERまたはCOLLABORATOR以外のユーザーによる変更の場合、エラーメッセージを出力してワークフローを失敗させる

**前後の処理との関連**：このワークフローは他のCI/CDワークフロー（ci.yml等）と並行して実行される。ci.ymlではbuild/とdocs/への変更は明示的にpaths-ignoreで除外されており、これらのフォルダへの変更はこのprotected-folders.ymlでのみ検証される設計となっている。

**影響範囲**：build/およびdocs/フォルダを含むPull Requestのマージ可否に影響する。権限のないコントリビューターのPRは、これらのフォルダへの変更を削除しない限りマージがブロックされる。

## バッチ種別

セキュリティ・アクセス制御 / CI/CDガード処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動（随時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | pull_request イベント（paths: build/**, docs/**） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GitHubリポジトリへのPull Request | Pull Requestがオープンまたは更新されること |
| 対象パスへの変更 | build/またはdocs/配下のファイルに変更が含まれること |

### 実行可否判定

```yaml
on:
  pull_request:
    paths:
      - 'build/**'
      - 'docs/**'
```

Pull Requestイベントで、build/またはdocs/配下に変更が含まれる場合のみワークフローがトリガーされる。変更が含まれない場合はワークフロー自体が実行されない。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| github.event.pull_request.author_association | string | Yes | - | PRの作成者とリポジトリの関係性（OWNER/COLLABORATOR/MEMBER/CONTRIBUTOR/FIRST_TIME_CONTRIBUTOR/NONE等） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| github.event コンテキスト | GitHub API | Pull Requestイベントのメタデータ |
| Pull Requestの差分 | Git diff | build/およびdocs/配下の変更ファイルリスト |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Actions ログ | テキスト | ワークフローの実行結果とエラーメッセージ |
| GitHub PRステータスチェック | API | PRのマージ可否を示すステータス |

### 出力ファイル仕様

ファイル出力は行わない（GitHub Actionsのステータスチェック結果のみ）

## 処理フロー

### 処理シーケンス

```
1. Pull Requestイベントの受信
   └─ paths条件によりbuild/またはdocs/への変更を含むPRのみがトリガー
2. 実行環境のセットアップ
   └─ ubuntu-latestランナーでjobを開始
3. 権限チェック（条件分岐）
   └─ author_associationがOWNERまたはCOLLABORATORかどうかを判定
4a. OWNER/COLLABORATORの場合
   └─ ステップをスキップし、ワークフロー成功
4b. それ以外の場合
   └─ エラーメッセージを出力し、exit 1でワークフロー失敗
```

### フローチャート

```mermaid
flowchart TD
    A[PR作成/更新イベント] --> B{build/ or docs/ に変更あり?}
    B -->|なし| C[ワークフロー未実行]
    B -->|あり| D[ワークフロー開始]
    D --> E{author_association チェック}
    E -->|OWNER| F[ステップスキップ]
    E -->|COLLABORATOR| F
    E -->|その他| G[エラー出力]
    F --> H[ワークフロー成功]
    G --> I[exit 1]
    I --> J[ワークフロー失敗]
    J --> K[PRマージブロック]
```

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| exit 1 | 権限エラー | OWNER/COLLABORATOR以外のユーザーがbuild/またはdocs/を変更した場合 | PRからbuild/およびdocs/への変更を削除する |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（リトライ不可） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

権限エラーによるワークフロー失敗の場合：
1. PRの作成者に対し、build/およびdocs/フォルダへの変更を削除するよう通知する
2. PRから対象ファイルの変更を取り消す（git checkout、git resetなど）
3. 修正後、PRを再度pushすることでワークフローが再実行される

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1 PR/実行 |
| 目標処理時間 | 数秒以内 |
| メモリ使用量上限 | GitHub Actionsランナーのデフォルト制限 |

## 排他制御

同一PRに対する複数回の実行は、GitHub Actionsの標準動作により自動的に管理される。同時実行に関する特別な排他制御は実装されていない（各PR単位で独立して実行される）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | 権限チェック失敗時 | "The 'build' and 'docs' folders are auto-generated and cannot be modified in PRs. Please remove these changes from your PR." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー失敗 | 失敗時 | GitHub PR ステータスチェック（自動） |

## 備考

- このワークフローは最小限の権限（contents: read）のみを要求する
- OWNERおよびCOLLABORATORの権限を持つユーザーは、build/やdocs/への変更をPRに含めることができる（リリースプロセスの一環として）
- ci.ymlではbuild/とdocs/への変更がpaths-ignoreで除外されているため、これらのフォルダへの変更はこのワークフローでのみ検証される
- 自動生成されるフォルダを保護することで、ビルド成果物の改ざんやセキュリティリスクを軽減する
