# バッチ設計書 3-npm run build-docs

## 概要

本ドキュメントは、three.jsライブラリのAPIドキュメントを自動生成する `npm run build-docs` コマンドの設計仕様を定義します。

### 本バッチの処理概要

このバッチは、JSDocツールを使用してthree.jsのソースコードからAPIドキュメントを自動生成する処理を行います。src/ディレクトリとexamples/jsm/ディレクトリのJavaScriptファイルを解析し、JSDocコメントからHTML形式のドキュメントを生成します。

**業務上の目的・背景**：three.jsは多数のクラス・関数・定数を提供する大規模なライブラリであり、開発者がAPIを正しく理解して利用するためには、正確で最新のAPIドキュメントが不可欠です。ソースコードのJSDocコメントから自動的にドキュメントを生成することで、コードとドキュメントの一貫性を保ち、ドキュメントの保守コストを削減します。

**バッチの実行タイミング**：リリース前のドキュメント更新時、APIに変更があった場合、または公式ウェブサイト（threejs.org）のドキュメント更新時に実行されます。

**主要な処理内容**：
1. jsdoc.config.jsonの設定読み込み
2. src/ディレクトリ配下のソースコード解析
3. examples/jsm/ディレクトリ配下のアドオンコード解析
4. 除外対象ファイルのフィルタリング
5. JSDocコメントの抽出とパース
6. HTML形式のドキュメント生成
7. docs/ディレクトリへの出力

**前後の処理との関連**：通常は `npm run build` でライブラリをビルドした後、ドキュメントを更新するために実行します。生成されたドキュメントは公式サイト（threejs.org/docs）で公開されます。

**影響範囲**：docs/ディレクトリ配下のHTMLドキュメントファイルが再生成されます。既存のドキュメントは上書きされます。

## バッチ種別

ドキュメント生成 / コード解析

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / リリース時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v18以上がインストールされていること |
| 依存パッケージ | `npm install` により依存パッケージがインストール済みであること |
| ソースコード | src/配下およびexamples/jsm/配下にソースコードが存在すること |
| JSDoc設定 | utils/docs/jsdoc.config.jsonが存在すること |

### 実行可否判定

package.jsonが存在し、node_modulesディレクトリが存在し、jsdoc.config.jsonが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -c | 文字列 | Yes | utils/docs/jsdoc.config.json | JSDoc設定ファイルのパス |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/ | JavaScript | コアライブラリのソースコード |
| examples/jsm/ | JavaScript | アドオンのソースコード |
| utils/docs/jsdoc.config.json | JSON | JSDoc設定ファイル |
| utils/docs/template/ | テンプレート | ドキュメントテンプレート |
| package.json | JSON | パッケージ情報（バージョン等） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| docs/ | HTML | APIドキュメント |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | クラス名・モジュール名に基づく |
| 出力先 | docs/ |
| 文字コード | UTF-8 |
| 区切り文字 | N/A |

## 処理フロー

### 処理シーケンス

```
1. JSDoc設定ファイルの読み込み
   └─ utils/docs/jsdoc.config.jsonを解析
2. 入力ソースディレクトリの特定
   └─ src/とexamples/jsm/を対象に設定
3. 除外ファイルのフィルタリング
   └─ src/extras/lib, src/renderers/common/extras/PMREMGenerator.js等を除外
4. ソースコードの解析
   └─ JavaScriptファイルを再帰的に走査
5. JSDocコメントの抽出
   └─ @param, @return, @class等のタグを解析
6. ドキュメント生成
   └─ テンプレートを使用してHTMLを生成
7. 出力ディレクトリへの書き込み
   └─ docs/ディレクトリに出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定ファイル読み込み]
    B --> C[ソースディレクトリ特定]
    C --> D[除外ファイルフィルタリング]
    D --> E[ソースコード解析]
    E --> F[JSDocコメント抽出]
    F --> G[HTML生成]
    G --> H[docs/に出力]
    H --> I[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイルベースの処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ENOENT | ファイル不在 | ソースファイルが見つからない | ソースコードの存在確認 |
| CONFIG_ERROR | 設定エラー | jsdoc.config.jsonの構文エラー | 設定ファイルの修正 |
| TEMPLATE_ERROR | テンプレートエラー | テンプレートファイルの問題 | テンプレートの確認 |
| JSDOC_ERROR | JSDocエラー | 不正なJSDocコメント | コメントの修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

JSDocエラー発生時は、コンソール出力の警告・エラーメッセージを確認し、該当するソースファイルのJSDocコメントを修正してから再実行します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル出力） |
| コミットタイミング | 各ファイル出力完了時 |
| ロールバック条件 | エラー発生時は出力途中で停止 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百ファイル |
| 目標処理時間 | 120秒以内 |
| メモリ使用量上限 | 1024MB |

## 排他制御

同時実行は許可されていますが、同一出力先への並列書き込みは競合する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ドキュメント生成開始時 | JSDoc起動メッセージ |
| 進捗ログ | ファイル処理時 | 処理中のファイル名 |
| 警告ログ | 不完全なJSDoc検出時 | 警告内容 |
| 終了ログ | 生成完了時 | 完了メッセージ |
| エラーログ | エラー発生時 | エラー詳細 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 300秒 | コンソール出力 |
| エラー件数 | 1件以上 | コンソール出力 |

## 備考

- JSDoc v4.0.5以上を使用
- カスタムテンプレート（utils/docs/template/）を使用
- Markdownプラグインを使用してMarkdown形式のコメントをサポート
- 除外対象ファイル：
  - src/extras/lib
  - src/renderers/common/extras/PMREMGenerator.js
  - src/renderers/webgpu/WebGPURenderer.Nodes.js
  - examples/jsm/helpers/LightProbeHelperGPU.js
  - examples/jsm/helpers/TextureHelperGPU.js
  - examples/jsm/libs
  - examples/jsm/lines/webgpu
  - examples/jsm/loaders/lwo
  - examples/jsm/materials/LDrawConditionalLineNodeMaterial.js
  - examples/jsm/misc/ProgressiveLightMapGPU.js
  - examples/jsm/modifiers/CurveModifierGPU.js
  - examples/jsm/objects/Water2.js
  - examples/jsm/objects/Water2Mesh.js
  - examples/jsm/offscreen
  - examples/jsm/utils/ShadowMapViewerGPU.js
- themeOpts.ignoreInheritedSymbols: true により継承されたシンボルを無視
