# バッチ設計書 4-npm run dev

## 概要

本ドキュメントは、three.jsの開発用ビルドを作成し開発サーバーを起動する `npm run dev` コマンドの設計仕様を定義します。

### 本バッチの処理概要

このバッチは、開発者がthree.jsを開発する際に使用する環境をセットアップする処理を行います。build/ディレクトリにソースコードへのシンボリックエクスポートを作成し、ポート8080でHTTPサーバーを起動します。これにより、ビルドを待つことなくソースコードの変更を即座に確認できる開発環境を提供します。

**業務上の目的・背景**：three.jsの開発において、フルビルドを実行せずにソースコードの変更を即座に反映させたい場合に使用します。シンボリックエクスポートにより、src/ディレクトリのソースファイルが直接参照されるため、ファイル保存後すぐにブラウザで変更を確認できます。

**バッチの実行タイミング**：開発セッション開始時に一度実行し、開発中は継続して使用します。サーバーはCtrl+Cで停止するまで動作し続けます。

**主要な処理内容**：
1. build/ディレクトリの初期化（既存ディレクトリの削除と再作成）
2. シンボリックエクスポートファイルの作成
   - three.core.js -> src/Three.Core.js
   - three.module.js -> src/Three.js
   - three.tsl.js -> src/Three.TSL.js
   - three.webgpu.js -> src/Three.WebGPU.js
   - three.webgpu.nodes.js -> src/Three.WebGPU.Nodes.js
3. HTTPサーバーの起動（ポート8080）
4. ディレクトリリスティング機能の提供
5. 各種MIMEタイプのファイル配信

**前後の処理との関連**：`npm run start` のエイリアスでもあります。本番ビルドが必要な場合は `npm run build` を使用します。より高度なウォッチモードが必要な場合は `npm run preview` を使用します。

**影響範囲**：build/ディレクトリが初期化され、開発用のエクスポートファイルが作成されます。ローカルのポート8080が使用されます。

## バッチ種別

開発環境セットアップ / サーバー起動

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発セッション開始時） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v18以上がインストールされていること |
| 依存パッケージ | `npm install` により依存パッケージがインストール済みであること |
| ソースコード | src/配下にソースコードが存在すること |
| ポート利用可能 | ポート8080が利用可能であること |

### 実行可否判定

package.jsonが存在し、node_modulesディレクトリが存在し、ポート8080が利用可能な場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -p | 数値 | No | 8080 | HTTPサーバーのポート番号 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/Three.Core.js | JavaScript | コアモジュールのエントリポイント |
| src/Three.js | JavaScript | メインモジュールのエントリポイント |
| src/Three.TSL.js | JavaScript | TSLモジュールのエントリポイント |
| src/Three.WebGPU.js | JavaScript | WebGPUモジュールのエントリポイント |
| src/Three.WebGPU.Nodes.js | JavaScript | WebGPU Nodesモジュールのエントリポイント |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| build/three.core.js | JavaScript | コアモジュールへのエクスポート |
| build/three.module.js | JavaScript | メインモジュールへのエクスポート |
| build/three.tsl.js | JavaScript | TSLモジュールへのエクスポート |
| build/three.webgpu.js | JavaScript | WebGPUモジュールへのエクスポート |
| build/three.webgpu.nodes.js | JavaScript | WebGPU Nodesモジュールへのエクスポート |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 上記参照 |
| 出力先 | build/ |
| 文字コード | UTF-8 |
| 内容形式 | `export * from '../src/...'` 形式のリダイレクト |

## 処理フロー

### 処理シーケンス

```
1. dev.jsの実行開始
   └─ utils/build/dev.jsを実行
2. build/ディレクトリの初期化
   └─ 既存ディレクトリを再帰的に削除し、新規作成
3. エクスポートファイルの生成
   └─ 各モジュールに対して `export * from '../src/...'` を含むファイルを作成
4. HTTPサーバーの起動
   └─ utils/server.jsを実行（ポート8080）
5. サーバー待機状態
   └─ リクエストを受け付け、ファイルを配信
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[dev.js実行]
    B --> C[build/削除]
    C --> D[build/作成]
    D --> E[エクスポートファイル生成]
    E --> F[HTTPサーバー起動]
    F --> G{リクエスト待機}
    G -->|リクエスト受信| H[ファイル配信]
    H --> G
    G -->|Ctrl+C| I[サーバー停止]
    I --> J[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイルベースの処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EADDRINUSE | ポート使用中 | ポート8080が既に使用されている | 既存プロセスを停止するか、別ポートを指定 |
| ENOENT | ファイル不在 | ソースファイルが見つからない | ソースコードの存在確認 |
| EACCES | 権限エラー | ディレクトリへの書き込み権限がない | 権限の確認・修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 最大20回（ポートの自動インクリメント） |
| リトライ間隔 | 即時 |
| リトライ対象エラー | EADDRINUSE（ポート使用中） |

### 障害時対応

ポート使用中の場合、自動的に次のポート番号を試行します（最大20回）。それでも失敗した場合は、エラーメッセージを表示して終了します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル出力） |
| コミットタイミング | 各ファイル出力完了時 |
| ロールバック条件 | build/削除後にエラーが発生した場合は空の状態 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 5ファイル（エクスポート生成） |
| 目標処理時間 | 5秒以内（サーバー起動まで） |
| メモリ使用量上限 | 256MB |

## 排他制御

サーバーが起動中は、同一ポートでの別サーバー起動は不可。ただし、異なるポートでの起動は可能。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | サーバー起動時 | `Server running at http://localhost:8080/` |
| 情報ログ | ポート変更時 | `Port 8080 in use, using 8081 instead.` |
| ネットワークログ | 起動時 | ネットワークインターフェースのIPアドレス |
| 終了ログ | Ctrl+C押下時 | `Shutting down...` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| サーバー応答 | タイムアウト | コンソール出力 |
| ポート競合 | 20回以上 | コンソール出力 |

## 備考

- `npm run start` は `npm run dev` のエイリアス
- dev.jsは非同期でPromise.allを使用して並列にファイルを作成
- サーバーはRange Requestsに対応（動画・音声ファイルのストリーミング対応）
- ディレクトリアクセス時はindex.htmlがあれば表示、なければディレクトリ一覧を表示
- MIMEタイプは拡張子に基づいて自動判定（HTML, JS, CSS, JSON, 画像, 動画, 音声, フォント, 3Dモデル等に対応）
- パストラバーサル攻撃への対策を実装
