# バッチ設計書 5-npm run preview

## 概要

本ドキュメントは、three.jsのプレビュー用ビルドとHTTPサーバーを並列起動する `npm run preview` コマンドの設計仕様を定義します。

### 本バッチの処理概要

このバッチは、RollupのウォッチモードとHTTPサーバーを同時に起動し、ソースコードの変更を自動的に検知してビルドを更新する開発環境を提供します。ファイル変更時に自動再ビルドが行われるため、ブラウザをリロードするだけで最新のビルド結果を確認できます。

**業務上の目的・背景**：`npm run dev` は軽量なエクスポートファイルを使用しますが、本番に近いビルド結果を確認したい場合や、Rollupによるバンドル結果を確認したい場合に `npm run preview` を使用します。ウォッチモードにより、継続的な開発作業を効率化します。

**バッチの実行タイミング**：開発セッションで本番ビルドに近い環境が必要な場合に実行します。サーバーはCtrl+Cで停止するまで動作し続けます。

**主要な処理内容**：
1. preview.jsの実行開始
2. Rollupプロセスの起動（ウォッチモード + インラインソースマップ）
3. HTTPサーバーの起動（ポート8080）
4. 両プロセスの出力をプレフィックス付きで統合表示
5. ファイル変更検知時の自動再ビルド
6. シグナル処理によるクリーンアップ

**前後の処理との関連**：`npm run dev` よりも本番に近いビルド環境を提供します。本番リリース時は `npm run build` でフルビルドを実行します。

**影響範囲**：build/ディレクトリにRollupのビルド成果物が生成されます。ローカルのポート8080が使用されます。

## バッチ種別

開発環境セットアップ / ウォッチモードビルド / サーバー起動

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発セッション中） |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v18以上がインストールされていること |
| 依存パッケージ | `npm install` により依存パッケージがインストール済みであること |
| ソースコード | src/配下にソースコードが存在すること |
| ポート利用可能 | ポート8080が利用可能であること |

### 実行可否判定

package.jsonが存在し、node_modulesディレクトリが存在し、ポート8080が利用可能な場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/Three.Core.js | JavaScript | コアモジュールのエントリポイント |
| src/Three.js | JavaScript | メインモジュールのエントリポイント |
| src/Three.TSL.js | JavaScript | TSLモジュールのエントリポイント |
| src/Three.WebGPU.js | JavaScript | WebGPUモジュールのエントリポイント |
| src/Three.WebGPU.Nodes.js | JavaScript | WebGPU Nodesモジュールのエントリポイント |
| utils/build/rollup.config.js | JavaScript | Rollup設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| build/three.core.js | ESM | コアモジュール（インラインソースマップ付き） |
| build/three.module.js | ESM | メインモジュール（インラインソースマップ付き） |
| build/three.webgpu.js | ESM | WebGPUモジュール（インラインソースマップ付き） |
| build/three.webgpu.nodes.js | ESM | WebGPU Nodesモジュール（インラインソースマップ付き） |
| build/three.tsl.js | ESM | TSLモジュール（インラインソースマップ付き） |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 上記参照 |
| 出力先 | build/ |
| 文字コード | UTF-8 |
| ソースマップ | インライン（-m inline） |

## 処理フロー

### 処理シーケンス

```
1. preview.jsの実行開始
   └─ utils/build/preview.jsを実行
2. ルートディレクトリの特定
   └─ __dirnameから2階層上のディレクトリを取得
3. Rollupプロセスの起動
   └─ npx rollup -c utils/build/rollup.config.js -w -m inline
4. HTTPサーバープロセスの起動
   └─ node utils/server.js -p 8080
5. 出力のプレフィックス処理
   └─ [ROLLUP]と[HTTP]のプレフィックスを付与
6. プロセス監視
   └─ SIGINT/SIGTERMシグナルを監視
7. ファイル変更時
   └─ Rollupが自動的に再ビルドを実行
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[preview.js実行]
    B --> C[ルートディレクトリ特定]
    C --> D[Rollupプロセス起動]
    C --> E[HTTPサーバー起動]
    D --> F{ファイル変更監視}
    E --> G{リクエスト待機}
    F -->|変更検出| H[自動再ビルド]
    H --> F
    G -->|リクエスト| I[ファイル配信]
    I --> G
    F -->|Ctrl+C| J[クリーンアップ]
    G -->|Ctrl+C| J
    J --> K[両プロセス停止]
    K --> L[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイルベースの処理のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| EADDRINUSE | ポート使用中 | ポート8080が既に使用されている | 既存プロセスを停止 |
| PARSE_ERROR | 構文エラー | JavaScriptの構文エラー | ソースコードの修正 |
| PLUGIN_ERROR | プラグインエラー | Rollupプラグインでのエラー | 設定ファイルの確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

Rollupエラー発生時はコンソールに詳細が表示されます。ソースコードを修正して保存すると、自動的に再ビルドが試行されます。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（ファイル出力） |
| コミットタイミング | 各ビルド完了時 |
| ロールバック条件 | ビルドエラー時は前回の成果物を保持 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 初回ビルド + 変更検知ごとの再ビルド |
| 目標処理時間 | 初回30秒以内、再ビルド10秒以内 |
| メモリ使用量上限 | 1024MB |

## 排他制御

サーバーが起動中は、同一ポートでの別サーバー起動は不可。Rollupプロセスは単一で動作。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ROLLUPログ | ビルド処理時 | `[ROLLUP] created build/...`（青背景） |
| HTTPログ | サーバー処理時 | `[HTTP] Server running...`（緑背景） |
| 再ビルドログ | 変更検知時 | `[ROLLUP] bundles build/...` |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ビルドエラー | 発生時 | コンソール出力（ROLLUP） |
| サーバーエラー | 発生時 | コンソール出力（HTTP） |

## 備考

- spawnでRollupとサーバーを子プロセスとして起動
- 両プロセスの標準出力・標準エラー出力をプレフィックス付きで統合
- SIGINT/SIGTERMシグナル受信時に両プロセスをkill
- どちらかのプロセスが終了した場合、もう一方も終了
- インラインソースマップ（-m inline）によりデバッグが容易
- shell: trueでRollupを起動（npxコマンド実行のため）
- shell: falseでサーバーを起動（Node.js直接実行）
