# バッチ設計書 6-npm run lint

## 概要

本ドキュメントは、three.jsのコアソースコードに対してESLintによる静的解析を実行する `npm run lint` コマンドの設計仕様を定義します。

### 本バッチの処理概要

このバッチは、ESLintを使用してthree.jsのコアソースコード（src/ディレクトリ）に対して静的コード解析を実行します。コーディング規約の遵守、潜在的なバグの検出、コード品質の維持を目的としています。

**業務上の目的・背景**：three.jsは多くの開発者がコントリビュートする大規模なオープンソースプロジェクトです。一貫したコードスタイルと高いコード品質を維持するために、静的解析ツールによる自動チェックが不可欠です。ESLintによる検査により、PRマージ前に潜在的な問題を検出し、コードレビューの効率を向上させます。

**バッチの実行タイミング**：CI/CDパイプラインでの自動実行（PR作成時）、ローカル開発時のコード検証、コミット前のチェックとして随時実行されます。

**主要な処理内容**：
1. ESLint設定ファイル（eslint.config.js）の読み込み
2. src/ディレクトリ配下の全JavaScriptファイルの走査
3. 各ファイルに対するルールベースの静的解析
4. 警告・エラーの検出と報告
5. 終了コードによる結果の通知

**前後の処理との関連**：`npm run test` の一部として実行されます。`npm run lint-fix` で自動修正可能な問題を修正できます。CI/CDでは、lintが失敗するとPRがマージできません。

**影響範囲**：src/ディレクトリ配下のJavaScriptファイルのみが対象です。ファイルの変更は行いません（読み取り専用）。

## バッチ種別

静的解析 / コード品質チェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 / CI自動 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / PR作成時 / push時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v18以上がインストールされていること |
| 依存パッケージ | `npm install` により依存パッケージがインストール済みであること |
| ソースコード | src/配下にソースコードが存在すること |
| ESLint設定 | eslint.config.jsが存在すること |

### 実行可否判定

package.jsonが存在し、node_modulesディレクトリが存在し、eslint.config.jsが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 追加パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/ | JavaScript | 解析対象のコアソースコード |
| eslint.config.js | JavaScript | ESLint設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | 警告・エラーメッセージ |
| 終了コード | 数値 | 0: 成功, 1: エラーあり |

### 出力ファイル仕様

ファイル出力なし（コンソール出力のみ）

## 処理フロー

### 処理シーケンス

```
1. ESLint設定の読み込み
   └─ eslint.config.jsを解析
2. 対象ファイルの特定
   └─ src/ディレクトリを再帰的に走査
3. 除外パターンの適用
   └─ node_modules, build, libs等を除外
4. 各ファイルの解析
   └─ 設定されたルールに基づいてチェック
5. 結果の集計
   └─ エラー数、警告数をカウント
6. 結果の出力
   └─ 問題箇所をファイル名・行番号と共に出力
7. 終了コードの設定
   └─ エラーがあれば1、なければ0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定ファイル読み込み]
    B --> C[対象ファイル特定]
    C --> D[除外パターン適用]
    D --> E[各ファイル解析]
    E --> F{エラー/警告あり?}
    F -->|あり| G[問題箇所を出力]
    F -->|なし| H[成功メッセージ]
    G --> I[終了コード1で終了]
    H --> J[終了コード0で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイル読み取りのみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Lintエラー | コードがルールに違反 | ソースコードの修正 |
| CONFIG_ERROR | 設定エラー | eslint.config.jsの問題 | 設定ファイルの修正 |
| ENOENT | ファイル不在 | 対象ファイルが見つからない | パスの確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

Lintエラー発生時は、出力されたエラーメッセージに従ってソースコードを修正するか、`npm run lint-fix` で自動修正を試みます。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百ファイル |
| 目標処理時間 | 60秒以内 |
| メモリ使用量上限 | 512MB |

## 排他制御

同時実行可能。ファイルの読み取りのみのため競合なし。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| エラーログ | ルール違反検出時 | ファイル名、行番号、ルール名、メッセージ |
| 警告ログ | 警告レベル違反検出時 | ファイル名、行番号、ルール名、メッセージ |
| サマリーログ | 処理完了時 | 総エラー数、総警告数 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| エラー件数 | 1件以上 | CI/CD通知 |
| 処理時間 | 120秒 | CI/CD通知 |

## 備考

- ESLint v9.0.0以上を使用（フラットコンフィグ形式）
- 主要なルール設定：
  - `no-throw-literal`: リテラルのthrowを禁止
  - `quotes`: シングルクォートを使用
  - `prefer-const`: constの使用を推奨
  - `no-irregular-whitespace`: 不正な空白を禁止
  - `no-duplicate-imports`: 重複importを禁止
  - `prefer-spread`: スプレッド構文を推奨
  - `jsdoc/check-types`: JSDoc型チェック
- 無効化されているルール：
  - `no-useless-escape`
  - `no-case-declarations`
  - `no-cond-assign`
  - `getter-return`
  - `no-async-promise-executor`
  - `no-empty`
  - `no-fallthrough`
  - `no-prototype-builtins`
  - `no-loss-of-precision`
- eslint-config-mdcs, eslint-plugin-compat, eslint-plugin-html, eslint-plugin-jsdocを使用
- ECMAScript 2018をターゲット
- ブラウザ・Node.js・ES2017のグローバル変数を許可
