# バッチ設計書 7-npm run lint-fix

## 概要

本ドキュメントは、three.jsの全ソースコードに対してESLintによる静的解析と自動修正を実行する `npm run lint-fix` コマンドの設計仕様を定義します。

### 本バッチの処理概要

このバッチは、ESLintを使用してthree.jsの全ソースコードディレクトリに対して静的コード解析を実行し、自動修正可能な問題を修正します。`npm run lint` がコアソースのみを対象とするのに対し、このコマンドはプロジェクト全体（core, addons, examples, docs, editor, playground, manual, test, utils）を対象とします。

**業務上の目的・背景**：three.jsは多くのディレクトリにソースコードが分散しており、全体のコーディング規約を統一的に維持する必要があります。自動修正機能により、開発者が手動で修正する手間を省き、コードスタイルの一貫性を効率的に確保します。

**バッチの実行タイミング**：コーディング規約の変更後、大規模なリファクタリング時、または開発者が一括でコードスタイルを修正したい場合に随時実行されます。

**主要な処理内容**：
1. lint-core --fix の実行（src/）
2. lint-addons --fix の実行（examples/jsm/）
3. lint-examples --fix の実行（examples/）
4. lint-docs --fix の実行（docs関連）
5. lint-editor --fix の実行（editor/）
6. lint-playground --fix の実行（playground/）
7. lint-manual --fix の実行（manual/）
8. lint-test --fix の実行（test/）
9. lint-utils --fix の実行（utils/）

**前後の処理との関連**：`npm run lint` でエラーが検出された場合に、修正可能な問題を自動修正するために使用します。修正後は再度 `npm run lint` を実行して残りの問題を確認します。

**影響範囲**：プロジェクト全体のJavaScript/HTMLファイルが修正対象となります。ファイルが直接変更されるため、実行前にgit statusで変更状態を確認することを推奨します。

## バッチ種別

静的解析 / コード自動修正

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v18以上がインストールされていること |
| 依存パッケージ | `npm install` により依存パッケージがインストール済みであること |
| ソースコード | 対象ディレクトリにソースコードが存在すること |
| ESLint設定 | eslint.config.jsが存在すること |

### 実行可否判定

package.jsonが存在し、node_modulesディレクトリが存在し、eslint.config.jsが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --fix | フラグ | Yes | true（コマンド内で指定済み） | 自動修正を有効化 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/ | JavaScript | コアソースコード |
| examples/jsm/ | JavaScript | アドオンソースコード |
| examples/ | JavaScript/HTML | サンプルコード |
| editor/ | JavaScript | エディタソースコード |
| playground/ | JavaScript | プレイグラウンドソースコード |
| manual/ | JavaScript | マニュアルソースコード |
| test/ | JavaScript | テストソースコード |
| utils/ | JavaScript | ユーティリティソースコード |
| eslint.config.js | JavaScript | ESLint設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 対象ファイル | JavaScript/HTML | 自動修正されたファイル |
| 標準出力 | テキスト | 修正結果・残りの警告・エラー |
| 終了コード | 数値 | 0: 成功, 1: 修正不可エラーあり |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 対象ファイル（上書き） |
| 出力先 | 各対象ディレクトリ |
| 文字コード | UTF-8 |
| 変更内容 | コーディング規約に準拠した修正 |

## 処理フロー

### 処理シーケンス

```
1. lint-core --fix の実行
   └─ eslint src --fix
2. lint-addons --fix の実行
   └─ eslint examples/jsm --fix
3. lint-examples --fix の実行
   └─ eslint examples --fix
4. lint-docs --fix の実行
   └─ eslint docs関連 --fix
5. lint-editor --fix の実行
   └─ eslint editor --fix
6. lint-playground --fix の実行
   └─ eslint playground --fix
7. lint-manual --fix の実行
   └─ eslint manual --fix
8. lint-test --fix の実行
   └─ eslint test --fix
9. lint-utils --fix の実行
   └─ eslint utils --fix
10. 結果の集計と出力
    └─ 修正されたファイル数、残りの問題を表示
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[lint-core --fix]
    B --> C[lint-addons --fix]
    C --> D[lint-examples --fix]
    D --> E[lint-docs --fix]
    E --> F[lint-editor --fix]
    F --> G[lint-playground --fix]
    G --> H[lint-manual --fix]
    H --> I[lint-test --fix]
    I --> J[lint-utils --fix]
    J --> K{修正不可エラーあり?}
    K -->|あり| L[終了コード1で終了]
    K -->|なし| M[終了コード0で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（ファイル操作のみ）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Lintエラー | 自動修正不可能な違反 | 手動でソースコードを修正 |
| CONFIG_ERROR | 設定エラー | eslint.config.jsの問題 | 設定ファイルの修正 |
| ENOENT | ファイル不在 | 対象ファイルが見つからない | パスの確認 |
| EACCES | 権限エラー | ファイルへの書き込み権限がない | 権限の確認・修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

自動修正不可能なエラーが残った場合は、出力されたエラーメッセージに従って手動でソースコードを修正します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各ファイル単位 |
| コミットタイミング | 各ファイル修正完了時 |
| ロールバック条件 | git checkoutで元に戻す |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千ファイル |
| 目標処理時間 | 300秒以内 |
| メモリ使用量上限 | 1024MB |

## 排他制御

同時実行は推奨されません。同一ファイルへの並列修正は競合する可能性があります。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 修正ログ | ファイル修正時 | 修正されたファイル名 |
| エラーログ | 修正不可エラー時 | ファイル名、行番号、ルール名、メッセージ |
| サマリーログ | 処理完了時 | 修正ファイル数、残りエラー数、警告数 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 修正不可エラー件数 | 1件以上 | コンソール出力 |
| 処理時間 | 600秒 | コンソール出力 |

## 備考

- `&&` でコマンドを連結し、前のコマンドが成功した場合のみ次を実行
- 9つのlintコマンドを順次実行
- 各コマンドは独立した対象ディレクトリを持つ
- --fixオプションにより自動修正可能な問題（インデント、セミコロン、クォート等）を修正
- 自動修正不可能な問題（未使用変数、型エラー等）は手動修正が必要
- 実行前にgit stashまたはコミットを推奨
- 大量の変更が発生する可能性があるため、diff確認を推奨
