# バッチ設計書 8-npm run test

## 概要

本ドキュメントは、three.jsのリントと単体テストを一括実行する `npm run test` コマンドの設計仕様を定義します。

### 本バッチの処理概要

このバッチは、three.jsの品質保証のための複合テストスイートを実行します。ESLintによる静的解析（lint）、コアライブラリの単体テスト（test-unit）、アドオンの単体テスト（test-unit-addons）を順次実行し、コード品質とテストの成功を確認します。

**業務上の目的・背景**：three.jsのコード品質を維持するために、コーディング規約の遵守と機能の正常動作を統合的に検証する必要があります。このコマンドは、CI/CDパイプラインでの品質ゲートとして機能し、PRマージ前の必須チェックとなっています。

**バッチの実行タイミング**：CI/CDパイプラインでの自動実行（PR作成時・push時）、ローカル開発時のコード検証、コミット前の品質チェックとして随時実行されます。

**主要な処理内容**：
1. `npm run lint` の実行（ESLintによるコア静的解析）
2. `npm run test-unit` の実行（QUnitによるコア単体テスト）
3. `npm run test-unit-addons` の実行（QUnitによるアドオン単体テスト）

**前後の処理との関連**：`npm run build` でビルドを行った後にテストを実行することが多いです。GitHub ActionsのCI/CDでは、このコマンドがtestジョブとして実行されます。

**影響範囲**：ファイルの変更は行いません（読み取り専用）。テスト結果に基づいて終了コードが設定され、CI/CDの成功/失敗を決定します。

## バッチ種別

統合テスト / 品質保証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 / CI自動 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / PR作成時 / push時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v18以上（CI環境ではv24）がインストールされていること |
| 依存パッケージ | `npm install` により依存パッケージがインストール済みであること |
| ソースコード | src/配下にソースコードが存在すること |
| テストコード | test/unit/配下にテストコードが存在すること |

### 実行可否判定

package.jsonが存在し、node_modulesディレクトリが存在し、test/unit/配下にテストファイルが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 追加パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/ | JavaScript | 解析・テスト対象のコアソースコード |
| test/unit/three.source.unit.js | JavaScript | コアテストのエントリポイント |
| test/unit/three.addons.unit.js | JavaScript | アドオンテストのエントリポイント |
| eslint.config.js | JavaScript | ESLint設定ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | テスト結果、警告・エラーメッセージ |
| 終了コード | 数値 | 0: 全成功, 1: 失敗あり |

### 出力ファイル仕様

ファイル出力なし（コンソール出力のみ）

## 処理フロー

### 処理シーケンス

```
1. lint の実行
   └─ eslint src を実行
   └─ エラーがあれば終了コード1で中断
2. test-unit の実行
   └─ qunit test/unit/three.source.unit.js を実行
   └─ エラーがあれば終了コード1で中断
3. test-unit-addons の実行
   └─ qunit test/unit/three.addons.unit.js を実行
   └─ エラーがあれば終了コード1で終了
4. 結果の出力
   └─ 全テスト成功で終了コード0
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[npm run lint]
    B --> C{lint成功?}
    C -->|失敗| D[終了コード1で終了]
    C -->|成功| E[npm run test-unit]
    E --> F{test-unit成功?}
    F -->|失敗| D
    F -->|成功| G[npm run test-unit-addons]
    G --> H{test-unit-addons成功?}
    H -->|失敗| D
    H -->|成功| I[終了コード0で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（読み取り専用）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | Lintエラー | コードがルールに違反 | ソースコードの修正 |
| 1 | テスト失敗 | アサーションが失敗 | テストまたはソースの修正 |
| 1 | テストエラー | テスト実行時の例外 | テストコードの修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

いずれかのステップで失敗した場合、後続のステップは実行されません。出力されたエラーメッセージに従って問題を修正し、再実行します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | lint: 数百ファイル, test: 数百テストケース |
| 目標処理時間 | 180秒以内 |
| メモリ使用量上限 | 1024MB |

## 排他制御

同時実行可能。読み取り専用のため競合なし。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| Lintログ | lint実行時 | エラー・警告の詳細 |
| テストログ | テスト実行時 | テストケース名、結果 |
| サマリーログ | 各ステップ完了時 | 成功/失敗数、経過時間 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 失敗テスト数 | 1件以上 | CI/CD通知 |
| 処理時間 | 300秒 | CI/CD通知 |

## 備考

- `&&` でコマンドを連結し、前のコマンドが成功した場合のみ次を実行
- 3つのコマンドを順次実行: lint -> test-unit -> test-unit-addons
- CI/CD（GitHub Actions）ではubuntu-latest環境、Node.js 24で実行
- QUnit v2.19.4以上を使用
- テストはヘッドレス環境で実行（ブラウザ不要）
- 失敗した場合、PRはマージ不可
- E2Eテスト（test-e2e）は別のジョブで実行されるため、このコマンドには含まれない
