# バッチ設計書 9-npm run test-unit

## 概要

本ドキュメントは、three.jsコアライブラリの単体テストを実行する `npm run test-unit` コマンドの設計仕様を定義します。

### 本バッチの処理概要

このバッチは、QUnitテストフレームワークを使用してthree.jsコアライブラリの単体テストを実行します。src/ディレクトリ配下の各モジュール（animation, audio, cameras, core, extras, geometries, helpers, lights, loaders, materials, math, objects, renderers, scenes, textures）に対応するテストを実行し、機能の正常動作を検証します。

**業務上の目的・背景**：three.jsは3Dグラフィックスの基盤となるライブラリであり、各クラス・関数が正しく動作することが重要です。単体テストにより、リグレッション（退行）を防ぎ、コード変更が既存機能に影響を与えていないことを確認します。

**バッチの実行タイミング**：CI/CDパイプラインでの自動実行（PR作成時・push時）、ローカル開発時のコード検証、機能追加・修正後の動作確認として随時実行されます。

**主要な処理内容**：
1. QUnitテストランナーの初期化
2. テストエントリポイント（three.source.unit.js）の読み込み
3. 各モジュールのテストファイルのインポート
4. テストスイートの実行
5. アサーション結果の集計と報告

**前後の処理との関連**：`npm run test` の一部として `npm run lint` の後に実行されます。単独で実行することも可能です。`npm run test-unit-addons` と合わせてライブラリ全体のテストを構成します。

**影響範囲**：ファイルの変更は行いません（読み取り専用）。テスト結果に基づいて終了コードが設定されます。

## バッチ種別

単体テスト / 品質保証

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時 / CI自動 |
| 実行時刻 | 指定なし |
| 実行曜日 | 指定なし |
| 実行日 | 指定なし |
| トリガー | 手動 / PR作成時 / push時 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js環境 | Node.js v18以上がインストールされていること |
| 依存パッケージ | `npm install` により依存パッケージがインストール済みであること |
| ソースコード | src/配下にソースコードが存在すること |
| テストコード | test/unit/配下にテストコードが存在すること |

### 実行可否判定

package.jsonが存在し、node_modulesディレクトリが存在し、test/unit/three.source.unit.jsが存在する場合に実行可能。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| なし | - | - | - | 追加パラメータなし |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| test/unit/three.source.unit.js | JavaScript | テストエントリポイント |
| test/unit/src/**/*.tests.js | JavaScript | 各モジュールのテストファイル |
| test/unit/utils/console-wrapper.js | JavaScript | コンソールラッパー |
| test/unit/utils/qunit-utils.js | JavaScript | QUnitユーティリティ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | テスト結果、成功/失敗の詳細 |
| 終了コード | 数値 | 0: 全成功, 1: 失敗あり |

### 出力ファイル仕様

ファイル出力なし（コンソール出力のみ）

## 処理フロー

### 処理シーケンス

```
1. QUnitテストランナーの起動
   └─ qunit test/unit/three.source.unit.js を実行
2. ユーティリティのロード
   └─ console-wrapper.js, qunit-utils.js をインポート
3. テストモジュールのロード
   └─ 各src/配下のモジュールに対応するテストをインポート
4. テストスイートの実行
   └─ 各テストケースを順次実行
5. アサーション評価
   └─ 期待値と実際値を比較
6. 結果の集計
   └─ 成功/失敗数をカウント
7. 結果の出力
   └─ サマリーを表示し、終了コードを設定
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[QUnit起動]
    B --> C[ユーティリティロード]
    C --> D[テストモジュールロード]
    D --> E[テスト実行]
    E --> F{全テスト成功?}
    F -->|成功| G[終了コード0で終了]
    F -->|失敗| H[失敗詳細を出力]
    H --> I[終了コード1で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（読み取り専用）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | テスト失敗 | アサーションが失敗 | テストまたはソースの修正 |
| 1 | テストエラー | テスト実行時の例外 | テストコードの修正 |
| ENOENT | ファイル不在 | テストファイルが見つからない | パスの確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

### 障害時対応

テスト失敗時は、出力された失敗詳細を確認し、該当するソースコードまたはテストコードを修正して再実行します。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | N/A（読み取り専用） |
| コミットタイミング | N/A |
| ロールバック条件 | N/A |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 約200テストファイル、数千アサーション |
| 目標処理時間 | 60秒以内 |
| メモリ使用量上限 | 512MB |

## 排他制御

同時実行可能。読み取り専用のため競合なし。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| モジュールログ | 各モジュールテスト開始時 | モジュール名 |
| テストログ | 各テストケース実行時 | テストケース名、結果 |
| 失敗ログ | アサーション失敗時 | 期待値、実際値、スタックトレース |
| サマリーログ | 全テスト完了時 | 総テスト数、成功数、失敗数、経過時間 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 失敗テスト数 | 1件以上 | CI/CD通知 |
| 処理時間 | 120秒 | CI/CD通知 |

## 備考

- QUnit v2.19.4以上を使用
- テスト対象モジュール（主要なもの）：
  - animation: AnimationAction, AnimationClip, AnimationMixer, KeyframeTrack等
  - audio: Audio, AudioAnalyser, AudioContext, AudioListener等
  - cameras: ArrayCamera, Camera, CubeCamera, OrthographicCamera, PerspectiveCamera等
  - core: BufferAttribute, BufferGeometry, Clock, EventDispatcher, Object3D, Raycaster等
  - extras: DataUtils, Earcut, ImageUtils, PMREMGenerator, ShapeUtils, Curve系等
  - geometries: BoxGeometry, SphereGeometry, その他すべてのGeometry
  - helpers: ArrowHelper, AxesHelper, BoxHelper等
  - lights: AmbientLight, DirectionalLight, PointLight, SpotLight等
  - loaders: AnimationLoader, BufferGeometryLoader, ImageLoader, MaterialLoader等
  - materials: MeshBasicMaterial, MeshStandardMaterial, ShaderMaterial等
  - math: Box2, Box3, Color, Euler, Matrix3, Matrix4, Quaternion, Vector2, Vector3, Vector4等
  - objects: Bone, Group, InstancedMesh, Line, Mesh, Points, Skeleton, SkinnedMesh等
  - renderers: WebGLRenderer, WebGLRenderTarget, シェーダー関連等
  - scenes: Fog, FogExp2, Scene
  - textures: CanvasTexture, CubeTexture, DataTexture, Texture, VideoTexture等
- ヘッドレス環境で実行（ブラウザ不要）
- ES Modulesをサポート
