---
generated_at: 2026-01-27 12:55:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-npm_run_build.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間60秒以内**：実測値に基づかない推定値
  2. **メモリ使用量上限2048MB**：明示的な設定なし
  3. **処理時間閾値300秒**：CI設定での明示的定義なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scriptsセクション
- E-02: `utils/build/rollup.config.js` - Rollup設定ファイル
- E-03: `utils/build/rollup.config.js` - glsl()プラグイン定義（4-36行目）
- E-04: `utils/build/rollup.config.js` - header()プラグイン定義（38-61行目）
- E-05: `utils/build/rollup.config.js` - builds配列（66-199行目）
- E-06: `utils/build/rollup.config.js` - configOnlyModule条件（201行目）
- E-07: `package.json` - devDependencies（rollup, @rollup/plugin-terser等）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npm run buildコマンドはRollupを使用する | E-01, E-02 | ○ |
| C-02 | GLSLシェーダーコードのコメント除去・圧縮を行う | E-03 | ○ |
| C-03 | MITライセンスヘッダーを付与する | E-04 | ○ |
| C-04 | ESM形式でコアモジュールを出力する | E-05 | ○ |
| C-05 | three.core.jsをビルド出力する | E-05 | ○ |
| C-06 | three.module.jsをビルド出力する | E-05 | ○ |
| C-07 | three.webgpu.jsをビルド出力する | E-05 | ○ |
| C-08 | three.webgpu.nodes.jsをビルド出力する | E-05 | ○ |
| C-09 | three.tsl.jsをビルド出力する | E-05 | ○ |
| C-10 | minified版を生成する | E-05 | ○ |
| C-11 | terserプラグインで圧縮する | E-05, E-07 | ○ |
| C-12 | CommonJS形式（three.cjs）を出力する | E-05 | ○ |
| C-13 | --configOnlyModuleで最初の3設定のみビルド | E-06 | ○ |
| C-14 | three.tsl.jsはthree/webgpuを外部依存とする | E-05 | ○ |
| C-15 | ライセンスヘッダーに2010-2026年を含む | E-04 | ○ |
| C-16 | ライセンスヘッダーにSPDX-License-Identifierを含む | E-04 | ○ |
| C-17 | 7つのビルド設定が存在する | E-05 | ○ |
| C-18 | MagicStringでGLSL文字列を操作する | E-03, E-07 | ○ |
| C-19 | src/Three.Core.jsがコアのエントリポイント | E-05 | ○ |
| C-20 | src/Three.jsがメインのエントリポイント | E-05 | ○ |
| C-21 | src/Three.WebGPU.jsがWebGPUのエントリポイント | E-05 | ○ |
| C-22 | build/ディレクトリに出力される | E-05 | ○ |
| C-23 | Rollup v4.6.0以上を使用 | E-07 | ○ |
| C-24 | @rollup/plugin-terser v0.4.0以上を使用 | E-07 | ○ |
| C-25 | 目標処理時間は60秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間60秒の根拠が明示されていない
  - 候補：CI実行ログ / パフォーマンステスト結果 / ベンチマーク

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックは設定ファイルに明記されており信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] builds配列の7設定が正確に記載されているか確認
- [ ] 出力ファイル一覧がrollup.config.jsと一致するか確認
- [ ] パフォーマンス要件が実運用に適切か確認
