---
generated_at: 2026-01-27 13:04:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：10-npm_run_test-unit-addons.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間30秒以内**：実測値に基づかない推定値
  2. **テストカバレッジが部分的**：具体的なカバレッジ率は未確認
  3. **アサーション数「数十」**：正確な数は未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scriptsセクション（test-unit-addons定義）
- E-02: `test/unit/three.addons.unit.js` - テストエントリポイント全体
- E-03: `test/unit/three.addons.unit.js` - BufferGeometryUtils.tests.jsのimport
- E-04: `test/unit/three.addons.unit.js` - ColorSpaces.tests.jsのimport
- E-05: `test/unit/three.addons.unit.js` - NURBSCurve.tests.jsのimport
- E-06: `test/unit/three.addons.unit.js` - USDZExporter.tests.jsのimport
- E-07: `package.json` - devDependencies（qunit v2.19.4）
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ説明

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npm run test-unit-addonsコマンドが存在する | E-01 | ○ |
| C-02 | qunit test/unit/three.addons.unit.jsを実行 | E-01 | ○ |
| C-03 | three.addons.unit.jsがエントリポイント | E-02 | ○ |
| C-04 | BufferGeometryUtils.tests.jsをインポート | E-03 | ○ |
| C-05 | ColorSpaces.tests.jsをインポート | E-04 | ○ |
| C-06 | NURBSCurve.tests.jsをインポート | E-05 | ○ |
| C-07 | USDZExporter.tests.jsをインポート | E-06 | ○ |
| C-08 | 4つのテストファイルを含む | E-02 | ○ |
| C-09 | QUnit v2.19.4以上を使用 | E-07 | ○ |
| C-10 | ファイルの変更は行わない | E-01 | ○ |
| C-11 | 終了コード0は全成功を示す | E-01 | ○ |
| C-12 | ヘッドレス環境で実行 | E-08 | ○ |
| C-13 | ES Modulesをサポート | E-02 | ○ |
| C-14 | コアテストより少ないテスト数 | E-02 | ○ |
| C-15 | テストカバレッジは部分的 | E-02 | ○ |
| C-16 | 目標処理時間は30秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間30秒の根拠が明示されていない
  - 候補：CI実行ログ / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックはソースコードに明記されており信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] テストエントリポイントのimport一覧が正確か確認
- [ ] 4つのテストファイルパスが正確か確認
- [ ] アドオンテストの範囲が適切か確認
