---
generated_at: 2026-01-27 13:03:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-report-size.yml.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/report-size.yml` - ワークフロー定義
- E-02: `package.json` - npm scripts定義
- E-03: `バッチ一覧.csv` - バッチ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ワークフロー名は"Report size" | E-01 (line 1) | ○ |
| C-02 | workflow_runでトリガー | E-01 (line 3) | ○ |
| C-03 | workflows: ["Read size"] | E-01 (line 5) | ○ |
| C-04 | types: completed | E-01 (line 7) | ○ |
| C-05 | permissions: pull-requests: write | E-01 (lines 14-15) | ○ |
| C-06 | ジョブ名は"Comment on PR" | E-01 (line 19) | ○ |
| C-07 | workflow_run.event == 'pull_request'条件 | E-01 (line 21) | ○ |
| C-08 | workflow_run.conclusion == 'success'条件 | E-01 (line 22) | ○ |
| C-09 | actions/github-script@v8でArtifactダウンロード | E-01 (line 32) | ○ |
| C-10 | sizes.zipを解凍 | E-01 (line 53) | ○ |
| C-11 | actions/checkout@v6でベースブランチをチェックアウト | E-01 (line 59) | ○ |
| C-12 | Node.js 24を使用 | E-01 (line 63) | ○ |
| C-13 | npm ciで依存関係インストール | E-01 (line 66) | ○ |
| C-14 | npm run buildでフルビルド | E-01 (lines 67-68) | ○ |
| C-15 | npm run test-treeshakeでtree-shakingテスト | E-01 (lines 69-70) | ○ |
| C-16 | statコマンドでベースブランチサイズ取得 | E-01 (lines 74-93) | ○ |
| C-17 | format-size.jsでサイズフォーマット | E-01 (lines 156-196) | ○ |
| C-18 | format-diff.jsで差分フォーマット | E-01 (lines 160-168, etc.) | ○ |
| C-19 | 環境変数経由でサイズを渡す | E-01 (lines 131-154) | ○ |
| C-20 | peter-evans/find-comment@v4で既存コメント検索 | E-01 (line 241) | ○ |
| C-21 | comment-author: github-actions[bot] | E-01 (line 245) | ○ |
| C-22 | body-includes: Bundle size | E-01 (line 246) | ○ |
| C-23 | peter-evans/create-or-update-comment@v5でコメント投稿 | E-01 (line 248) | ○ |
| C-24 | edit-mode: replace | E-01 (line 252) | ○ |
| C-25 | コメント本文にBefore/After/Diff表を含む | E-01 (lines 253-272) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ワークフロー定義から完全に処理内容を把握可能
- 0: 低リスク - セキュリティ対策（環境変数経由、PRコード非チェックアウト）が適切

## 6) レビュアーチェックリスト（最小）
- [ ] コメント投稿権限が適切に設定されているか確認
- [ ] 既存コメントの検索条件が正しく機能しているか確認
- [ ] サイズフォーマットが読みやすい形式になっているか確認
