---
generated_at: 2026-01-27 12:56:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：2-npm_run_build-module.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間30秒以内**：実測値に基づかない推定値
  2. **メモリ使用量上限1024MB**：明示的な設定なし
  3. **npm run previewでの使用**：preview.jsでは異なるコマンドを使用

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `package.json` - scriptsセクション（build-module定義）
- E-02: `utils/build/rollup.config.js` - export default関数（201行目）
- E-03: `utils/build/rollup.config.js` - builds配列（66-123行目、最初の3設定）
- E-04: `utils/build/rollup.config.js` - glsl()プラグイン定義
- E-05: `utils/build/rollup.config.js` - header()プラグイン定義
- E-06: `utils/build/preview.js` - ウォッチモード実行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | npm run build-moduleコマンドが存在する | E-01 | ○ |
| C-02 | --configOnlyModuleフラグを使用する | E-01, E-02 | ○ |
| C-03 | builds.slice(0, 3)で最初の3設定を抽出 | E-02 | ○ |
| C-04 | three.core.jsを出力する | E-03 | ○ |
| C-05 | three.module.jsを出力する | E-03 | ○ |
| C-06 | three.webgpu.jsを出力する | E-03 | ○ |
| C-07 | three.webgpu.nodes.jsを出力する | E-03 | ○ |
| C-08 | three.tsl.jsを出力する | E-03 | ○ |
| C-09 | GLSLシェーダー処理を行う | E-04 | ○ |
| C-10 | ライセンスヘッダーを付与する | E-05 | ○ |
| C-11 | minified版を生成しない | E-02, E-03 | ○ |
| C-12 | CommonJS版を生成しない | E-02, E-03 | ○ |
| C-13 | ESM形式で出力する | E-03 | ○ |
| C-14 | npm run previewでウォッチモード付きで使用される | E-06 | ○ |
| C-15 | フルビルドの約1/3の処理量 | E-02 | ○ |
| C-16 | build/ディレクトリに出力される | E-03 | ○ |
| C-17 | 3つのビルド設定が実行される | E-02 | ○ |
| C-18 | 目標処理時間は30秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 目標処理時間30秒の根拠が明示されていない
  - 候補：開発時の実測値 / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理ロジックは設定ファイルに明記されており信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] --configOnlyModuleフラグの動作が正確に記載されているか確認
- [ ] 出力ファイル一覧が最初の3設定と一致するか確認
- [ ] npm run previewとの関係性が正確か確認
