---
generated_at: 2026-01-27 13:04:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-codeql-code-scanning.yml.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/codeql-code-scanning.yml` - ワークフロー定義
- E-02: `.github/codeql-config.yml` - CodeQL設定ファイル
- E-03: `バッチ一覧.csv` - バッチ定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ワークフロー名は"CodeQL" | E-01 (line 1) | ○ |
| C-02 | pushでdevブランチにトリガー | E-01 (lines 4-5) | ○ |
| C-03 | pull_requestでdevブランチにトリガー | E-01 (lines 6-8) | ○ |
| C-04 | scheduleでcron: '29 23 * * 0' | E-01 (lines 9-10) | ○ |
| C-05 | workflow_dispatchでトリガー可能 | E-01 (line 11) | ○ |
| C-06 | ジョブ名は"Analyze" | E-01 (line 14) | ○ |
| C-07 | ubuntu-latestで実行 | E-01 (line 15) | ○ |
| C-08 | permissions: actions: read, contents: read, security-events: write | E-01 (lines 16-19) | ○ |
| C-09 | fail-fast: false | E-01 (line 22) | ○ |
| C-10 | matrix.language: ['javascript'] | E-01 (line 24) | ○ |
| C-11 | actions/checkout@v6を使用 | E-01 (line 28) | ○ |
| C-12 | github/codeql-action/init@v4でCodeQL初期化 | E-01 (line 32) | ○ |
| C-13 | 設定ファイル: .github/codeql-config.yml | E-01 (line 35) | ○ |
| C-14 | クエリ: security-and-quality | E-01 (line 36) | ○ |
| C-15 | github/codeql-action/autobuild@v4でAutobuild | E-01 (line 39) | ○ |
| C-16 | github/codeql-action/analyze@v4で解析実行 | E-01 (line 42) | ○ |
| C-17 | カテゴリ: /language:javascript | E-01 (line 44) | ○ |
| C-18 | docs/prettify/**/*.*を除外 | E-02 (line 2) | ○ |
| C-19 | editor/js/libs/**/*.*を除外 | E-02 (line 3) | ○ |
| C-20 | examples/jsm/libs/**/*.*を除外 | E-02 (line 4) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ワークフロー定義とCodeQL設定から完全に処理内容を把握可能
- 0: 低リスク - 除外パスが明確に定義されている

## 6) レビュアーチェックリスト（最小）
- [ ] CodeQL設定の除外パスが適切か確認（サードパーティのみ除外）
- [ ] セキュリティ問題が検出された場合のレビュープロセスが確立されているか確認
- [ ] 週次スケジュールの時刻が適切か確認
